/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class QuerySplitter {
    public static Log log = LogFactory.getLog(QueryEngine.class);
    private KnowledgeBase kb;
    private Query oldQuery;
    private Query newQuery;
    private Set addedVars;
    private Set addedPatterns;

    public List split(Query query) {
        try {
            ArrayList<Query> queries = new ArrayList<Query>();
            this.kb = query.getKB();
            this.oldQuery = query;
            this.addedVars = new HashSet();
            this.addedPatterns = new HashSet();
            Set constants = this.oldQuery.getConstants();
            Set vars = this.oldQuery.getObjVars();
            Set distVars = this.oldQuery.getDistVars();
            HashSet resultVars = new HashSet(this.oldQuery.getResultVars());
            if (log.isDebugEnabled()) {
                log.debug((Object)this.oldQuery);
            }
            for (ATermAppl val : constants) {
                if (this.addedVars.contains(val)) continue;
                this.newQuery = new QueryImpl(this.kb);
                this.addVar(val);
                queries.add(this.newQuery);
                for (ATermAppl var : this.newQuery.getVars()) {
                    if (distVars.contains(var)) {
                        this.newQuery.addDistVar(var);
                    }
                    if (!resultVars.contains(var)) continue;
                    this.newQuery.addResultVar(var);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)this.newQuery);
            }
            for (ATermAppl var2 : vars) {
                if (this.addedVars.contains(var2)) continue;
                this.newQuery = new QueryImpl(this.kb);
                this.addVar(var2);
                queries.add(this.newQuery);
                for (ATermAppl var2 : this.newQuery.getVars()) {
                    if (distVars.contains(var2)) {
                        this.newQuery.addDistVar(var2);
                    }
                    if (!resultVars.contains(var2)) continue;
                    this.newQuery.addResultVar(var2);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)this.newQuery);
            }
            return queries;
        }
        catch (RuntimeException e) {
            log.warn((Object)"Query split failed, continuing with query execution.");
            if (log.isDebugEnabled()) {
                log.debug((Object)this.oldQuery);
                log.debug((Object)this.newQuery);
            }
            return Collections.singletonList(query);
        }
    }

    private void addVar(ATermAppl var) {
        LinkedHashSet<ATermAppl> neighbors;
        ArrayList<ATermAppl[]> patterns;
        block10: {
            boolean isConstant;
            ArrayList<ATermAppl> inferredTypes;
            block9: {
                boolean isLiteral;
                if (this.addedVars.contains(var)) {
                    return;
                }
                this.addedVars.add(var);
                inferredTypes = new ArrayList<ATermAppl>();
                patterns = new ArrayList<ATermAppl[]>();
                neighbors = new LinkedHashSet<ATermAppl>();
                List outList = this.oldQuery.findPatterns(var, null, null);
                for (QueryPattern pattern : outList) {
                    ATermAppl pred = pattern.getPredicate();
                    ATermAppl obj = pattern.getObject();
                    inferredTypes.addAll(this.kb.getDomains(pred));
                    if (this.addedPatterns.contains(pattern)) continue;
                    this.addedPatterns.add(pattern);
                    patterns.add(new ATermAppl[]{var, pred, obj});
                    neighbors.add(obj);
                }
                List inList = this.oldQuery.findPatterns(null, null, var);
                for (QueryPattern pattern : inList) {
                    ATermAppl subj = pattern.getSubject();
                    ATermAppl pred = pattern.getPredicate();
                    inferredTypes.addAll(this.kb.getRanges((ATerm)pred));
                    if (this.addedPatterns.contains(pattern)) continue;
                    this.addedPatterns.add(pattern);
                    patterns.add(new ATermAppl[]{subj, pred, var});
                    neighbors.add(subj);
                }
                isConstant = !ATermUtils.isVar(var);
                boolean bl = isLiteral = this.oldQuery.getLitVars().contains(var) || ATermUtils.isLiteral(var);
                if (!isLiteral) break block9;
                Datatype datatype = this.oldQuery.getDatatype(var);
                this.newQuery.addConstraint(var, datatype);
                break block10;
            }
            ATermAppl nominal = isConstant ? ATermUtils.makeValue((ATerm)var) : null;
            ATermList classes = this.oldQuery.getClasses(var);
            while (!classes.isEmpty()) {
                block11: {
                    ATermAppl c;
                    block12: {
                        block13: {
                            c = (ATermAppl)classes.getFirst();
                            if (c == nominal) break block11;
                            if (!PelletOptions.SIMPLIFY_QUERY) break block12;
                            if (!this.kb.isClassified()) break block13;
                            Set<ATermAppl> subs = this.kb.getTaxonomy().getFlattenedSubs(c, false);
                            Set<ATermAppl> eqs = this.kb.getAllEquivalentClasses(c);
                            if (!SetUtils.intersects(inferredTypes, subs) && !SetUtils.intersects(inferredTypes, eqs)) break block12;
                            break block11;
                        }
                        if (inferredTypes.contains(c)) break block11;
                    }
                    this.newQuery.addTypePattern(var, c);
                }
                classes = classes.getNext();
            }
        }
        for (ATermAppl[] pattern : patterns) {
            this.newQuery.addEdgePattern(pattern[0], pattern[1], pattern[2]);
        }
        for (ATermAppl neighbor : neighbors) {
            this.addVar(neighbor);
        }
    }
}

