/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.TBoxBase;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TuBox
extends TBoxBase {
    protected Map unfoldedcache = new HashMap();
    protected Set unfoldMisses = new HashSet();
    static int resets = 0;
    static int createtime = 0;
    private Map<ATermAppl, List<Pair<ATermAppl, Set<ATermAppl>>>> unfoldingMap;
    private Collection<ATermAppl> termsToNormalize = null;

    public TuBox(KnowledgeBase kb) {
        super(kb);
    }

    @Override
    public boolean addDef(ATermAppl axiom) {
        boolean added = false;
        ATermAppl name = (ATermAppl)axiom.getArgument(0);
        TermDefinition td = this.getTD((ATerm)name);
        if (td == null) {
            td = new TermDefinition();
            this.termhash.put(name, td);
        }
        if ((added = td.addDef(axiom)) && this.termsToNormalize != null) {
            this.termsToNormalize.add(name);
        }
        return added;
    }

    @Override
    public boolean removeDef(ATermAppl axiom) {
        boolean removed = super.removeDef(axiom);
        if (removed && this.termsToNormalize != null) {
            this.termsToNormalize.add((ATermAppl)axiom.getArgument(0));
        }
        return removed;
    }

    public void updateDef(ATermAppl axiom) {
        ATermAppl c = (ATermAppl)axiom.getArgument(0);
        if (ATermUtils.isPrimitive(c)) {
            this.termsToNormalize.add(c);
        }
    }

    public List<Pair<ATermAppl, Set<ATermAppl>>> unfold(ATermAppl c) {
        return this.unfoldingMap.get(c);
    }

    public void normalize(TBox tbox) {
        if (this.termsToNormalize == null) {
            this.termsToNormalize = this.termhash.keySet();
            this.unfoldingMap = new HashMap<ATermAppl, List<Pair<ATermAppl, Set<ATermAppl>>>>();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Normalizing " + this.termsToNormalize));
        }
        for (ATermAppl c : this.termsToNormalize) {
            TermDefinition td = (TermDefinition)this.termhash.get(c);
            ATermAppl notC = ATermUtils.makeNot((ATerm)c);
            ArrayList<Pair<ATermAppl, Set<ATermAppl>>> unfoldC = new ArrayList<Pair<ATermAppl, Set<ATermAppl>>>();
            if (!td.getEqClassAxioms().isEmpty()) {
                ArrayList<Pair<ATermAppl, Set<ATermAppl>>> unfoldNotC = new ArrayList<Pair<ATermAppl, Set<ATermAppl>>>();
                for (ATermAppl eqClassAxiom : td.getEqClassAxioms()) {
                    ATermAppl unfolded = (ATermAppl)eqClassAxiom.getArgument(1);
                    Set<ATermAppl> ds = tbox.getAxiomExplanation(eqClassAxiom);
                    ATermAppl normalized = ATermUtils.normalize(unfolded);
                    ATermAppl normalizedNot = ATermUtils.negate(normalized);
                    unfoldC.add(new Pair<ATermAppl, Set<ATermAppl>>(normalized, ds));
                    unfoldNotC.add(new Pair<ATermAppl, Set<ATermAppl>>(normalizedNot, ds));
                }
                this.unfoldingMap.put(notC, unfoldNotC);
            } else {
                this.unfoldingMap.remove(notC);
            }
            for (ATermAppl subClassAxiom : td.getSubClassAxioms()) {
                ATermAppl unfolded = (ATermAppl)subClassAxiom.getArgument(1);
                Set<ATermAppl> ds = tbox.getAxiomExplanation(subClassAxiom);
                ATermAppl normalized = ATermUtils.normalize(unfolded);
                unfoldC.add(new Pair<ATermAppl, Set<ATermAppl>>(normalized, ds));
            }
            if (!unfoldC.isEmpty()) {
                this.unfoldingMap.put(c, unfoldC);
                continue;
            }
            this.unfoldingMap.remove(c);
        }
        this.termsToNormalize = new HashSet<ATermAppl>();
        if (PelletOptions.USE_ROLE_ABSORPTION) {
            this.absorbRanges();
        }
    }

    private void absorbRanges() {
        List<Pair<ATermAppl, Set<ATermAppl>>> unfoldTop = this.unfoldingMap.get(ATermUtils.TOP);
        if (unfoldTop == null) {
            return;
        }
        ArrayList<Pair<ATermAppl, Set<Object>>> newUnfoldTop = new ArrayList<Pair<ATermAppl, Set<Object>>>();
        for (Pair<ATermAppl, Set<ATermAppl>> pair : unfoldTop) {
            ATermAppl unfolded = (ATermAppl)pair.first;
            Set explain = (Set)pair.second;
            if (ATermUtils.isAllValues(unfolded)) {
                ATerm r = unfolded.getArgument(0);
                ATermAppl range = (ATermAppl)unfolded.getArgument(1);
                this.kb.addRange(r, range, new DependencySet(explain));
                continue;
            }
            if (ATermUtils.isAnd(unfolded)) {
                ATermList l = (ATermList)unfolded.getArgument(0);
                ATermList newList = ATermUtils.EMPTY_LIST;
                while (!l.isEmpty()) {
                    ATermAppl term = (ATermAppl)l.getFirst();
                    if (term.getAFun().equals(ATermUtils.ALLFUN)) {
                        ATerm r = term.getArgument(0);
                        ATermAppl range = (ATermAppl)term.getArgument(1);
                        this.kb.addRange(r, range, new DependencySet(explain));
                    } else {
                        newList.insert((ATerm)term);
                    }
                    l = l.getNext();
                }
                if (newList.isEmpty()) continue;
                newUnfoldTop.add(new Pair<ATermAppl, Set>(ATermUtils.makeAnd(newList), explain));
                continue;
            }
            newUnfoldTop.add(pair);
        }
        if (newUnfoldTop.isEmpty()) {
            this.unfoldingMap.remove(ATermUtils.TOP);
        }
    }

    public boolean addIfUnfoldable(ATermAppl term) {
        ATermAppl name = (ATermAppl)term.getArgument(0);
        ATermAppl body = (ATermAppl)term.getArgument(1);
        TermDefinition td = this.getTD((ATerm)name);
        if (!ATermUtils.isPrimitive(name)) {
            return false;
        }
        if (td == null) {
            td = new TermDefinition();
        }
        TermDefinition tdcopy = new TermDefinition(td);
        tdcopy.addDef(term);
        if (!tdcopy.isUnique()) {
            return false;
        }
        Set<ATermAppl> dependencies = ATermUtils.findPrimitives(body);
        HashSet seen = new HashSet();
        if (!td.dependencies.containsAll(dependencies)) {
            for (ATermAppl current : dependencies) {
                boolean result = this.findTarget(current, name, seen);
                if (!result) continue;
                return false;
            }
        }
        boolean added = this.addDef(term);
        return added;
    }

    protected boolean findTarget(ATermAppl term, ATermAppl target, Set seen) {
        Vector<ATermAppl> stack = new Vector<ATermAppl>();
        stack.add(term);
        while (!stack.isEmpty()) {
            this.kb.timers.checkTimer("preprocessing");
            ATermAppl current = (ATermAppl)stack.remove(0);
            if (seen.contains(current)) continue;
            seen.add(current);
            if (current.equals(target)) {
                return true;
            }
            TermDefinition td = this.getTD((ATerm)current);
            if (td == null) continue;
            if (td.dependencies.contains(target)) {
                return true;
            }
            stack.addAll(0, td.dependencies);
        }
        return false;
    }

    public void resetCache() {
        this.unfoldedcache = new HashMap();
        this.unfoldMisses = new HashSet();
        ++resets;
    }

    public void print() {
        for (Map.Entry<ATermAppl, List<Pair<ATermAppl, Set<ATermAppl>>>> entry : this.unfoldingMap.entrySet()) {
            System.out.println(entry.getKey() + " -> " + entry.getValue());
        }
    }
}

