/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.test.MiscTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class TracingTests {
    private ATermAppl bob = ATermUtils.makeTermAppl("Bob");
    private ATermAppl robert = ATermUtils.makeTermAppl("Robert");
    private ATermAppl mary = ATermUtils.makeTermAppl("Mary");
    private ATermAppl victor = ATermUtils.makeTermAppl("Victor");
    private ATermAppl email = ATermUtils.makeTermAppl("MaryAndBob@example.com");
    private ATermAppl mbox = ATermUtils.makeTermAppl("mbox");
    private ATermAppl relative = ATermUtils.makeTermAppl("relative");
    private ATermAppl sibling = ATermUtils.makeTermAppl("sibling");
    private ATermAppl person = ATermUtils.makeTermAppl("person");
    private ATermAppl human = ATermUtils.makeTermAppl("human");
    private ATermAppl ssn = ATermUtils.makeTermAppl("ssn");
    private KnowledgeBase kb;
    private boolean old_USE_TRACING;

    public static Test suite() {
        return new JUnit4TestAdapter(TracingTests.class);
    }

    @Before
    public void setUp() {
        this.old_USE_TRACING = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        this.kb = new KnowledgeBase();
        this.kb.setDoExplanation(true);
    }

    @After
    public void tearDown() {
        PelletOptions.USE_TRACING = this.old_USE_TRACING;
    }

    @org.junit.Test
    public void testAntiSymmetric() {
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addAntisymmetricProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.email);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.email, this.robert);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeAntisymmetric((ATerm)this.mbox), ATermUtils.makePropAtom(this.mbox, this.robert, this.email), ATermUtils.makePropAtom(this.mbox, this.email, this.robert)});
    }

    @Ignore(value="Known to fail, see ticket #47")
    @org.junit.Test
    public void testBottomSatisfiable() {
        this.kb.addClass(this.human);
        Assert.assertFalse((boolean)this.kb.isSatisfiable(ATermUtils.makeAnd((ATerm)ATermUtils.makeNot((ATerm)this.human), (ATerm)ATermUtils.BOTTOM)));
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
    }

    @org.junit.Test
    public void testCourse() {
        String ns = "http://test/course.owl#";
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.load(MiscTests.base + "testCourse.owl");
        KnowledgeBase kb = reasoner.getKB();
        kb.isConsistent();
        Assert.assertFalse((boolean)kb.isConsistent());
        ATermAppl M1 = PelletTestCase.term(ns + "M1");
        ATermAppl W1 = PelletTestCase.term(ns + "W1");
        ATermAppl C1 = PelletTestCase.term(ns + "C1");
        ATermAppl P1 = PelletTestCase.term(ns + "P1");
        ATermAppl C2 = PelletTestCase.term(ns + "C2");
        ATermAppl Man = PelletTestCase.term(ns + "Man");
        ATermAppl Woman = PelletTestCase.term(ns + "Woman");
        ATermAppl isTaughtBy = PelletTestCase.term(ns + "isTaughtBy");
        Set<ATermAppl> explanation = kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeTypeAtom(M1, Man)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom(isTaughtBy, C1, M1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom(isTaughtBy, C1, P1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeTypeAtom(W1, Woman)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom(isTaughtBy, C2, W1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom(isTaughtBy, C2, P1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeFunctional((ATerm)isTaughtBy)));
        Assert.assertTrue((explanation.size() == 1 ? 1 : 0) != 0);
        explanation.remove(ATermUtils.makeDisjoint((ATerm)Man, (ATerm)Woman));
        explanation.remove(ATermUtils.makeDisjoint((ATerm)Woman, (ATerm)Man));
        Assert.assertTrue((explanation.size() == 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDatatypeStatement() {
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makeTypedLiteral("bob", XSD.nonNegativeInteger.toString());
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makePropAtom(this.ssn, this.robert, ssn1)));
    }

    @org.junit.Test
    public void testDisjunction() {
        this.kb = new KnowledgeBase();
        ATermAppl name = ATermUtils.makeTermAppl("name");
        ATermAppl hasName = ATermUtils.makeTermAppl("hasName");
        ATermAppl nameOf = ATermUtils.makeTermAppl("nameOf");
        ATermAppl dog = ATermUtils.makeTermAppl("dog");
        ATermAppl ownsAnimal = ATermUtils.makeTermAppl("ownsAnimal");
        ATermAppl notPerson = ATermUtils.negate(this.person);
        ATermAppl animal = ATermUtils.makeTermAppl("animal");
        this.kb.addClass(notPerson);
        this.kb.addClass(this.person);
        this.kb.addClass(dog);
        this.kb.addClass(name);
        this.kb.addObjectProperty((ATerm)ownsAnimal);
        this.kb.addObjectProperty((ATerm)hasName);
        this.kb.addObjectProperty((ATerm)nameOf);
        this.kb.addInverseProperty(hasName, nameOf);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addPropertyValue(ownsAnimal, this.robert, this.victor);
        this.kb.addPropertyValue(ownsAnimal, this.mary, this.victor);
        ATermAppl existsHasName = ATermUtils.makeSomeValues((ATerm)hasName, (ATerm)name);
        this.kb.addClass(existsHasName);
        this.kb.addSubClass(dog, existsHasName);
        ATermAppl onlyOwnsDogs = ATermUtils.makeAllValues((ATerm)ownsAnimal, (ATerm)dog);
        ATermAppl allNameOfDog = ATermUtils.makeAllValues((ATerm)nameOf, (ATerm)dog);
        this.kb.addClass(allNameOfDog);
        this.kb.addSubClass(name, allNameOfDog);
        ATermAppl notPersonOronlyOwnsDog = ATermUtils.makeOr(notPerson, onlyOwnsDogs);
        this.kb.addSubClass(animal, notPersonOronlyOwnsDog);
        this.kb.addType(this.robert, notPersonOronlyOwnsDog);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.mary, notPersonOronlyOwnsDog);
        this.kb.addType(this.mary, this.person);
        this.kb.isConsistent();
        Assert.assertTrue((this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).getDepends((ATerm)dog).getExplanationSet().size() == 2 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDomain() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.robert, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeTypeAtom(this.robert, notPerson), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    @org.junit.Test
    public void testDomainRangeInverse() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl dog = ATermUtils.makeTermAppl("dog");
        this.kb.addClass(dog);
        this.kb.addClass(this.person);
        this.kb.addEquivalentClass(dog, notPerson);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addRange((ATerm)this.sibling, notPerson);
        this.kb.addInverseProperty(this.sibling, this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeRange((ATerm)this.sibling, (ATerm)notPerson), ATermUtils.makeInvProp((ATerm)this.sibling, (ATerm)this.sibling), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    @org.junit.Test
    public void testDomainRangeSymmetric() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl dog = ATermUtils.makeTermAppl("dog");
        this.kb.addClass(dog);
        this.kb.addClass(this.person);
        this.kb.addEquivalentClass(dog, notPerson);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addRange((ATerm)this.sibling, notPerson);
        this.kb.addSymmetricProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeRange((ATerm)this.sibling, (ATerm)notPerson), ATermUtils.makeSymmetric((ATerm)this.sibling), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    @org.junit.Test
    public void testEquivalentClass() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.human);
        this.kb.addSubClass(this.human, this.person);
        this.kb.addSubClass(this.person, this.human);
        Assert.assertTrue((boolean)this.kb.isEquivalentClass(this.human, this.person));
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)this.human, (ATerm)this.person), ATermUtils.makeSub((ATerm)this.person, (ATerm)this.human)});
    }

    @org.junit.Test
    public void testFunctionalDataProp() {
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addFunctionalProperty(this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral("012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral("123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom(this.ssn, this.robert, ssn1), ATermUtils.makePropAtom(this.ssn, this.robert, ssn2), ATermUtils.makeFunctional((ATerm)this.ssn)});
        Assert.assertTrue((explanation.size() == 3 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testInverseFunctionalDataProp() {
        ATermList different = ATermUtils.makeList((ATerm)this.robert).insert((ATerm)this.mary);
        System.out.println("Different: " + different);
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addInverseFunctionalProperty((ATerm)this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.email);
        this.kb.addAllDifferent(different);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.mary, this.email);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom(this.mbox, this.robert, this.email), ATermUtils.makePropAtom(this.mbox, this.mary, this.email), ATermUtils.makeInverseFunctional((ATerm)this.mbox), ATermUtils.makeAllDifferent(different)});
    }

    @org.junit.Test
    public void testIrreflexive() {
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addIrreflexiveProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addPropertyValue(this.mbox, this.robert, this.robert);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeIrreflexive((ATerm)this.mbox), ATermUtils.makePropAtom(this.mbox, this.robert, this.robert)});
    }

    @org.junit.Test
    public void testMaxOneDataProp() {
        this.kb.addClass(this.person);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        ATermAppl max1ssn = ATermUtils.makeMax((ATerm)this.ssn, 1, (ATerm)ATermUtils.TOP_LIT);
        this.kb.addSubClass(this.person, max1ssn);
        this.kb.addSubClass(this.person, ATermUtils.makeMin((ATerm)this.ssn, 1, (ATerm)ATermUtils.TOP_LIT));
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral("012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral("123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        System.out.println(explanation);
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom(this.ssn, this.robert, ssn1), ATermUtils.makePropAtom(this.ssn, this.robert, ssn2), ATermUtils.makeSub((ATerm)this.person, (ATerm)max1ssn), ATermUtils.makeTypeAtom(this.robert, this.person)});
    }

    @org.junit.Test
    public void testRange() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addRange((ATerm)this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeRange((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeTypeAtom(this.victor, notPerson), ATermUtils.makePropAtom(this.sibling, this.robert, this.victor)});
    }

    @org.junit.Test
    public void testReflexive() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl bobsType = ATermUtils.makeAllValues((ATerm)this.relative, (ATerm)notPerson);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addReflexiveProperty(this.relative);
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.robert, bobsType);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeReflexive((ATerm)this.relative), ATermUtils.makeTypeAtom(this.robert, this.person), ATermUtils.makeTypeAtom(this.robert, bobsType)});
    }

    @org.junit.Test
    public void testSameAllDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addIndividual(this.mary);
        ATermList list = ATermUtils.makeList((ATerm)this.robert);
        list = ATermUtils.makeList((ATerm)this.bob, list);
        list = ATermUtils.makeList((ATerm)this.mary, list);
        this.kb.addAllDifferent(list);
        this.kb.addSame(this.robert, this.bob);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeSameAs((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeAllDifferent(list)));
        Assert.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSameDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addSame(this.robert, this.bob);
        this.kb.addDifferent(this.robert, this.bob);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeSameAs((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeDifferent((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSubProp1() {
        ATermAppl noRelatives = ATermUtils.makeMax((ATerm)this.relative, 0, (ATerm)ATermUtils.TOP);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addSubProperty((ATerm)this.sibling, this.relative);
        this.kb.addType(this.bob, noRelatives);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSubProp((ATerm)this.sibling, (ATerm)this.relative), ATermUtils.makePropAtom(this.sibling, this.bob, this.mary), ATermUtils.makeTypeAtom(this.bob, noRelatives)});
    }

    @org.junit.Test
    public void testSubProp2() {
        ATermAppl nonHumanRelatives = ATermUtils.makeAllValues((ATerm)this.relative, (ATerm)ATermUtils.makeNot((ATerm)this.person));
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addSubProperty((ATerm)this.sibling, this.relative);
        this.kb.addType(this.bob, nonHumanRelatives);
        this.kb.addType(this.mary, this.person);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSubProp((ATerm)this.sibling, (ATerm)this.relative), ATermUtils.makePropAtom(this.sibling, this.bob, this.mary), ATermUtils.makeTypeAtom(this.bob, nonHumanRelatives), ATermUtils.makeTypeAtom(this.mary, this.person)});
    }

    @org.junit.Test
    public void testTopBottom() {
        this.kb = new KnowledgeBase();
        this.kb.addSubClass(ATermUtils.TOP, ATermUtils.BOTTOM);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)ATermUtils.TOP, (ATerm)ATermUtils.BOTTOM)});
    }

    @org.junit.Test
    public void testTransitive() {
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addTransitiveProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl notVictorsSibling = ATermUtils.makeNot((ATerm)ATermUtils.makeHasValue((ATerm)this.sibling, (ATerm)this.victor));
        this.kb.addType(this.robert, notVictorsSibling);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.mary, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set<ATermAppl> explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeTypeAtom(this.robert, notVictorsSibling), ATermUtils.makeTransitive((ATerm)this.sibling), ATermUtils.makePropAtom(this.sibling, this.robert, this.mary), ATermUtils.makePropAtom(this.sibling, this.mary, this.victor)});
    }
}

