/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATermAppl;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class GenerateData {
    String ns = "http://www.example.org/test#";
    String rdfType = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    String owlThing = "http://www.w3.org/2002/07/owl#Thing";
    PrintWriter out;
    KnowledgeBase kb;
    int count;
    int countLiteral;
    int nrOfClassTriples;
    int nrOfRelations;
    int longestChain;
    boolean onlyNamedClassesInOutput = true;
    boolean generateLiterals = true;
    int typeFactor;
    int roleFactor;
    Random generator = new Random();
    Map uris;
    Map classparams = new HashMap();
    public static final int RDFXML = 0;
    public static final int NTRIPLE = 1;
    int format = 0;
    QNameProvider qnames = new QNameProvider();

    public GenerateData(KnowledgeBase kb, PrintWriter out) {
        this.kb = kb;
        this.out = out;
        kb.isConsistent();
        for (ATermAppl c : kb.getProperties()) {
            this.qnames.shortForm(c.getName());
        }
    }

    void clearURIs() {
        this.uris = new HashMap();
    }

    void printHeader() {
        switch (this.format) {
            case 1: {
                break;
            }
            case 0: {
                this.out.println("<rdf:RDF");
                for (String prefix : this.qnames.getPrefixSet()) {
                    String uri = this.qnames.getURI(prefix);
                    this.out.println("  xmlns:" + prefix + "=\"" + uri + "\"");
                }
                this.out.println(">");
                break;
            }
            default: {
                throw new RuntimeException("Unknown format: " + this.format);
            }
        }
    }

    void printFooter() {
        switch (this.format) {
            case 1: {
                break;
            }
            case 0: {
                this.out.println("</rdf:RDF>");
                break;
            }
            default: {
                throw new RuntimeException("Unknown format: " + this.format);
            }
        }
    }

    void printTriple(String subj, String pred, String obj) {
        switch (this.format) {
            case 1: {
                this.out.println("<" + subj + "> <" + pred + "> <" + obj + "> .");
                break;
            }
            case 0: {
                String qname = this.qnames.shortForm(pred);
                this.out.println("<rdf:Description rdf:about=\"" + subj + "\">");
                this.out.println("  <" + qname + " rdf:resource=\"" + obj + "\"/>");
                this.out.println("</rdf:Description>");
                break;
            }
            default: {
                throw new RuntimeException("Unknown format: " + this.format);
            }
        }
    }

    public void printTriple(String subj, String pred, String obj, String datatypeURI) {
        switch (this.format) {
            case 1: {
                this.out.print("<" + subj + "> <" + pred + "> \"" + obj + "\"");
                if (datatypeURI != null) {
                    this.out.print("^^<" + datatypeURI + ">");
                }
                this.out.println(" .");
                break;
            }
            case 0: {
                String qname = this.qnames.shortForm(pred);
                this.out.println("<rdf:Description rdf:about=\"" + subj + "\">");
                this.out.print("  <" + qname);
                if (datatypeURI != null) {
                    this.out.print(" rdf:datatype=\"" + datatypeURI + "\"");
                }
                this.out.println(">" + obj + "</" + qname + ">");
                this.out.println("</rdf:Description>");
                break;
            }
            default: {
                throw new RuntimeException("Unknown format: " + this.format);
            }
        }
    }

    String getURI(Node node) {
        String uri = (String)this.uris.get(node);
        if (uri == null) {
            uri = this.ns + ++this.count;
            this.uris.put(node, uri);
        }
        return uri;
    }

    public void generate(ATermAppl c) {
        ABox abox = this.kb.getABox();
        abox.setKeepLastCompletion(true);
        boolean sat = abox.isSatisfiable(c);
        if (!sat) {
            return;
        }
        abox = abox.getLastCompletion();
        if (this.longestChain < abox.treeDepth) {
            this.longestChain = abox.treeDepth;
        }
        this.clearURIs();
        IndividualIterator i = abox.getIndIterator();
        while (i.hasNext()) {
            String obj;
            Individual ind = (Individual)i.next();
            String subj = this.getURI(ind);
            String pred = this.rdfType;
            List<ATermAppl> types = ind.getTypes(0);
            int filter = this.typeFactor == 11 ? this.generator.nextInt(10) : this.typeFactor;
            ArrayList<ATermAppl> classes = new ArrayList<ATermAppl>(this.kb.getClasses());
            for (int j = 0; j < types.size(); ++j) {
                ATermAppl type;
                if (this.generator.nextInt(9) + 1 > filter || ATermUtils.isNot(type = types.get(j)) || (obj = type.equals(ATermUtils.TOP) ? this.owlThing : type.getName()) == this.owlThing || this.onlyNamedClassesInOutput && (!this.onlyNamedClassesInOutput || !classes.contains(type))) continue;
                this.printTriple(subj, pred, obj);
                ++this.nrOfClassTriples;
            }
            filter = this.roleFactor == 11 ? this.generator.nextInt(10) : this.roleFactor;
            EdgeList edges = ind.getOutEdges();
            for (int j = 0; j < edges.size(); ++j) {
                if (this.generator.nextInt(9) + 1 > filter) continue;
                Edge edge = edges.edgeAt(j);
                pred = edge.getRole().getName().getName();
                Node node = edge.getTo();
                if (node.isLiteral()) {
                    if (!this.generateLiterals) continue;
                    obj = "Literal" + ++this.countLiteral;
                    String datatypeURI = ((Literal)node).getDatatypeURI();
                    this.printTriple(subj, pred, obj, datatypeURI);
                    ++this.nrOfRelations;
                    continue;
                }
                this.printTriple(subj, pred, this.getURI(node));
                ++this.nrOfRelations;
            }
        }
    }

    public void generate(int size) {
        ArrayList<ATermAppl> classes = new ArrayList<ATermAppl>(this.kb.getClasses());
        this.printHeader();
        while (this.nrOfClassTriples + this.nrOfRelations < size) {
            Collections.shuffle(classes);
            this.kb.getABox().clearCaches(true);
            this.kb.getABox().isConsistent();
            ATermAppl c = (ATermAppl)classes.get(0);
            this.generate(c);
        }
        this.printFooter();
        this.out.flush();
    }

    public void generateForEachClass(int maxIndPerClass) {
        ArrayList<ATermAppl> classes = new ArrayList<ATermAppl>(this.kb.getClasses());
        int max = maxIndPerClass;
        this.printHeader();
        this.kb.getABox().clearCaches(true);
        this.kb.getABox().isConsistent();
        System.err.println("Class\tIndividuals\tNrClassTriples\tNrRoleTriples\tTreeDepth");
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            int oldClassTrips = this.nrOfClassTriples;
            int oldRoleTrips = this.nrOfRelations;
            int oldCount = this.count;
            ATermAppl c = (ATermAppl)i.next();
            if (this.classparams.containsKey(c.getName())) {
                max = Integer.parseInt((String)this.classparams.get(c.getName()));
                System.err.println(max);
            } else {
                if (max > 1) {
                    max = this.generator.nextInt(maxIndPerClass);
                }
                if (max < 1) {
                    max = 1;
                }
            }
            for (int j = 0; j < max; ++j) {
                this.generate(c);
            }
            oldClassTrips = this.nrOfClassTriples - oldClassTrips;
            oldRoleTrips = this.nrOfRelations - oldRoleTrips;
            oldCount = this.count - oldCount;
            System.err.println(c.getName() + "\t" + oldCount + "\t" + oldClassTrips + "\t" + oldRoleTrips + "\t" + this.kb.getABox().getLastCompletion().treeDepth);
        }
        this.printFooter();
        this.out.flush();
    }

    void readClassOptions(String filename) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String option = new String();
            while ((option = br.readLine()) != null) {
                String[] parsedOption = option.split(" ");
                this.classparams.put(parsedOption[0], parsedOption[1]);
            }
        }
        catch (IOException e) {
            System.out.println("Can't find options file " + filename + ". Ignoring.");
        }
    }

    public static void usage() {
        System.out.println("GenerateData");
        System.out.println("");
        System.out.println("Generate random instance data from an ontology.");
        System.out.println("");
        System.out.println("usage: GenerateData OPTIONS <ontologyURI>");
        System.out.println("  -s            Size of the data generated (number of triples) (negative gives individuals per class for all classes)");
        System.out.println("  -opt          Control file (negative size only)");
        System.out.println("  -l            Generate literals");
        System.out.println("  -ns           Namespace of output ontology");
        System.out.println("  -f            Output file (stdout by default)");
        System.out.println("  -t            Control the percentage of type triples (0(none)-10(all),11(rand)");
        System.out.println("  -r            Control the percentage of relation triples (0(none)-10(all),11(rand)");
        System.out.println("  -h            Print this screen");
    }

    void log(String msg, PrintWriter log) {
        System.err.println(msg);
        log.println(msg);
    }

    public static void main(String[] args) throws Exception {
        String in = null;
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter log = new PrintWriter((Writer)new FileWriter("log.txt", true), true);
        int size = 1000;
        int tf = 10;
        int rf = 10;
        String filename = "";
        boolean trips = true;
        boolean nc = false;
        System.err.println("Starting!");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h")) {
                GenerateData.usage();
                System.exit(0);
                continue;
            }
            if (arg.equals("-f")) {
                out = new PrintWriter(new FileWriter(args[++i]));
                continue;
            }
            if (arg.equals("-s")) {
                if ((size = Integer.parseInt(args[++i])) >= 0) continue;
                size = -size;
                trips = false;
                continue;
            }
            if (arg.equals("-t")) {
                tf = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-r")) {
                rf = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-opt")) {
                filename = args[++i];
                continue;
            }
            if (arg.equals("-nc")) {
                nc = true;
                continue;
            }
            if (i == args.length - 1) {
                in = args[i];
                continue;
            }
            System.err.println("Unknown option; " + arg);
            GenerateData.usage();
            System.exit(1);
        }
        if (in == null) {
            System.err.println("No ontology URI given");
            GenerateData.usage();
            System.exit(1);
        }
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.load(in);
        GenerateData gd = new GenerateData(reasoner.getKB(), out);
        gd.readClassOptions("../Ontologies/selectivity.txt");
        gd.typeFactor = tf;
        gd.roleFactor = rf;
        gd.onlyNamedClassesInOutput = nc;
        if (!filename.equals("")) {
            gd.readClassOptions(filename);
        }
        if (trips) {
            gd.generate(size);
        } else {
            gd.generateForEachClass(size);
        }
        gd.log("Ontology: " + in, log);
        gd.log("Trip Limit: " + size, log);
        gd.log("Generated NrInd: " + gd.count, log);
        gd.log("Class Trips: " + gd.nrOfClassTriples, log);
        gd.log("Prop Trips: " + gd.nrOfRelations, log);
        gd.log("Longest chain: " + gd.longestChain, log);
        gd.log("===================", log);
    }
}

