/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.QueueElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedCompletionQueue
extends CompletionQueue {
    protected List<QueueElement>[] gQueue;
    protected List<QueueElement>[] queue = new ArrayList[SIZE];
    protected int[] current;
    protected int[] gCurrent;
    protected int[] cutOff;
    protected List<Object[]> branches;
    private ATermAppl nextLabel;

    protected AdvancedCompletionQueue(ABox abox) {
        super(abox);
        this.gQueue = new ArrayList[SIZE];
        this.current = new int[SIZE];
        this.gCurrent = new int[SIZE];
        this.cutOff = new int[SIZE];
        this.branches = new ArrayList<Object[]>();
        this.currentType = ATOMLIST;
        Object[] initbranches = new Object[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            int[] initial = new int[]{0, 0, 0, 0};
            this.queue[i] = new ArrayList<QueueElement>();
            this.gQueue[i] = new ArrayList<QueueElement>();
            this.current[i] = 0;
            this.gCurrent[i] = 0;
            this.cutOff[i] = 0;
            initbranches[i] = initial;
        }
        this.branches.add(0, initbranches);
    }

    @Override
    protected void findNext(int type) {
        Node node;
        QueueElement next;
        boolean found = false;
        while (this.gCurrent[type] < this.gQueue[type].size() && this.gCurrent[type] + this.current[type] < this.cutOff[type]) {
            next = null;
            next = this.gQueue[type].get(this.gCurrent[type]);
            node = (Node)this.abox.getNodeMap().get(next.getNode());
            if (node != null) {
                node = node.getSame();
                if (type == LITERALLIST && node instanceof Literal && !node.isPruned() && this.allowLiterals()) {
                    found = true;
                    break;
                }
                if (node instanceof Individual && !node.isPruned() && !this.allowLiterals()) {
                    found = true;
                    break;
                }
            }
            int n = type;
            this.gCurrent[n] = this.gCurrent[n] + 1;
        }
        if (found) {
            return;
        }
        while (this.current[type] < this.queue[type].size() && this.gCurrent[type] + this.current[type] < this.cutOff[type]) {
            next = null;
            next = this.queue[type].get(this.current[type]);
            node = (Node)this.abox.getNodeMap().get(next.getNode());
            if (node != null) {
                node = node.getSame();
                if (type == LITERALLIST && node instanceof Literal && !node.isPruned() && this.allowLiterals() || node instanceof Individual && !node.isPruned() && !this.allowLiterals()) break;
            }
            int n = type;
            this.current[n] = this.current[n] + 1;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext(this.currentType);
        return (this.current[this.currentType] < this.queue[this.currentType].size() || this.gCurrent[this.currentType] < this.gQueue[this.currentType].size()) && this.gCurrent[this.currentType] + this.current[this.currentType] < this.cutOff[this.currentType];
    }

    @Override
    public void restore(int branch) {
        if (branch + 1 < this.branches.size()) {
            this.branches.subList(branch + 1, this.branches.size()).clear();
        }
        Object[] theBranch = this.branches.get(branch);
        for (int i = 0; i < SIZE; ++i) {
            int[] index = (int[])theBranch[i];
            this.current[i] = index[0];
            this.cutOff[i] = index[2];
            this.gCurrent[i] = index[3];
            this.queue[i].subList(Math.min(this.queue[i].size(), this.cutOff[i]), this.queue[i].size()).clear();
        }
    }

    @Override
    public Individual next() {
        this.findNext(this.currentType);
        QueueElement elem = null;
        if (this.gCurrent[this.currentType] < this.gQueue[this.currentType].size()) {
            int n = this.currentType;
            int n2 = this.gCurrent[n];
            this.gCurrent[n] = n2 + 1;
            elem = this.gQueue[this.currentType].get(n2);
        } else {
            int n = this.currentType;
            int n3 = this.current[n];
            this.current[n] = n3 + 1;
            elem = this.queue[this.currentType].get(n3);
        }
        this.nextLabel = elem.getLabel();
        Node node = (Node)this.abox.getNodeMap().get(elem.getNode());
        node = node.getSame();
        return (Individual)node;
    }

    @Override
    public Node nextLiteral() {
        this.findNext(this.currentType);
        QueueElement elem = null;
        if (this.gCurrent[this.currentType] < this.gQueue[this.currentType].size()) {
            int n = this.currentType;
            int n2 = this.gCurrent[n];
            this.gCurrent[n] = n2 + 1;
            elem = this.gQueue[this.currentType].get(n2);
        } else {
            int n = this.currentType;
            int n3 = this.current[n];
            this.current[n] = n3 + 1;
            elem = this.queue[this.currentType].get(n3);
        }
        this.nextLabel = elem.getLabel();
        Node node = (Node)this.abox.getNodeMap().get(elem.getNode());
        node = node.getSame();
        return node;
    }

    @Override
    public void add(QueueElement x, int type) {
        if (this.abox.isSyntacticUpdate()) {
            this.gQueue[type].add(x);
        } else {
            this.queue[type].add(x);
        }
    }

    public void addAll(List<QueueElement> xs, int type) {
        if (this.abox.isSyntacticUpdate()) {
            this.gQueue[type].addAll(xs);
        } else {
            this.queue[type].addAll(xs);
        }
    }

    @Override
    public void incrementBranch(int branch) {
        Object[] theBranch = branch < this.branches.size() ? this.branches.get(branch) : new Object[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            int[] entry = new int[]{this.current[i], this.gQueue[i].size() + this.queue[i].size(), this.queue[i].size() + 1, this.gCurrent[i]};
            theBranch[i] = entry;
        }
        if (branch < this.branches.size()) {
            this.branches.set(branch, theBranch);
        } else {
            this.branches.add(branch, theBranch);
        }
    }

    @Override
    public AdvancedCompletionQueue copy() {
        int i;
        AdvancedCompletionQueue copy = new AdvancedCompletionQueue(this.abox);
        for (i = 0; i < SIZE; ++i) {
            copy.queue[i] = new ArrayList<QueueElement>(this.queue[i]);
            copy.gQueue[i] = new ArrayList<QueueElement>(this.gQueue[i]);
            copy.current[i] = this.current[i];
            copy.cutOff[i] = this.cutOff[i];
            copy.gCurrent[i] = this.gCurrent[i];
        }
        for (i = 0; i < this.branches.size(); ++i) {
            Object[] branchArray = this.branches.get(i);
            Object[] newBranchArray = new Object[branchArray.length];
            for (int j = 0; j < branchArray.length; ++j) {
                int[] oldEntry = (int[])branchArray[j];
                int[] newEntry = new int[]{oldEntry[0], oldEntry[1], oldEntry[2], oldEntry[3]};
                newBranchArray[j] = newEntry;
            }
            if (i < copy.branches.size()) {
                copy.branches.set(i, newBranchArray);
                continue;
            }
            copy.branches.add(newBranchArray);
        }
        for (i = 0; i < this.branchEffects.size(); ++i) {
            HashSet cp = new HashSet();
            cp.addAll((Set)this.branchEffects.get(i));
            copy.branchEffects.add(cp);
        }
        return copy;
    }

    @Override
    public void setABox(ABox ab) {
        this.abox = ab;
    }

    @Override
    public void print(int type) {
        int i;
        System.out.println("Queue for type: " + type);
        System.out.println("   Global Curr Pointer " + this.gCurrent[type] + "\n Global Queue:");
        for (i = 0; i < this.gQueue[type].size(); ++i) {
            System.out.println("     " + this.gQueue[type].get(i).getNode() + "  " + this.gQueue[type].get(i).getLabel());
        }
        System.out.println("   Queue Curr Pointer " + this.current[type] + "\n Queue:");
        for (i = 0; i < this.queue[type].size(); ++i) {
            System.out.println("     " + this.queue[type].get(i).getNode() + "  " + this.queue[type].get(i).getLabel());
        }
    }

    @Override
    public void print() {
        for (int i = 0; i < CompletionQueue.SIZE; ++i) {
            this.print(i);
        }
        this.printBranchInfo();
    }

    @Override
    public void printBranchInfo() {
        System.out.println("Branch pointers: ");
        for (int i = 1; i < this.branches.size(); ++i) {
            Object[] theBranch = this.branches.get(i);
            System.out.println("Branch: " + i);
            for (int j = 0; j < SIZE; ++j) {
                int[] entry = (int[])theBranch[j];
                System.out.println("  Queue - " + j);
                System.out.println("    Current pointer: " + entry[0]);
                System.out.println("    Total size (gQ + queue i): " + entry[1]);
                System.out.println("    Cutoff: " + entry[2]);
                System.out.println("    gCurrent: " + entry[3]);
            }
        }
    }

    @Override
    public void reset() {
        this.cutOff[this.currentType] = this.gQueue[this.currentType].size() + this.queue[this.currentType].size();
    }

    @Override
    public ATermAppl getNextLabel() {
        return this.nextLabel;
    }

    @Override
    protected void flushQueue() {
    }

    @Override
    protected void flushQueue(int queue) {
    }

    @Override
    protected void clearQueue(int index) {
    }
}

