/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.QueueElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompletionQueue
extends IndividualIterator {
    public static final Log log = LogFactory.getLog(ABox.class);
    protected static int GUESSLIST = 0;
    protected static int NOMLIST = 1;
    protected static int MAXLIST = 2;
    protected static int DATATYPELIST = 3;
    protected static int ATOMLIST = 4;
    protected static int ORLIST = 5;
    protected static int SOMELIST = 6;
    protected static int MINLIST = 7;
    protected static int LITERALLIST = 8;
    protected static int ALLLIST = 9;
    protected static int CHOOSELIST = 10;
    protected static int SIZE = 11;
    protected ABox abox;
    private boolean allowLiterals;
    protected int currentType;
    protected boolean closed = false;
    protected List<Set<ATermAppl>> branchEffects;

    protected CompletionQueue(ABox abox) {
        super(abox);
        this.abox = abox;
        this.allowLiterals = false;
        this.branchEffects = new ArrayList<Set<ATermAppl>>();
    }

    protected abstract void findNext(int var1);

    public abstract void restore(int var1);

    public abstract void add(QueueElement var1, int var2);

    @Override
    public abstract void reset();

    public abstract void incrementBranch(int var1);

    public abstract CompletionQueue copy();

    public void setABox(ABox ab) {
        this.abox = ab;
    }

    public abstract void print(int var1);

    public abstract void print();

    public void printBranchInfo() {
    }

    protected void addEffected(int branch, ATermAppl node) {
        if (branch <= 0) {
            return;
        }
        if (branch < this.branchEffects.size()) {
            HashSet inds = (HashSet)this.branchEffects.get(branch);
            inds.add(node);
            this.branchEffects.set(branch, inds);
        } else {
            for (int i = this.branchEffects.size(); i < branch; ++i) {
                this.branchEffects.add(new HashSet());
            }
            HashSet<ATermAppl> inds = new HashSet<ATermAppl>();
            inds.add(node);
            this.branchEffects.add(branch, inds);
        }
    }

    protected Set<ATermAppl> removeEffects(int branch) {
        HashSet<ATermAppl> effected = new HashSet<ATermAppl>();
        for (int i = branch + 1; i < this.branchEffects.size(); ++i) {
            Set<ATermAppl> next = this.branchEffects.get(i);
            effected.addAll(next);
            this.branchEffects.set(i, new HashSet());
        }
        return effected;
    }

    protected void setType(int type) {
        this.currentType = type;
    }

    protected void setAllowLiterals(boolean val) {
        this.allowLiterals = val;
    }

    protected abstract void flushQueue();

    protected abstract void flushQueue(int var1);

    protected abstract void clearQueue(int var1);

    protected boolean allowLiterals() {
        return this.allowLiterals;
    }

    protected abstract Node nextLiteral();

    protected ATermAppl getNextLabel() {
        return null;
    }

    protected void setClosed(boolean isClash) {
        this.closed = isClash;
    }
}

