/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.Datatype;

class LiteralValueBranch
extends Branch {
    int shuffle;
    Datatype datatype;

    LiteralValueBranch(ABox abox, CompletionStrategy strategy, Literal lit, Datatype datatype) {
        super(abox, strategy, lit, DependencySet.INDEPENDENT, datatype.size() == -1 ? Integer.MAX_VALUE : datatype.size());
        this.shuffle = abox.getBranch();
        this.datatype = datatype;
    }

    protected Branch copyTo(ABox abox) {
        Literal x = abox.getLiteral((ATerm)this.node.getName());
        LiteralValueBranch b = new LiteralValueBranch(abox, null, x, this.datatype);
        b.shuffle = this.shuffle;
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        b.nodeName = this.node.getName();
        b.strategy = this.strategy;
        b.tryNext = this.tryNext;
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void tryBranch() {
        this.abox.incrementBranch();
        DependencySet ds = this.termDepends;
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            int tryIndex = (this.tryNext + this.shuffle) % this.tryCount;
            ATermAppl value = this.datatype.getValue(tryIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LIT : (" + (this.tryNext + 1) + "/" + this.tryCount + ") at branch (" + this.branch + ") " + " for literal " + this.node + " merge " + value + " " + ds));
            }
            ds = ds.union(new DependencySet(this.branch), this.abox.doExplanation());
            Node y = this.node;
            Node z = this.abox.getNode((ATerm)value);
            if (z == null) {
                z = this.abox.addLiteral(value);
            }
            this.strategy.mergeTo(y, z, ds);
            boolean earlyClash = this.abox.isClosed();
            if (!earlyClash) return;
            if (log.isDebugEnabled()) {
                log.debug((Object)("CLASH: Branch " + this.branch + " " + this.abox.getClash() + "!"));
            }
            if (!(clashDepends = this.abox.getClash().depends).contains(this.branch)) return;
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().setAllowLiterals(false);
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        ds = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.branch);
        }
        this.abox.setClash(Clash.unexplained(this.node, ds));
    }

    public String toString() {
        if (this.tryNext < this.tryCount) {
            return "Branch " + this.branch + " literal rule on " + this.node + " datatype  " + this.datatype.getName();
        }
        return "Branch " + this.branch + " literal rule on " + this.node + " exhausted merge possibilities";
    }

    protected void shiftTryNext(int openIndex) {
        --this.tryNext;
    }
}

