/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.OWLSpecies;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletQueryExecution;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.output.ClassTreePrinter;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.RDFXMLTaxonomyPrinter;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.VersionInfo;

public class Pellet {
    public static final int SPECIES_ON = 0;
    public static final int SPECIES_LEVEL = 1;
    public static final int SPECIES_OFF = 2;
    public static final int CLASS_NONE = 0;
    public static final int CLASS_TREE = 1;
    public static final int CLASS_RDF = 2;
    public static final int CLASS_RDF_ALL = 3;
    private static VersionInfo vinfo = null;
    String inFile = null;
    String inString = null;
    String inFormat = null;
    String conclusionsFile = null;
    String conclusionsString = null;
    String conclusionsFormat = null;
    String outFile = null;
    String queryFile = null;
    String queryString = null;
    Syntax queryFormat = Syntax.syntaxSPARQL;
    String classifyFile = null;
    int classifyFormat = 0;
    boolean checkConsistency = true;
    int species = 0;
    boolean realize = false;
    boolean findUnsat = false;
    boolean quiet = false;
    boolean printTiming = false;
    Timers timers;
    ModelReader modelReader;
    List<String> parseErrors;
    boolean loaded = false;
    OntModel model;
    OWLReasoner reasoner;
    KnowledgeBase kb;
    Set<ATermAppl> unsatClasses;
    Query query;
    ResultSet queryResults;
    OutputFormatter out = new OutputFormatter();
    int timeout = -1;

    public Pellet() {
        this.unsatClasses = new HashSet<ATermAppl>();
        this.modelReader = new ModelReader();
        this.parseErrors = new ArrayList<String>();
        this.timers = new Timers();
        this.modelReader.setErrorHandler(new RDFErrorHandler(){

            public void warning(Exception e) {
                Pellet.this.parseErrors.add(ParseException.formatMessage((Exception)e));
            }

            public void error(Exception e) {
                Pellet.this.parseErrors.add(ParseException.formatMessage((Exception)e));
            }

            public void fatalError(Exception e) {
                throw new JenaException((Throwable)e);
            }
        });
    }

    private void loadInput() {
        try {
            Timer t = this.timers.startTimer("Loading");
            if (this.inFile != null) {
                if (this.inString != null) {
                    throw new RuntimeException("Both an input url and text is given.");
                }
            } else if (this.inString == null) {
                if (this.query != null && !this.query.getGraphURIs().isEmpty()) {
                    this.inFile = this.query.getGraphURIs().get(0).toString();
                }
                if (this.inFile == null) {
                    this.out.println("No input file is given!");
                    if (!this.out.isFormatHTML()) {
                        Pellet.usage();
                    }
                    this.out.flush();
                    System.exit(1);
                }
            }
            Model plainModel = null;
            if (this.inFile != null) {
                this.out.printBold("Input file: ").printLink(this.inFile).println();
                plainModel = this.modelReader.read(this.inFile, this.inFormat);
            } else {
                this.out.printBold("Input file: ").println("Text area");
                plainModel = this.modelReader.read(new ByteArrayInputStream(this.inString.getBytes()), this.inFormat);
            }
            if (plainModel != null) {
                this.model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)plainModel);
                this.reasoner = ((PelletInfGraph)this.model.getGraph()).getOWLReasoner();
            }
            this.printParseErrors();
            ((PelletInfGraph)this.model.getGraph()).setLazyConsistency(true);
            this.model.prepare();
            this.kb = this.reasoner.getKB();
            if (this.timeout > 0) {
                this.kb.setTimeout(this.timeout * 1000);
            }
            t.stop();
            this.loaded = true;
        }
        catch (StackOverflowError e) {
            this.out.println("Load Error: Stack overflow probably due to a cyclic definition. Species results might provide a detailed message.");
        }
        catch (Throwable e) {
            this.out.print("Load Error: ");
            e.printStackTrace(this.out.getWriter());
        }
    }

    private void printParseErrors() {
        if (!this.parseErrors.isEmpty()) {
            this.out.printBold("Problems encountered parsing RDF:").println();
            Iterator<String> iter = this.parseErrors.iterator();
            while (iter.hasNext()) {
                this.out.println((Object)iter.next());
            }
        }
        this.out.flush();
    }

    private void checkSpecies() {
        if (this.species == 2) {
            return;
        }
        Timer t = this.timers.startTimer("Species Validation");
        if (this.reasoner != null) {
            OWLSpecies species = this.reasoner.getSpecies();
            this.out.printBold("OWL Species: ").println(species);
            if (this.loaded) {
                this.out.printBold("DL Expressivity: ").println(this.kb.getExpressivity());
            }
        } else {
            this.out.printBold("OWL Species: Unknown");
        }
        t.stop();
    }

    private void checkConsistency() {
        if (!this.checkConsistency) {
            return;
        }
        Timer t = this.timers.startTimer("Consistency");
        boolean isConsistent = this.reasoner.isConsistent();
        t.stop();
        this.out.printBold("Consistent: ");
        if (isConsistent) {
            this.out.println("Yes");
        } else {
            this.out.printHTML("<font color=Red><b>").print("No").printHTML("</b></font>").println();
            this.out.printBold("Reason: ").println(this.kb.getExplanation());
        }
    }

    private void checkConclusions() {
        if (this.conclusionsFile != null && this.conclusionsString != null) {
            throw new RuntimeException("Both a conclusions url and text is given.");
        }
        if (this.conclusionsFile == null && this.conclusionsString == null) {
            return;
        }
        if (!this.reasoner.isConsistent()) {
            return;
        }
        Model coModel = null;
        coModel = this.conclusionsFile != null ? this.modelReader.read(this.conclusionsFile, this.conclusionsFormat) : this.modelReader.read(new ByteArrayInputStream(this.conclusionsString.getBytes()), this.conclusionsFormat);
        boolean isEntailed = this.reasoner.isEntailed(coModel);
        this.out.printBold("Entailed: ").print(isEntailed ? "Yes" : "No").println();
    }

    private void checkUnsat() {
        if (!this.findUnsat && !this.kb.isClassified()) {
            return;
        }
        if (!this.reasoner.isConsistent()) {
            return;
        }
        for (ATermAppl c : this.kb.getClasses()) {
            if (this.kb.isSatisfiable(c)) continue;
            this.unsatClasses.add(c);
        }
    }

    private boolean doClassify() {
        if (this.classifyFormat == 0 || !this.reasoner.isConsistent()) {
            return false;
        }
        Timer t = this.timers.startTimer("Classification");
        this.reasoner.classify();
        t.stop();
        if (this.realize) {
            t = this.timers.startTimer("Realization");
            this.reasoner.realize();
            t.stop();
        }
        return true;
    }

    private void printClassTree() throws IOException {
        if (!this.kb.isClassified()) {
            return;
        }
        Writer writer = this.classifyFile != null ? new FileWriter(this.classifyFile) : this.out.getWriter();
        OutputFormatter classifyOut = new OutputFormatter(writer, this.out.isFormatHTML());
        TaxonomyPrinter<ATermAppl> printer = null;
        if (this.classifyFormat == 1) {
            printer = new ClassTreePrinter();
        } else if (this.classifyFormat == 2) {
            printer = new RDFXMLTaxonomyPrinter();
        } else if (this.classifyFormat == 3) {
            throw new RuntimeException("Invalid format to display classification");
        }
        this.out.println();
        this.out.printBold("Classification:").println();
        printer.print(this.kb.getTaxonomy(), classifyOut);
        if (this.classifyFile != null) {
            this.out.println("Saved to file " + this.classifyFile);
        }
    }

    private void printUnsat() {
        if (this.unsatClasses.isEmpty()) {
            return;
        }
        this.out.printParagraph().printBold("Unsatisfiable Concepts").println();
        Iterator<ATermAppl> i = this.unsatClasses.iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            this.out.printURI(name);
            if (!i.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println();
    }

    private void printTimeInfo() {
        this.out.printBold("Time: ").println(this.getTimeInfo());
    }

    private void loadQuery() throws Exception {
        if (this.queryFile != null && this.queryString != null) {
            throw new RuntimeException("Both a query url and text is given.");
        }
        if (this.queryFile == null && this.queryString == null) {
            return;
        }
        Timer t = this.timers.startTimer("Loading");
        if (this.queryString == null) {
            this.queryString = FileUtils.readURL(new URL(this.queryFile));
        }
        this.query = QueryFactory.create((String)this.queryString, (Syntax)this.queryFormat);
        t.stop();
    }

    private void execQuery() {
        if (this.query == null) {
            return;
        }
        if (!this.reasoner.isConsistent()) {
            return;
        }
        PelletQueryExecution queryEngine = new PelletQueryExecution(this.query, (Model)this.model);
        this.queryResults = queryEngine.execSelect();
    }

    private void printQueryResults() {
        if (this.query == null) {
            return;
        }
        this.out.println();
        this.out.printBold("Query: ").println();
        this.out.printHTML("<pre>");
        if (this.out.isFormatHTML()) {
            this.out.print(this.queryString.trim().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        } else {
            this.out.println(this.queryString.trim());
        }
        this.out.printHTML("</pre>");
        this.out.println("-----------------------------------------------------");
        if (this.queryResults.hasNext()) {
            int count = 0;
            NodeFormatter formatter = new NodeFormatter((Model)this.model, this.out.isFormatHTML());
            List resultVars = this.query.getResultVars();
            LinkedHashSet data = new LinkedHashSet();
            while (this.queryResults.hasNext()) {
                QuerySolution binding = this.queryResults.nextSolution();
                ArrayList<String> formattedBinding = new ArrayList<String>();
                for (int i = 0; i < resultVars.size(); ++i) {
                    String var = (String)resultVars.get(i);
                    RDFNode result = binding.get(var);
                    formattedBinding.add(formatter.format(result));
                }
                if (!data.add(formattedBinding)) continue;
                ++count;
            }
            this.out.printBold("Query Results (" + count + " answers): ").println();
            TableData table = new TableData(data, resultVars);
            table.print(this.out);
        } else {
            this.out.printBold("Query Results (0 answers): ").println();
            this.out.printBold("NO RESULTS").println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Timer t = this.timers.startTimer("totalTime");
            this.loadQuery();
            this.loadInput();
            this.checkSpecies();
            if (this.loaded) {
                this.checkConsistency();
                this.checkConclusions();
                this.doClassify();
                this.checkUnsat();
                this.execQuery();
                t.stop();
                this.printTimeInfo();
                this.printUnsat();
                this.printClassTree();
                this.printQueryResults();
            }
            this.printSpeciesReport();
            if (this.printTiming) {
                this.kb.timers.print();
            }
        }
        catch (QueryParseException e) {
            this.out.printBold("Cannot parse query: " + e.getMessage()).println();
            this.out.println();
            throw e;
        }
        catch (JenaException e) {
            this.out.printBold("Unrecoverable error while parsing RDF:").println();
            this.out.println(ParseException.formatMessage((Exception)((Object)e)));
            this.out.println();
            this.out.println("Cannot process file due to parse error!");
            throw e;
        }
        catch (TimeoutException e) {
            this.out.printParagraph().printBold("TIMEOUT:").println("Timeout after " + this.timeout + " seconds");
        }
        catch (UnsupportedFeatureException e) {
            this.out.printParagraph().printBold("Unsupported features in input:");
            this.out.println(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.out.println("Exception: " + e);
            e.printStackTrace();
        }
        catch (Error e) {
            this.out.println("Error: " + e);
            e.printStackTrace();
        }
        finally {
            this.out.flush();
        }
    }

    private void printSpeciesReport() {
        if (this.species != 0 || this.reasoner == null) {
            return;
        }
        this.out.printParagraph();
        OWLSpecies species = this.reasoner.getSpecies();
        species.getReport().print(this.out);
        if (species.getLevel() == 2) {
            this.out.printParagraph().printBold("Add the following statements to make this document OWL DL").println();
            if (species.missingTriples != null) {
                this.out.printHTML("<xmp>");
                try {
                    RDFWriter rdfWriter = species.missingTriples.getWriter();
                    rdfWriter.setProperty("allowBadURIs", (Object)"true");
                    rdfWriter.write(species.missingTriples, (Writer)this.out.getWriter(), null);
                }
                catch (Exception e) {
                    this.out.print("Following error occurred when trying to print the missing triples " + e);
                    e.printStackTrace();
                    StmtIterator si = species.missingTriples.listStatements();
                    while (si.hasNext()) {
                        System.err.println(si.next());
                    }
                }
                this.out.printHTML("</xmp>");
            } else {
                this.out.println("This ontology cannot be converted to OWL DL.");
            }
        }
    }

    public String getTimeInfo() {
        String timeInfo = this.timers.getTimer("totalTime").getTotal() + " ms (";
        timeInfo = timeInfo + this.getTimerString("Loading");
        timeInfo = timeInfo + this.getTimerString("Preprocessing");
        timeInfo = timeInfo + this.getTimerString("Species Validation");
        timeInfo = timeInfo + this.getTimerString("Consistency");
        timeInfo = timeInfo + this.getTimerString("Entailment");
        timeInfo = timeInfo + this.getTimerString("Unsatisfiability");
        timeInfo = timeInfo + this.getTimerString("Classification");
        timeInfo = timeInfo + this.getTimerString("Realization");
        timeInfo = timeInfo + ")";
        return timeInfo;
    }

    private String getTimerString(String name) {
        String info = "";
        Timer t = this.timers.getTimer(name);
        if (t != null) {
            info = name + ": " + t.getTotal() + " ";
        }
        return info;
    }

    public void setQueryFormat(String format) {
        this.queryFormat = Syntax.lookup((String)format.toUpperCase());
        if (this.queryFormat == null) {
            throw new RuntimeException("Unknown query format " + this.queryFormat);
        }
    }

    public void setClassifyFormat(int format) {
        this.classifyFormat = format;
    }

    public void setClassifyFormat(String s) {
        if (s.equalsIgnoreCase("none")) {
            this.setClassifyFormat(0);
        } else if (s.equalsIgnoreCase("tree")) {
            this.setClassifyFormat(1);
        } else if (s.equalsIgnoreCase("rdf")) {
            this.setClassifyFormat(2);
        } else {
            throw new RuntimeException("Unknown classification format " + s);
        }
    }

    public void setClassifyFile(String file) {
        this.classifyFile = file;
    }

    public void setConclusionsFile(String string) {
        this.conclusionsFile = string;
    }

    public void setConclusionsFormat(String string) {
        this.conclusionsFormat = string;
    }

    public void setConclusionsString(String string) {
        this.conclusionsString = string;
    }

    public void setFormatHTML(boolean b) {
        this.out.setFormatHTML(b);
    }

    public void setInFile(String string) {
        if (string != null) {
            this.inFile = FileUtils.toURI(string);
        }
    }

    public void setInFormat(String string) {
        this.inFormat = string;
    }

    public void setInString(String string) {
        this.inString = string;
    }

    public void setPrintTiming(boolean value) {
        this.printTiming = value;
    }

    public void setQueryFile(String string) {
        this.queryFile = string;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void setTimeout(int i) {
        this.timeout = i;
    }

    public void setSpecies(int i) {
        this.species = i;
    }

    public void setQuiet(boolean b) {
        this.quiet = b;
    }

    public void setConsistency(boolean b) {
        this.checkConsistency = b;
    }

    public void setRealize(boolean b) {
        if (b && this.classifyFormat == 0) {
            this.classifyFormat = 1;
        }
        this.realize = b;
    }

    public void setUnsat(boolean b) {
        this.findUnsat = b;
    }

    private static void usage() {
        VersionInfo vinfo = Pellet.getVersionInfo();
        System.out.println("Pellet - OWL DL Reasoner (Version:" + vinfo.getVersionString() + ")");
        System.out.println("For the OWL ontologies Pellet provides options find the ontology level");
        System.out.println("(Lite, DL, FULL), check consistency, find unsatisfiable concepts, ");
        System.out.println("display class hierarchy, save OWL Full ontologies as OWL DL, ");
        System.out.println("check if triples in another ontology is entailed by the input");
        System.out.println("ontology");
        System.out.println("");
        System.out.println("Usage: java Pellet OPTIONS");
        System.out.println(" {-if,-inputFile} <file URI>  Input ontology URI");
        System.out.println(" {-is,-inputString} string    A string representation of the input file");
        System.out.println(" {-ifmt,-inputFormat} format  Format of the input file, ");
        System.out.println("                              one of [RDF/XML, N3, N-TRIPLE]");
        System.out.println(" {-s,-species} {on,level,off} Turn on/off species validation (Default: on). The");
        System.out.println("                              option \"level\" means species validation will be");
        System.out.println("                              done but no detailed report is printed");
        System.out.println(" -consistency {on,off}        Turn on/off consistency checking (Default: on)");
        System.out.println("                              Note that any reasoning service (classification");
        System.out.println("                              realization,query) will turn this option on");
        System.out.println(" -unsat              \t      Find the unsatisfiable classes in the ontology.");
        System.out.println("                              This option is unnecessary if classification is");
        System.out.println("                              selected");
        System.out.println(" {-c,-classify} [format]      Classify the ontology and display the hierarchy");
        System.out.println("                              in one of the formats [TREE, RDF, RDF-ALL]. If");
        System.out.println("                              realize option is selected, types for individuals");
        System.out.println("                              are also printed (Default format: TREE)");
        System.out.println("                              TREE: Display the hierarchy as an indented tree");
        System.out.println("                              RDF: Display only direct subclasses in RDF/XML");
        System.out.println("                              RDF-ALL: Display all subclasses in RDF/XML");
        System.out.println(" -cout file                   Save the classification results in a file rather");
        System.out.println("                              than printing on screen. The realization results");
        System.out.println("                              will also be saved if -r option is selected. The");
        System.out.println("                              classification format chosen will be used.");
        System.out.println(" {-r,-realize}                Compute and display the most specific instances");
        System.out.println("                              for each class. When this option is enabled, ");
        System.out.println("                              classification will be automatically done");
        System.out.println(" {-cf,-conclusionsFile} <URI> Check if all the triples in this ontology is");
        System.out.println("                              entailed by the input ontology");
        System.out.println(" {-cs,-conclusionsString} str A string representation of the conclusions file");
        System.out.println(" -conclusionsFormat format    Format of the conclusions file,");
        System.out.println("                              one of [RDF/XML, N3, NTRIPLES]");
        System.out.println(" {-qf,-queryFile} file        Read the SPARQL (or RDQL) query from the given");
        System.out.println("                              file and run it on the input ontology");
        System.out.println(" {-qs,-queryString} string    Run the given query on the input ontology");
        System.out.println(" {-qfmt,-queryFormat} format  Specify the format of the query (Default: SPARQL)");
        System.out.println("                              Should not be used if the input ontology is not");
        System.out.println("                              E-connected ");
        System.out.println(" -timeout time                Timeout after <time> seconds");
        System.out.println(" -timing                      Print detailed timing information");
        System.out.println(" -version                     Print the version information and exit");
        System.out.println(" -help                        Print this message");
    }

    public static VersionInfo getVersionInfo() {
        if (vinfo == null) {
            vinfo = new VersionInfo();
        }
        return vinfo;
    }

    private static void invalidOption(String option) {
        System.err.println("Invalid " + option + " option");
        Pellet.usage();
        System.exit(1);
    }

    public static final void main(String[] args) throws Exception {
        Pellet pellet = new Pellet();
        for (int i = 0; i < args.length; ++i) {
            String s;
            String arg = args[i];
            if (arg.equalsIgnoreCase("-help")) {
                Pellet.usage();
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("-version")) {
                VersionInfo vinfo = Pellet.getVersionInfo();
                System.out.println("Version : " + vinfo.getVersionString());
                System.out.println("Released: " + vinfo.getReleaseDate());
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("-species") || arg.equalsIgnoreCase("-s")) {
                if ((s = args[++i]).equalsIgnoreCase("on")) {
                    pellet.setSpecies(0);
                    continue;
                }
                if (s.equalsIgnoreCase("level")) {
                    pellet.setSpecies(1);
                    continue;
                }
                if (s.equalsIgnoreCase("off")) {
                    pellet.setSpecies(2);
                    continue;
                }
                Pellet.invalidOption("species");
                continue;
            }
            if (arg.equalsIgnoreCase("-consistency")) {
                if ((s = args[++i]).equalsIgnoreCase("on")) {
                    pellet.setConsistency(true);
                    continue;
                }
                if (s.equalsIgnoreCase("off")) {
                    pellet.setConsistency(false);
                    continue;
                }
                Pellet.invalidOption("consistency");
                continue;
            }
            if (arg.equalsIgnoreCase("-classify") || arg.equalsIgnoreCase("-c")) {
                String string = s = i == args.length - 1 ? "tree" : args[++i];
                if (s.equalsIgnoreCase("tree")) {
                    pellet.setClassifyFormat(1);
                    continue;
                }
                if (s.equalsIgnoreCase("rdf")) {
                    pellet.setClassifyFormat(2);
                    continue;
                }
                --i;
                continue;
            }
            if (arg.equalsIgnoreCase("-cout")) {
                pellet.setClassifyFile(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-inputFile") || arg.equalsIgnoreCase("-if")) {
                pellet.setInFile(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-inputFormat") || arg.equalsIgnoreCase("-ifmt")) {
                pellet.setInFormat(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-inputString") || arg.equalsIgnoreCase("-is")) {
                pellet.setInString(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-conclusionsFile") || arg.equalsIgnoreCase("-cf")) {
                pellet.setConclusionsFile(FileUtils.toURI(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-conclusionsFormat") || arg.equalsIgnoreCase("-cfmt")) {
                pellet.setConclusionsFormat(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-conclusionsString") || arg.equalsIgnoreCase("-cs")) {
                pellet.setConclusionsString(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-queryFile") || arg.equalsIgnoreCase("-qf")) {
                pellet.setQueryFile(FileUtils.toURI(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-queryString") || arg.equalsIgnoreCase("-qs")) {
                pellet.setQueryString(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-queryFormat") || arg.equalsIgnoreCase("-qfmt")) {
                pellet.setQueryFormat(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-timeout")) {
                pellet.setTimeout(Integer.parseInt(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-econn")) {
                System.err.println("E-connections is not supported in this version!");
                System.exit(1);
                continue;
            }
            if (arg.equalsIgnoreCase("-html")) {
                pellet.setFormatHTML(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-text")) {
                pellet.setFormatHTML(false);
                continue;
            }
            if (arg.equalsIgnoreCase("-unsat")) {
                pellet.setUnsat(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-realize") || arg.equalsIgnoreCase("-r")) {
                pellet.setRealize(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-quick")) {
                pellet.setConsistency(false);
                continue;
            }
            if (arg.equalsIgnoreCase("-quiet")) {
                pellet.setSpecies(1);
                continue;
            }
            if (arg.equalsIgnoreCase("-timing")) {
                pellet.setPrintTiming(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-dlsafe")) {
                System.err.println("WARNING: DL-safe rules are enabled by default and rules can be loaded directly to the reasoner");
                continue;
            }
            System.err.println("Unrecognized option: " + arg);
            Pellet.usage();
            System.exit(1);
        }
        pellet.run();
    }
}

