/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.SROIQStrategy;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SROIQIncStrategy
extends SROIQStrategy {
    public SROIQIncStrategy(ABox abox) {
        super(abox);
    }

    @Override
    public Iterator<Individual> getInitializeIterator() {
        return this.abox.getUpdatedIndividuals().iterator();
    }

    public Iterator<Individual> getNewIterator() {
        return this.abox.getNewIndividuals().iterator();
    }

    public Iterator<Edge> getNewEdgeIterator() {
        return this.abox.getNewEdges().iterator();
    }

    public Iterator getUnPrunedIterator() {
        return this.abox.getUnPrunedIndividuals().iterator();
    }

    public Iterator<Edge> getRemovedEdgeIterator() {
        return this.abox.getRemovedEdges().iterator();
    }

    public Iterator<ATermAppl> getRemovedTypeIterator() {
        return this.abox.getRemovedTypes().keySet().iterator();
    }

    public Set<ATermAppl> getRemovedTypes(ATermAppl node) {
        return this.abox.getRemovedTypes().get(node);
    }

    @Override
    protected void applyGuessingRule(IndividualIterator i) {
        i.reset();
    }

    @Override
    public void initialize() {
        Timer t = this.abox.getKB().timers.startTimer("initialize");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialize Started");
        }
        this.mergeList = new ArrayList();
        for (Branch branch : this.abox.getBranches()) {
            branch.setStrategy(this);
        }
        if (this.abox.getKB().aboxAddition) {
            Individual n;
            int branch = this.abox.getBranch();
            this.abox.setBranch(0);
            this.mergeList.addAll(this.abox.toBeMerged);
            if (!this.mergeList.isEmpty()) {
                this.mergeFirst();
            }
            Iterator<Individual> newIt = this.getNewIterator();
            while (newIt.hasNext()) {
                n = newIt.next();
                if (n.isMerged()) continue;
                n.setChanged(true);
                this.applyUniversalRestrictions(n);
                this.applyUnfoldingRule(n);
                this.applySelfRule(n);
            }
            Iterator<Object> it = this.getInitializeIterator();
            while (it.hasNext()) {
                n = it.next();
                this.applyNominalRule(n);
                if (n.isMerged()) {
                    n = n.getSame();
                }
                if (!n.isChanged(3)) continue;
                this.applyAllValues(n);
            }
            it = this.getNewEdgeIterator();
            while (it.hasNext()) {
                Edge edge = (Edge)it.next();
                Individual subj = edge.getFrom();
                Node obj = edge.getTo();
                if (subj.isMerged()) {
                    subj.getSame();
                }
                if (subj.isPruned()) continue;
                if (obj.isMerged()) {
                    obj.getSame();
                }
                if (obj.isPruned()) continue;
                Role pred = edge.getRole();
                DependencySet ds = edge.getDepends();
                this.applyDomainRange(subj, pred, obj, ds);
                if (subj.isPruned() || obj.isPruned()) {
                    return;
                }
                this.applyFunctionality(subj, pred, obj);
                if (subj.isPruned() || obj.isPruned()) {
                    return;
                }
                if (pred.isObjectRole()) {
                    Individual o = (Individual)obj;
                    this.checkReflexivitySymmetry(subj, pred, o, ds);
                    this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
                }
                if (!this.abox.getKB().getExpressivity().hasCardinality()) continue;
                this.updateQueueAddEdge(subj, pred, obj);
            }
            if (!this.mergeList.isEmpty()) {
                this.mergeFirst();
            }
            this.abox.setBranch(this.abox.getBranches().size() + 1);
        }
        if (this.abox.getKB().aboxDeletion && PelletOptions.USE_INCREMENTAL_DELETION) {
            Individual subj;
            Iterator<Object> i = this.getRemovedEdgeIterator();
            while (i.hasNext()) {
                Edge e = (Edge)i.next();
                Individual subj2 = e.getFrom();
                Node obj = e.getTo();
                subj2 = subj2.getSame();
                subj2.applyNext[2] = 0;
                subj2.applyNext[4] = 0;
                this.abox.getCompletionQueue().add(new QueueElement(subj2.name, null), CompletionQueue.SOMELIST);
                this.abox.getCompletionQueue().add(new QueueElement(subj2.name, null), CompletionQueue.MINLIST);
                if (!((obj = obj.getSame()) instanceof Individual)) continue;
                Individual objInd = (Individual)obj;
                objInd.applyNext[2] = 0;
                objInd.applyNext[4] = 0;
                this.abox.getCompletionQueue().add(new QueueElement(objInd.name, null), CompletionQueue.SOMELIST);
                this.abox.getCompletionQueue().add(new QueueElement(objInd.name, null), CompletionQueue.MINLIST);
            }
            i = this.getRemovedTypeIterator();
            while (i.hasNext()) {
                Role pred;
                ATermAppl nodeName = (ATermAppl)i.next();
                Node node = this.abox.getNode((ATerm)nodeName);
                if (node instanceof Individual) {
                    Individual ind = (Individual)node;
                    this.readdConjunctions(ind);
                    ind.applyNext[0] = 0;
                    ind.applyNext[3] = 0;
                    ind.applyNext[1] = 0;
                    this.abox.getCompletionQueue().add(new QueueElement(ind.name, null), CompletionQueue.ATOMLIST);
                    this.abox.getCompletionQueue().add(new QueueElement(ind.name, null), CompletionQueue.ORLIST);
                    this.applyAllValues(ind);
                    for (int j = 0; j < ind.getOutEdges().size(); ++j) {
                        Edge e = ind.getOutEdges().edgeAt(j);
                        if (e.getFrom().isPruned() || e.getTo().isPruned()) continue;
                        pred = e.getRole();
                        Node obj = e.getTo();
                        DependencySet ds = e.getDepends();
                        ATermAppl domain = pred.getDomain();
                        if (this.requiredAddType(ind, domain)) {
                            if (!PelletOptions.USE_TRACING) {
                                this.addType(ind, domain, ds.union(DependencySet.EMPTY, this.abox.doExplanation()));
                            } else {
                                this.addType(ind, domain, ds.union(pred.getExplainDomain(), this.abox.doExplanation()));
                            }
                        }
                        if (!(obj instanceof Individual)) continue;
                        Individual objInd = (Individual)obj;
                        objInd.applyNext[3] = 0;
                        objInd.applyNext[2] = 0;
                        objInd.applyNext[4] = 0;
                        this.abox.getCompletionQueue().add(new QueueElement(objInd.name, null), CompletionQueue.SOMELIST);
                        this.abox.getCompletionQueue().add(new QueueElement(objInd.name, null), CompletionQueue.MINLIST);
                        this.applyAllValues(ind);
                    }
                }
                for (int j = 0; j < node.getInEdges().size(); ++j) {
                    Edge e = node.getInEdges().edgeAt(j);
                    if (e.getFrom().isPruned() || e.getTo().isPruned()) continue;
                    subj = e.getFrom();
                    pred = e.getRole();
                    DependencySet ds = e.getDepends();
                    ATermAppl range = pred.getRange();
                    if (this.requiredAddType(node, range)) {
                        if (!PelletOptions.USE_TRACING) {
                            this.addType(node, range, ds.union(DependencySet.EMPTY, this.abox.doExplanation()));
                        } else {
                            this.addType(node, range, ds.union(pred.getExplainRange(), this.abox.doExplanation()));
                        }
                    }
                    subj.applyNext[3] = 0;
                    subj.applyNext[2] = 0;
                    subj.applyNext[4] = 0;
                    this.abox.getCompletionQueue().add(new QueueElement(subj.name, null), CompletionQueue.SOMELIST);
                    this.abox.getCompletionQueue().add(new QueueElement(subj.name, null), CompletionQueue.MINLIST);
                    this.applyAllValues(subj);
                }
            }
            i = this.getNewEdgeIterator();
            while (i.hasNext()) {
                this.applyPropertyRestrictions((Edge)i.next());
            }
            i = this.getUnPrunedIterator();
            while (i.hasNext()) {
                Edge e;
                int j;
                ATermAppl next = (ATermAppl)i.next();
                Individual ind = this.abox.getIndividual((ATerm)next);
                if (PelletOptions.USE_ADVANCED_COMPLETION_QUEUE) {
                    this.applyNominalRule(ind);
                    if (ind.isPruned()) {
                        ind = ind.getSame();
                    }
                    this.applyUnfoldingRule(ind);
                    if (ind.isPruned()) {
                        ind = ind.getSame();
                    }
                    this.applySomeValuesRule(ind);
                    if (ind.isPruned()) {
                        ind = ind.getSame();
                    }
                    this.applyMinRule(ind);
                    if (ind.isPruned()) {
                        ind = ind.getSame();
                    }
                    this.applyDisjunctionRule(ind);
                    continue;
                }
                for (j = 0; j < 7; ++j) {
                    ind.applyNext[j] = 0;
                }
                this.abox.getCompletionQueue().add(new QueueElement(ind.name, null), -1);
                this.applyAllValues(ind);
                for (j = 0; j < ind.getOutEdges().size(); ++j) {
                    Node obj;
                    e = ind.getOutEdges().edgeAt(j);
                    if (!e.getFrom().isPruned() && !e.getTo().isPruned()) {
                        this.applyPropertyRestrictions(e);
                    }
                    if (!((obj = e.getTo()) instanceof Individual)) continue;
                    Individual objInd = (Individual)obj;
                    objInd.applyNext[3] = 0;
                    this.applyAllValues(objInd);
                }
                for (j = 0; j < ind.getInEdges().size(); ++j) {
                    e = ind.getInEdges().edgeAt(j);
                    if (!e.getFrom().isPruned() && !e.getTo().isPruned()) {
                        this.applyPropertyRestrictions(e);
                    }
                    subj = e.getFrom();
                    subj.applyNext[3] = 0;
                    this.applyAllValues(subj);
                }
            }
        }
        this.abox.changed = true;
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
        t.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialize Ended");
        }
    }
}

