/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDMonth
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace MONTH_VALUE_SPACE;
    public static XSDMonth instance;

    protected XSDMonth(ATermAppl name) {
        super(name, MONTH_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDMonth type = new XSDMonth(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"gMonth");
            min = (IDateTimeValueType)dt.createValue("--01--", null);
            max = (IDateTimeValueType)dt.createValue("--12--", null);
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        MONTH_VALUE_SPACE = new MonthValueSpace();
        instance = new XSDMonth(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#gMonth"));
    }

    private static class MonthValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public MonthValueSpace() {
            super(min, max, dt);
        }

        public Object getValue(String value) {
            value = value + "--";
            return dt.createValue(value, null);
        }

        public int count(Object start, Object end) {
            BigDateTimeValueType calendarStart = ((IDateTimeValueType)start).getBigValue();
            BigDateTimeValueType calendarEnd = ((IDateTimeValueType)end).getBigValue();
            return calendarEnd.getMonth() - calendarStart.getMonth() + 1;
        }

        public Object succ(Object value, int n) {
            BigInteger bigN = new BigInteger(String.valueOf(n));
            BigTimeDurationValueType nMonths = new BigTimeDurationValueType(NumberUtils.INTEGER_ZERO, bigN, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.DECIMAL_ZERO);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nMonths);
            return s;
        }
    }
}

