/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.OutputStream;
import org.mindswap.pellet.jena.PelletQueryExecution;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class BnodeQueryExample {
    public static void main(String[] args) throws Exception {
        String ns = "http://www.w3.org/2001/sw/WebOnt/guide-src/food";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ns + ".owl");
        Resource RedMeatCourse = model.getResource(ns + "#RedMeatCourse");
        Resource PastaWithLightCreamCourse = model.getResource(ns + "#PastaWithLightCreamCourse");
        model.createIndividual(ns + "#MyLunch", PastaWithLightCreamCourse);
        model.createIndividual(ns + "#MyDinner", RedMeatCourse);
        String queryBegin = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\r\nPREFIX food: <http://www.w3.org/2001/sw/WebOnt/guide-src/food#>\r\nPREFIX wine: <http://www.w3.org/2001/sw/WebOnt/guide-src/wine#>\r\n\r\nSELECT ?Meal ?WineColor\r\nWHERE {\r\n";
        String queryEnd = "}";
        String queryStr1 = queryBegin + "   ?Meal rdf:type food:MealCourse .\r\n" + "   ?Meal food:hasDrink _:Wine .\r\n" + "   _:Wine wine:hasColor ?WineColor" + queryEnd;
        String queryStr2 = queryBegin + "   ?Meal rdf:type food:MealCourse .\r\n" + "   ?Meal food:hasDrink ?Wine .\r\n" + "   ?Wine wine:hasColor ?WineColor" + queryEnd;
        Query query1 = QueryFactory.create((String)queryStr1);
        Query query2 = QueryFactory.create((String)queryStr2);
        BnodeQueryExample.printQueryResults("Running first query with PelletQueryEngine...", new PelletQueryExecution(query1, (Model)model), query1);
        BnodeQueryExample.printQueryResults("Running second query with PelletQueryEngine...", new PelletQueryExecution(query2, (Model)model), query2);
        BnodeQueryExample.printQueryResults("Running first query with standard Jena QueryEngine...", QueryExecutionFactory.create((Query)query1, (Model)model), query1);
    }

    public static void printQueryResults(String header, QueryExecution qe, Query query) throws Exception {
        System.out.println(header);
        ResultSet results = qe.execSelect();
        ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results, (Query)query);
        System.out.println();
    }
}

