/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    private Taxonomy<T> taxonomy;
    private OutputFormatter out;
    private Set<T> bottomEquivalents;
    private Set<T> printed;
    private final Comparator<T> comparator = new Comparator<T>(){

        @Override
        public int compare(T c, T d) {
            return Comparators.stringComparator.compare(c.toString(), d.toString());
        }
    };
    private final Comparator<Collection<T>> setComparator = new Comparator<Collection<T>>(){

        @Override
        public int compare(Collection<T> c, Collection<T> d) {
            return FunctionalTaxonomyPrinter.this.comparator.compare(c.iterator().next(), d.iterator().next());
        }
    };

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new OutputFormatter());
    }

    @Override
    public void print(Taxonomy<T> taxonomy, OutputFormatter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        this.bottomEquivalents = new TreeSet<T>(this.comparator);
        this.bottomEquivalents.addAll(taxonomy.getBottom().getEquivalents());
        this.printed = new HashSet<T>();
        out.println();
        TreeSet<T> sortedTop = new TreeSet<T>(this.comparator);
        sortedTop.addAll(taxonomy.getTop().getEquivalents());
        Set<TreeSet<T>> topGroup = Collections.singleton(sortedTop);
        this.printGroup(topGroup);
        this.taxonomy = null;
        this.out = null;
        this.bottomEquivalents = null;
        this.printed = null;
        out.println();
        out.flush();
    }

    private void printGroup(Collection<? extends Collection<T>> concepts) {
        LinkedHashSet<Collection<T>> nextGroup = new LinkedHashSet<Collection<T>>();
        for (Collection<T> eqC : concepts) {
            T firstC = eqC.iterator().next();
            Set<Set<T>> supEqs = this.taxonomy.getSupers(firstC, true);
            if (supEqs.size() > 1 && this.printed.contains(firstC)) continue;
            this.printed.add(firstC);
            this.out.print("(");
            this.printEqClass(eqC);
            this.out.print(" ");
            TreeSet<Collection<T>> sortedSupEqs = new TreeSet<Collection<T>>(this.setComparator);
            Iterator<Set<T>> j = supEqs.iterator();
            while (j.hasNext()) {
                TreeSet<T> group = new TreeSet<T>(this.comparator);
                group.addAll((Collection)j.next());
                sortedSupEqs.add(group);
            }
            this.printEqClassGroups(sortedSupEqs);
            this.out.print(" ");
            TreeSet<Collection<T>> sortedSubEqs = new TreeSet<Collection<T>>(this.setComparator);
            Set<Set<T>> subEqs = this.taxonomy.getSubs(firstC, true);
            Iterator<Set<T>> j2 = subEqs.iterator();
            while (j2.hasNext()) {
                TreeSet<T> group = new TreeSet<T>(this.comparator);
                group.addAll((Collection)j2.next());
                sortedSubEqs.add(group);
            }
            this.printEqClassGroups(sortedSubEqs);
            nextGroup.addAll(sortedSubEqs);
            this.out.println(")");
        }
        switch (nextGroup.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.printGroup(nextGroup);
                break;
            }
            default: {
                nextGroup.remove(this.bottomEquivalents);
                this.printGroup(nextGroup);
            }
        }
    }

    private void printEqClass(Collection<T> concept) {
        int size = concept.size();
        T c2 = null;
        switch (size) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                c2 = concept.iterator().next();
                this.printURI(c2);
                break;
            }
            default: {
                this.out.print("(");
                boolean first = true;
                for (T c2 : concept) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printURI(c2);
                }
                this.out.print(")");
            }
        }
    }

    private void printEqClassGroups(Collection<? extends Collection<T>> concepts) {
        int size = concepts.size();
        Collection<T> eqC2 = null;
        switch (size) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                eqC2 = concepts.iterator().next();
                this.out.print("(");
                this.printEqClass(eqC2);
                this.out.print(")");
                break;
            }
            default: {
                this.out.print("(");
                boolean first = true;
                for (Collection<T> eqC2 : concepts) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printEqClass(eqC2);
                }
                this.out.print(")");
            }
        }
    }

    private void printURI(T c) {
        String uri = c.toString();
        if (c.equals(ATermUtils.TOP)) {
            uri = "http://www.w3.org/2002/07/owl#Thing";
        } else if (c.equals(ATermUtils.BOTTOM)) {
            uri = "http://www.w3.org/2002/07/owl#Nothing";
        }
        this.out.printURI(uri);
    }
}

