/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.URIUtils;

public class SimpleRDQLParser
implements QueryParser {
    public static Log log = LogFactory.getLog(QueryEngine.class);
    private QNameProvider qnames = new QNameProvider();
    private Query query;
    private KnowledgeBase kb;

    public SimpleRDQLParser() {
        this.qnames.setMapping("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.qnames.setMapping("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.qnames.setMapping("owl", "http://www.w3.org/2002/07/owl#");
    }

    public Query parse(InputStream in, KnowledgeBase kb) throws IOException {
        return this.parse(new InputStreamReader(in), kb);
    }

    public Query parse(Reader in, KnowledgeBase kb) throws IOException {
        StringBuffer queryString = new StringBuffer();
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        while (line != null) {
            queryString.append(line).append("\n");
            line = r.readLine();
        }
        return this.parse(queryString.toString(), kb);
    }

    public Query parse(String queryStr, KnowledgeBase kb) {
        this.kb = kb;
        this.query = new QueryImpl(kb);
        queryStr = queryStr.trim();
        String[] clauses = Pattern.compile("WHERE", 2).split(queryStr);
        String selectClause = clauses[0].substring("SELECT".length() + 1).trim();
        clauses = Pattern.compile("USING", 2).split(clauses[1]);
        String whereClause = clauses[0].trim();
        String usingClause = clauses.length > 1 ? clauses[1] : null;
        this.parseUsing(usingClause);
        this.parseWhere(whereClause);
        this.parseSelect(selectClause);
        return this.query;
    }

    private void parseUsing(String usingClause) {
        if (usingClause == null) {
            return;
        }
        String[] ns = usingClause.split(",");
        for (int i = 0; i < ns.length; ++i) {
            String[] str = Pattern.compile(" FOR ", 2).split(ns[i], 2);
            if (str.length != 2) {
                throw new UnsupportedFeatureException("Invalid prefix declaration: " + ns[i]);
            }
            String prefix = str[0].trim();
            String uri = str[1].trim();
            if (!uri.startsWith("<") || !uri.endsWith(">")) {
                throw new UnsupportedOperationException("The URI should be written between '<' and '>': " + ns[i]);
            }
            uri = uri.substring(1, uri.length() - 1);
            this.qnames.setMapping(prefix, uri);
        }
    }

    private void parseWhere(String whereClause) {
        String[] patterns = whereClause.split("\\)");
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i].trim();
            if (pattern.startsWith(",")) {
                pattern = pattern.substring(1).trim();
            }
            pattern = pattern.substring(1);
            String[] nodes = pattern.split(",");
            ATermAppl subj = this.makeTerm(nodes[0]);
            ATermAppl pred = this.makeTerm(nodes[1]);
            ATermAppl obj = this.makeTerm(nodes[2]);
            if (pred.getName().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                if (ATermUtils.isVar(obj)) {
                    throw new UnsupportedFeatureException("Variables cannot be used as objects of rdf:type triples in ABoxQuery");
                }
                this.query.addTypePattern(subj, obj);
                continue;
            }
            if (ATermUtils.isVar(pred)) {
                throw new UnsupportedFeatureException("Variables cannot be used in predicate position in AboxQuery");
            }
            if (pred.getName().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || pred.getName().startsWith("http://www.w3.org/2002/07/owl#") || pred.getName().startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
                throw new UnsupportedFeatureException("Predicates that belong to [RDF, RDFS, OWL] namespaces cannot be used in ABoxQuery");
            }
            if (!this.kb.isProperty((ATerm)pred)) {
                throw new UnsupportedFeatureException("Property " + pred + " is not present in KB.");
            }
            if (this.kb.isDatatypeProperty((ATerm)pred) && this.query.getDistVars().contains(obj) && ATermUtils.isVar(subj)) {
                log.warn((Object)("Warning: Forcing variable " + subj + " to be distinguished (Subject of datatype triple)"));
                this.query.addDistVar(subj);
            }
            this.query.addEdgePattern(subj, pred, obj);
        }
    }

    private void parseSelect(String selectClause) {
        if (selectClause.equals("*")) {
            for (ATermAppl var : this.query.getVars()) {
                this.query.addResultVar(var);
            }
        } else {
            String[] vars = selectClause.split(",");
            for (int i = 0; i < vars.length; ++i) {
                ATermAppl var = this.makeTerm(vars[i]);
                this.query.addResultVar(var);
            }
        }
    }

    private ATermAppl makeTerm(String name) {
        if ((name = name.trim()).startsWith("?")) {
            return ATermUtils.makeVar(name.substring(1));
        }
        if (name.startsWith("<")) {
            if (!name.endsWith(">")) {
                throw new UnsupportedOperationException("URI missing closing '>': " + name);
            }
            name = name.substring(1, name.length() - 1);
        } else {
            String[] str = name.split(":");
            if (str.length != 2) {
                throw new UnsupportedOperationException("Invalid qname: " + name);
            }
            String ns = this.qnames.getURI(str[0]);
            if (ns == null) {
                throw new UnsupportedOperationException("Prefix '" + name + "' not defined");
            }
            name = ns + str[1];
        }
        if (URI.create(name) == null) {
            throw new UnsupportedOperationException("Invalid URI: " + name);
        }
        if (name.equals("http://www.w3.org/2002/07/owl#Thing")) {
            return ATermUtils.TOP;
        }
        if (name.equals("http://www.w3.org/2002/07/owl#Nothing")) {
            return ATermUtils.BOTTOM;
        }
        if (PelletOptions.USE_LOCAL_NAME) {
            return ATermUtils.makeTermAppl(URIUtils.getLocalName(name));
        }
        return ATermUtils.makeTermAppl(name);
    }
}

