/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mindswap.pellet.rete.BetaNode;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Node;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.rete.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaNode
extends Node {
    protected List<BetaNode> betaNodes = new ArrayList<BetaNode>();
    protected TermTuple pattern;

    public AlphaNode(TermTuple t) {
        this.pattern = t;
        this.vars = this.pattern.getVars();
        Collections.sort(this.vars);
    }

    public boolean add(Fact fact) {
        List<Constant> key = this.match(fact);
        if (key != null) {
            return this.index.add(key, new Fact(fact.getDependencySet(), key));
        }
        return false;
    }

    private List<Constant> match(Fact fact) {
        if (fact.getElements().size() != this.pattern.getElements().size()) {
            return null;
        }
        HashMap<Variable, Constant> bindings = new HashMap<Variable, Constant>();
        List pList = this.pattern.getElements();
        List fList = fact.getElements();
        Term p = null;
        Constant f = null;
        for (int i = 0; i < this.pattern.getElements().size(); ++i) {
            p = (Term)pList.get(i);
            f = (Constant)fList.get(i);
            if (!p.isVariable()) {
                if (p.equals(f)) continue;
                return null;
            }
            if (!bindings.containsKey(p)) {
                bindings.put((Variable)p, f);
                continue;
            }
            if (((Term)bindings.get(p)).equals(f)) continue;
            return null;
        }
        ArrayList<Constant> bindingList = new ArrayList<Constant>();
        for (Variable var : this.getKey()) {
            bindingList.add((Constant)bindings.get(var));
        }
        return bindingList;
    }

    public String toString() {
        return "AlphaNode(" + this.pattern.toString() + ")";
    }
}

