/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.rete.AlphaIndex;
import org.mindswap.pellet.rete.AlphaNode;
import org.mindswap.pellet.rete.AlphaStore;
import org.mindswap.pellet.rete.BetaNode;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Rule;
import org.mindswap.pellet.rete.RuleNode;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    public static final Constant DIFF_FROM;
    public static final int OBJ = 2;
    public static final int PRED = 0;
    public static final Constant SAME_AS;
    public static final int SUBJ = 1;
    public static final Constant TYPE;
    ABox abox;
    AlphaIndex alphaIndex;
    AlphaStore alphaNodeStore;
    HashSet<ATermAppl> propertiesMentioned;

    public Compiler(ABox abox) {
        this.abox = abox;
        this.alphaNodeStore = new AlphaStore();
        this.alphaIndex = new AlphaIndex();
        this.propertiesMentioned = new HashSet();
    }

    public Compiler compile(Collection<Rule> rules) {
        block5: for (Rule rule : rules) {
            AlphaNode alpha2;
            BetaNode beta1;
            AlphaNode alpha1;
            AlphaStore alphaNodesOfRule = new AlphaStore();
            for (TermTuple anodePattern : rule.getBody()) {
                ATermAppl pred;
                AlphaNode anode = this.makeAlphaNode(anodePattern);
                alphaNodesOfRule.addNode(anode);
                if (anodePattern.getElements().size() != 3 || ((Term)anodePattern.getElements().get(0)).isVariable() || this.abox.getRole((ATerm)(pred = ((Constant)anodePattern.getElements().get(0)).getValue())) == null) continue;
                this.propertiesMentioned.add(pred);
            }
            for (TermTuple anodePattern : rule.getHead()) {
                ATermAppl pred;
                if (anodePattern.getElements().size() != 3 || ((Term)anodePattern.getElements().get(0)).isVariable() || this.abox.getRole((ATerm)(pred = ((Constant)anodePattern.getElements().get(0)).getValue())) == null) continue;
                this.propertiesMentioned.add(pred);
            }
            alphaNodesOfRule.sort();
            this.alphaNodeStore.sort();
            switch (alphaNodesOfRule.nodes.size()) {
                case 0: {
                    alphaNodesOfRule.addNode(this.makeAlphaNode(new TermTuple(DependencySet.INDEPENDENT, new Term[0])));
                }
                case 1: {
                    alpha1 = alphaNodesOfRule.nodes.get(0);
                    beta1 = this.makeBetaNode(alpha1, alpha1, false);
                    alpha1.betaNodes = new ArrayList<BetaNode>();
                    alpha1.betaNodes.add(beta1);
                    beta1.rule = new RuleNode(rule);
                    beta1.rule.betaNode = beta1;
                    continue block5;
                }
                case 2: {
                    beta1 = this.makeBetaNode(alphaNodesOfRule.nodes.get(0), alphaNodesOfRule.nodes.get(1), false);
                    alpha1 = alphaNodesOfRule.nodes.get(0);
                    alpha1.betaNodes = new ArrayList<BetaNode>();
                    alpha1.betaNodes.add(beta1);
                    alpha2 = alphaNodesOfRule.nodes.get(1);
                    alpha2.betaNodes = new ArrayList<BetaNode>();
                    alpha2.betaNodes.add(beta1);
                    beta1.rule = new RuleNode(rule);
                    beta1.rule.betaNode = beta1;
                    continue block5;
                }
            }
            beta1 = this.makeBetaNode(alphaNodesOfRule.nodes.get(0), alphaNodesOfRule.nodes.get(1), true);
            alpha1 = alphaNodesOfRule.nodes.get(0);
            alpha1.betaNodes = new ArrayList<BetaNode>();
            alpha1.betaNodes.add(beta1);
            alpha2 = alphaNodesOfRule.nodes.get(1);
            alpha2.betaNodes = new ArrayList<BetaNode>();
            alpha2.betaNodes.add(beta1);
            this.makeBetaNetwork(rule, beta1, alphaNodesOfRule.nodes.subList(2, alphaNodesOfRule.nodes.size()));
        }
        return this;
    }

    public Set<Fact> compileFacts(ABox abox) {
        HashSet<Fact> result = new HashSet<Fact>();
        IndividualIterator i = abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            if (!ind.isNamedIndividual() || ind.isPruned()) continue;
            for (ATermAppl indType : ind.getTypes()) {
                result.add(this.createFact(ind, indType, ind.getDepends((ATerm)indType)));
            }
            for (Node different : ind.getDifferents()) {
                if (!different.isNamedIndividual() || different.isPruned()) continue;
                result.add(this.createDifferent(ind, different, ind.getDifferenceDependency(different)));
            }
            for (ATermAppl prop : this.propertiesMentioned) {
                Role r = abox.getRole((ATerm)prop);
                for (Edge edge : ind.getRNeighborEdges(r)) {
                    Node to = edge.getNeighbor(ind).getSame();
                    if (!to.isRootNominal() || to.isPruned()) continue;
                    result.add(this.createFact(prop, ind, to, edge.getDepends()));
                }
            }
        }
        return result;
    }

    private Fact createDifferent(Individual ind1, Node ind2, DependencySet ds) {
        Constant subj = new Constant(ind1.getName());
        Constant obj = new Constant(ind2.getName());
        return new Fact(ds, DIFF_FROM, subj, obj);
    }

    private Fact createFact(ATermAppl r, Individual from, Node to, DependencySet ds) {
        Constant pred = new Constant(r);
        Constant subj = new Constant(from.getName());
        Constant obj = new Constant(to.getName());
        return new Fact(ds, pred, subj, obj);
    }

    private Fact createFact(Individual ind, ATermAppl c, DependencySet ds) {
        Constant predType = TYPE;
        Constant subj = new Constant(ind.getName());
        Constant obj = new Constant(c);
        return new Fact(ds, predType, subj, obj);
    }

    private AlphaNode makeAlphaNode(TermTuple pattern) {
        AlphaNode a = new AlphaNode(pattern);
        this.alphaIndex.add(a);
        this.alphaNodeStore.addNode(a);
        return a;
    }

    private void makeBetaNetwork(Rule rule, BetaNode betaNode, List<AlphaNode> alphaNodeList) {
        if (alphaNodeList.size() == 0) {
            betaNode.rule = new RuleNode(rule);
            betaNode.rule.betaNode = betaNode;
        } else {
            AlphaNode alpha = alphaNodeList.get(0);
            BetaNode betaChild = this.makeBetaNode(betaNode, alpha, true);
            betaChild.parents = new ArrayList<BetaNode>();
            betaChild.parents.add(betaNode);
            betaNode.children = new ArrayList<BetaNode>();
            betaNode.children.add(betaChild);
            alpha.betaNodes = new ArrayList<BetaNode>();
            alpha.betaNodes.add(betaChild);
            this.makeBetaNetwork(rule, betaChild, alphaNodeList.subList(1, alphaNodeList.size()));
        }
    }

    private BetaNode makeBetaNode(org.mindswap.pellet.rete.Node node1, org.mindswap.pellet.rete.Node node2, boolean futureJoins) {
        BetaNode b = new BetaNode(node1, node2, this.abox.doExplanation());
        return b;
    }

    static {
        String PREFIX = "tag:clarkparsia.info,2007:pellet:dl-safe-rules:predicate:";
        DIFF_FROM = new Constant(ATermUtils.makeTermAppl(PREFIX + "differentFrom"));
        SAME_AS = new Constant(ATermUtils.makeTermAppl(PREFIX + "sameAs"));
        TYPE = new Constant(ATermUtils.makeTermAppl(PREFIX + "type"));
    }
}

