/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.utils;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    static Random rand = new Random(System.currentTimeMillis());

    public static ATermAppl selectRandomConcept(Individual ind) {
        Set<ATermAppl> types = ind.getTypes();
        ATermAppl clazz2 = null;
        int MAX = 20;
        int count = 0;
        do {
            ++count;
            int index = rand.nextInt(types.size());
            for (ATermAppl clazz2 : types) {
            }
        } while ((clazz2 == ATermUtils.TOP || clazz2 == ATermUtils.BOTTOM) && count < MAX);
        return clazz2;
    }

    public static ATermAppl selectRandomConcept(KnowledgeBase kb) {
        int index;
        ArrayList<ATermAppl> classes = new ArrayList<ATermAppl>(kb.getTBox().getAllClasses());
        ATermAppl clazz = null;
        while ((clazz = (ATermAppl)classes.get(index = rand.nextInt(classes.size()))) == ATermUtils.TOP || clazz == ATermUtils.BOTTOM) {
        }
        return clazz;
    }

    public static ATermAppl selectRandomObjectProperty(KnowledgeBase kb) {
        int index;
        ArrayList<Role> roles = new ArrayList<Role>(kb.getRBox().getRoles());
        Role role = null;
        while (!(role = (Role)roles.get(index = rand.nextInt(roles.size()))).isObjectRole()) {
        }
        return role.getName();
    }

    public static ATermAppl selectRandomIndividual(KnowledgeBase kb) {
        ArrayList<ATermAppl> inds = new ArrayList<ATermAppl>(kb.getIndividuals());
        int index = rand.nextInt(inds.size());
        return (ATermAppl)inds.get(index);
    }

    public static Set<ATermAppl> selectAssertions(KnowledgeBase kb, int num, boolean typesOnly, boolean useNominals, boolean useDataProps, Set excludeSet) {
        HashSet<ATermAppl> assertions = new HashSet<ATermAppl>();
        Random rand = new Random(System.currentTimeMillis());
        int found = -1;
        int count = 0;
        while (count < num) {
            int i;
            Iterator<ATermAppl> it;
            ATermAppl ind;
            int type = rand.nextInt(2);
            if (found == 0) {
                type = 0;
            } else if (found == 1) {
                type = 1;
            }
            if (typesOnly) {
                type = 0;
            }
            if (type == 0) {
                type = rand.nextInt(kb.getIndividuals().size());
                ind = null;
                it = kb.getIndividuals().iterator();
                for (i = -1; it.hasNext() && i < type; ++i) {
                    ind = it.next();
                }
                if (kb.getABox().getIndividual((ATerm)ind).getTypes().size() <= 1) {
                    found = 0;
                    continue;
                }
                type = rand.nextInt(kb.getABox().getIndividual((ATerm)ind).getTypes().size());
                Object theType = null;
                Iterator<ATermAppl> it2 = kb.getABox().getIndividual((ATerm)ind).getTypes().iterator();
                for (i = -1; it2.hasNext() && i < type; ++i) {
                    theType = it2.next();
                }
                if (theType.equals(ATermUtils.TOP) || ATermUtils.isNominal((ATermAppl)theType)) {
                    found = 0;
                    continue;
                }
                ATermAppl typeAssertion = ATermUtils.makeTypeAtom(ind, (ATermAppl)theType);
                if (assertions.contains(typeAssertion) || excludeSet.contains(typeAssertion)) {
                    found = 0;
                    continue;
                }
                assertions.add(typeAssertion);
            } else {
                Iterator<Edge> it3;
                EdgeList edges;
                type = rand.nextInt(kb.getIndividuals().size());
                ind = null;
                it = kb.getIndividuals().iterator();
                for (i = -1; it.hasNext() && i < type; ++i) {
                    ind = it.next();
                }
                if (kb.getABox().getIndividual((ATerm)ind).getInEdges().size() == 0 && kb.getABox().getIndividual((ATerm)ind).getOutEdges().size() == 0) {
                    found = 1;
                    continue;
                }
                type = rand.nextInt(2);
                Edge e = null;
                if (type == 0 && kb.getABox().getIndividual((ATerm)ind).getInEdges().size() != 0) {
                    edges = kb.getABox().getIndividual((ATerm)ind).getInEdges();
                    type = rand.nextInt(edges.size());
                    it3 = edges.iterator();
                    for (i = -1; it3.hasNext() && i < type; ++i) {
                        e = it3.next();
                    }
                } else if (type == 0) {
                    edges = kb.getABox().getIndividual((ATerm)ind).getOutEdges();
                    type = rand.nextInt(edges.size());
                    it3 = edges.iterator();
                    for (i = -1; it3.hasNext() && i < type; ++i) {
                        e = it3.next();
                    }
                } else if (type == 1 && kb.getABox().getIndividual((ATerm)ind).getOutEdges().size() != 0) {
                    edges = kb.getABox().getIndividual((ATerm)ind).getOutEdges();
                    type = rand.nextInt(edges.size());
                    it3 = edges.iterator();
                    for (i = -1; it3.hasNext() && i < type; ++i) {
                        e = it3.next();
                    }
                } else {
                    edges = kb.getABox().getIndividual((ATerm)ind).getInEdges();
                    type = rand.nextInt(edges.size());
                    it3 = edges.iterator();
                    for (i = -1; it3.hasNext() && i < type; ++i) {
                        e = it3.next();
                    }
                }
                if (!useDataProps && (e.getTo().getName() instanceof Literal || kb.getDataProperties().contains(e.getRole().getName()))) {
                    found = 1;
                    continue;
                }
                ATermAppl propAxiom = ATermUtils.makePropAtom(e.getRole().getName(), e.getFrom().getName(), e.getTo().getName());
                if (assertions.contains(propAxiom) || excludeSet.contains(propAxiom)) {
                    found = 1;
                    continue;
                }
                assertions.add(propAxiom);
            }
            found = -1;
            ++count;
        }
        return assertions;
    }
}

