
package org.semwebtech.util;

import java.net.URI;
import java.util.Iterator;

import org.mindswap.pellet.jena.PelletReasonerFactory;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;

public class AddNegativeAssertion{

	public static void main(String[] args) {
		//String ont = "http://acl.icnet.uk/~mw/RuleTest1.owl";
		String ontFile = "http://user.informatik.uni-goettingen.de/~schenk/data/test.owl";
		
		if (args.length >0)
			ontFile = args[0];

		OntModel model = ModelFactory.createOntologyModel( 
				PelletReasonerFactory.THE_SPEC, null );
		//Model model = ModelFactory.createDefaultModel();
		
		model.read( ontFile );

		StmtIterator iter3 = model.listStatements();
		while (iter3.hasNext()) {
			System.out.println("  " + iter3.next());

		}

		URI ont3 =  URI.create("http://user.informatik.uni-goettingen.de/~schenk/data/test.owl");


		Individual a = model.getIndividual(ont3 +"#a");
		Individual b = model.getIndividual(ont3 +"#b");
		Individual c = model.getIndividual(ont3 +"#c");

		OntClass A = model.getOntClass(ont3+"#A");
		OntClass B = model.getOntClass(ont3+"#B");
		OntClass C = model.getOntClass(ont3+"#C");

		ObjectProperty prop = model.getObjectProperty(ont3+"#myProp");

		ObjectProperty negProp = model.getObjectProperty(ont3+"#notMyProp");



		//System.out.println(negProp);
		//System.out.println(A);

		model.prepare();

		System.out.println("\n" + "\n");
		
		printInstances(A);
		printInstances(B);
		printInstances(C);

		printPropertyValues(a, prop);
		printPropertyValues(b, prop);
		printPropertyValues(c, prop);

		printPropertyValues(a, negProp);
		printPropertyValues(b, negProp);
		printPropertyValues(c, negProp);
		
		
		System.out.println("Neg. Statements");
		StmtIterator iter = model.listStatements(a, negProp, (RDFNode) null);
		while (iter.hasNext()) {
			Statement s = (Statement) iter.next();
			System.out.println("  " + s);

			addNegAssertion(model, s);

		}

		model.prepare();

		System.out.println("\n\nNeg. Statements2");
		
		StmtIterator iter2 = model.listStatements();
		while (iter2.hasNext()) {
			System.out.println("  " + iter2.next());

		}
		
		
	}



	public static void addNegAssertion(OntModel m, Statement s) {

		String OWL11NS = "http://www.w3.org/2006/12/owl11#";
		Resource OWL11NOPA = m.createResource(OWL11NS + 
		"NegativeObjectPropertyAssertion");

		Resource assertion =
			m.createResource()
			.addProperty(RDF.type, OWL11NOPA)
			.addProperty(RDF.subject, s.getSubject())
			.addProperty(RDF.predicate, "http://user.informatik.uni-goettingen.de/~schenk/data/test.owl#myProp")
			.addProperty(RDF.object, s.getObject());
	}

	public static void printPropertyValues(Individual ind, Property prop) {
		System.out.print( ind.getLocalName() + " has " + prop.getLocalName() + 
		"(s): " );
		printIterator( ind.listPropertyValues( prop ) );
	}

	public static void printInstances(OntClass cls) {
		System.out.print( cls.getLocalName() + " instances: " );
		printIterator( cls.listInstances() );
	}

	public static void printIterator(Iterator i) {
		if( !i.hasNext() ) {
			System.out.print( "none" );
		}
		else {
			while( i.hasNext() ) {
				Resource val = (Resource) i.next();
				System.out.print( val.getLocalName() );
				if( i.hasNext() )
					System.out.print( ", " );
			}
		}
		System.out.println();
	}
}
