/**
 * Description:
 * 
 * Franz Schenk <schenk@informatik.uni-goettingen.de>
 * 
 */
package org.semwebtech.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.InfModel;

/*
 *  @ schenk
 */
public class QueryHandler {
	//---------------------------------------------------------------
	public String loadQuery(String sparqlFile){
		// Loading a SPARQL query from file
		String query = new String();
		try{
		BufferedReader reader = new BufferedReader(
				new FileReader (new File(sparqlFile)));
		String line = reader.readLine();
		while (line != null)
		{
			if ( ! line.startsWith("#")){
				query += line;	
			}
			line = reader.readLine();
		}
		reader.close();
		}catch (Exception e){
			System.out.println(e.toString() );
		}
		return query;
	}
	//---------------------------------------------------------------

	
	//---------------------------------------------------------------
	public boolean executeAskQuery(String query, InfModel infmodel){
		QueryExecution qexec = null;
		try{
			Query qu = QueryFactory.create(query) ;
			qexec = QueryExecutionFactory.create(qu, infmodel) ;
			
			//---------------------------------------------------------------
			// Boolsche Anfrage
			if (  qexec.execAsk()){
				return true;
			}
			else{
				return false;
			}
		}//Ende try
		catch(QueryException qe){
			System.out.println("Fehler.");
		}
		finally{qexec.close();}
		return false;
	}
	//---------------------------------------------------------------

	//---------------------------------------------------------------
	// Returns number of variables contained in a query
	public int numberOfVariables(String query){
		return parseRequest(query).size(); 
	}
	//---------------------------------------------------------------

	
	//---------------------------------------------------------------
	public Vector executeSelectQuery(String query, InfModel infmodel){
		Vector<String>variables = parseRequest(query);
		Vector<Object> resultVector = new Vector<Object>();
		QueryExecution qexec = null;
		try{
			Query qu = QueryFactory.create(query) ;
			qexec = QueryExecutionFactory.create(qu, infmodel) ;
			ResultSet results = qexec.execSelect();
			for (  ; results.hasNext() ; )
			{
				//System.out.println("Naechstes Ergebnis: ");
				QuerySolution soln = results.nextSolution();
				for(int i=0; i<variables.size(); i++)
				{
					String var = variables.get(i);
					Object x = soln.get(var);
				    //System.out.println("Res "+x.toString());
					resultVector.addElement(x);
				}
			}
		}
		catch(Exception e){System.out.println(e.toString());}
		finally{qexec.close();}
		return resultVector;
	}
	//---------------------------------------------------------------

	
	//---------------------------------------------------------------
	private Vector<String> parseRequest(String requeststring)
	{
		//Search case insensitiv
		String requestinsensitiv = requeststring.toUpperCase();
		//extraction of the variables 
		int indexbegin = requestinsensitiv.indexOf("SELECT")+6;		
		int indexend = requestinsensitiv.indexOf("FROM");
		if (indexend == -1)
		{
			indexend = requestinsensitiv.indexOf("WHERE");
			if (indexend == -1)
				indexend = requeststring.length();
		}
		String allvars = requeststring.substring(indexbegin, indexend).trim();		
		Vector<String> variables = new Vector<String>();
		String aktuell;
		while(allvars.length() >0){
			int delimiter = allvars.indexOf(" ");
			//aktuell is the first variable bevor the delimiter
			if (delimiter >0)
				aktuell = allvars.substring(0,delimiter).trim();
			else
			{
				aktuell = allvars.trim();
				delimiter = allvars.length()-1;
			}
			//cut off the questionmark
			aktuell = aktuell.substring(1);			
			//add the variable to the vector
			variables.addElement(aktuell);
			//the actuell variable is cut off as well as the comma
			allvars = allvars.substring(delimiter+1);
		}		
		return variables;				
	}
	//---------------------------------------------------------------

}