/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.AdvancedCompletionQueue;
import org.mindswap.pellet.BasicCompletionQueue;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CachedNode;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.ConceptCache;
import org.mindswap.pellet.ConceptCacheLRU;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.OptimizedBasicCompletionQueue;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.SROIQIncStrategy;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.CandidateSet;
import org.mindswap.pellet.utils.MultiListIterator;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABox {
    public static final Log log = LogFactory.getLog(ABox.class);
    public static boolean DEBUG = false;
    protected int anonCount = 0;
    public long satisfiabilityCount = 0L;
    public long consistencyCount = 0L;
    public int treeDepth = 0;
    protected DatatypeReasoner dtReasoner;
    protected Map<ATerm, Node> nodes;
    protected List<ATerm> nodeList;
    boolean changed = false;
    private boolean doExplanation;
    protected ConceptCache cache;
    private ABox pseudoModel;
    private ABox lastCompletion;
    private boolean keepLastCompletion;
    private Clash lastClash;
    private boolean isComplete = false;
    private Clash clash;
    private int branch;
    private List<Branch> branches;
    List<NodeMerge> toBeMerged;
    Map<ATermAppl, int[]> disjBranchStats;
    ABox sourceABox;
    Map<ATermAppl, ATermAppl> typeAssertions = new HashMap<ATermAppl, ATermAppl>();
    private boolean initialized = false;
    private KnowledgeBase kb;
    public boolean rulesNotApplied;
    public boolean ranRete = false;
    public boolean useRete = false;
    public Map stats;
    private CompletionQueue completionQueue;
    private Set<Individual> updatedIndividuals;
    private Set<Individual> newIndividuals;
    private Set<Edge> newEdges;
    private Set<ATermAppl> unPrunedIndividuals;
    private Set<Edge> removedEdges;
    private Map<ATermAppl, Set<ATermAppl>> removedTypes;
    private boolean syntacticUpdate = false;

    public ABox() {
        this(new KnowledgeBase());
    }

    public ABox(KnowledgeBase kb) {
        this.kb = kb;
        this.nodes = new HashMap<ATerm, Node>();
        this.nodeList = new ArrayList<ATerm>();
        this.clash = null;
        this.doExplanation = false;
        this.dtReasoner = new DatatypeReasoner();
        this.keepLastCompletion = false;
        this.clearCaches(true);
        this.branch = 0;
        this.branches = new ArrayList<Branch>();
        this.disjBranchStats = new HashMap<ATermAppl, int[]>();
        this.toBeMerged = new ArrayList<NodeMerge>();
        this.rulesNotApplied = true;
        this.completionQueue = PelletOptions.USE_ADVANCED_COMPLETION_QUEUE ? new AdvancedCompletionQueue(this) : (PelletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this));
        this.updatedIndividuals = new HashSet<Individual>();
        this.newIndividuals = new HashSet<Individual>();
        this.newEdges = new HashSet<Edge>();
        this.removedTypes = new HashMap<ATermAppl, Set<ATermAppl>>();
        this.removedEdges = new HashSet<Edge>();
        this.unPrunedIndividuals = new HashSet<ATermAppl>();
    }

    public ABox(ABox abox) {
        this(abox, null, true);
    }

    public ABox(ABox abox, ATermAppl extraIndividual, boolean copyIndividuals) {
        Object copy;
        this.kb = abox.kb;
        Timer timer = this.kb.timers.startTimer("cloneABox");
        this.rulesNotApplied = true;
        this.initialized = abox.initialized;
        this.changed = abox.changed;
        this.anonCount = abox.anonCount;
        this.cache = abox.cache;
        this.clash = abox.clash;
        this.dtReasoner = abox.dtReasoner;
        this.doExplanation = abox.doExplanation;
        this.disjBranchStats = abox.disjBranchStats;
        int extra = extraIndividual == null ? 0 : 1;
        int nodeCount = extra + (copyIndividuals ? abox.nodes.size() : 0);
        this.nodes = new HashMap<ATerm, Node>(nodeCount);
        this.nodeList = new ArrayList<ATerm>(nodeCount);
        this.completionQueue = PelletOptions.USE_ADVANCED_COMPLETION_QUEUE ? new AdvancedCompletionQueue(this) : (PelletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this));
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue = abox.completionQueue.copy();
            this.completionQueue.setABox(this);
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.updatedIndividuals = new HashSet<Individual>();
                this.newIndividuals = new HashSet<Individual>();
                this.newEdges = new HashSet<Edge>();
                this.removedTypes = new HashMap<ATermAppl, Set<ATermAppl>>();
                this.removedEdges = new HashSet<Edge>();
                this.unPrunedIndividuals = new HashSet<ATermAppl>();
            }
        }
        if (extraIndividual != null) {
            Individual n = new Individual(extraIndividual, this, Integer.MAX_VALUE);
            n.setConceptRoot(true);
            n.branch = -1;
            n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
            this.nodes.put((ATerm)extraIndividual, n);
            this.nodeList.add((ATerm)extraIndividual);
            if (PelletOptions.COPY_ON_WRITE) {
                this.sourceABox = abox;
            }
        }
        if (copyIndividuals) {
            this.toBeMerged = abox.toBeMerged;
            if (this.sourceABox == null) {
                for (int i = 0; i < nodeCount - extra; ++i) {
                    ATerm x = abox.nodeList.get(i);
                    Node node = abox.getNode(x);
                    copy = node.copyTo(this);
                    this.nodes.put(x, (Node)copy);
                    this.nodeList.add(x);
                }
                for (Node node : this.nodes.values()) {
                    node.updateNodeReferences();
                }
            }
        } else {
            this.toBeMerged = Collections.emptyList();
            this.sourceABox = null;
        }
        if (PelletOptions.USE_COMPLETION_QUEUE && PelletOptions.USE_INCREMENTAL_CONSISTENCY && copyIndividuals) {
            Node obj;
            Individual subj;
            Iterator<Object> it;
            if (abox.updatedIndividuals != null) {
                it = abox.updatedIndividuals.iterator();
                while (it.hasNext()) {
                    this.updatedIndividuals.add(this.getIndividual((ATerm)((Individual)it.next()).getName()));
                }
            }
            if (abox.newIndividuals != null) {
                it = abox.newIndividuals.iterator();
                while (it.hasNext()) {
                    this.newIndividuals.add(this.getIndividual((ATerm)((Individual)it.next()).getName()));
                }
            }
            if (abox.newEdges != null) {
                for (Edge next : abox.newEdges) {
                    subj = this.getIndividual((ATerm)next.getFrom().getName());
                    obj = this.getNode((ATerm)next.getTo().getName());
                    this.newEdges.add(new Edge(next.getRole(), subj, obj, next.getDepends()));
                }
            }
            if (abox.removedTypes != null) {
                this.removedTypes.putAll(abox.removedTypes);
            }
            if (abox.unPrunedIndividuals != null) {
                this.unPrunedIndividuals.addAll(abox.unPrunedIndividuals);
            }
            if (abox.removedEdges != null) {
                for (Edge next : abox.removedEdges) {
                    subj = this.getIndividual((ATerm)next.getFrom().getName());
                    obj = this.getNode((ATerm)next.getTo().getName());
                    this.removedEdges.add(new Edge(next.getRole(), subj, obj, next.getDepends()));
                }
            }
        }
        this.branch = abox.branch;
        this.branches = new ArrayList<Branch>(abox.branches.size());
        int n = abox.branches.size();
        for (int i = 0; i < n; ++i) {
            Branch branch = abox.branches.get(i);
            if (this.sourceABox == null) {
                copy = branch.copyTo(this);
                ((Branch)copy).nodeCount = branch.nodeCount + extra;
            } else {
                copy = branch;
            }
            this.branches.add((Branch)copy);
        }
        timer.stop();
    }

    public ABox copy() {
        return new ABox(this);
    }

    public Object clone() {
        ABox temp = new ABox(this);
        if (this.pseudoModel != null) {
            temp.pseudoModel = new ABox(this.pseudoModel);
        }
        if (this.lastCompletion != null) {
            temp.lastCompletion = new ABox(this.lastCompletion);
        }
        return temp;
    }

    public ABox copy(ATermAppl extraIndividual, boolean copyIndividuals) {
        return new ABox(this, extraIndividual, copyIndividuals);
    }

    public void copyOnWrite() {
        if (this.sourceABox == null) {
            return;
        }
        Timer t = this.kb.timers.startTimer("copyOnWrite");
        ArrayList<ATerm> currentNodeList = new ArrayList<ATerm>(this.nodeList);
        int currentSize = currentNodeList.size();
        int nodeCount = this.sourceABox.nodes.size();
        this.nodeList = new ArrayList<ATerm>(nodeCount + 1);
        this.nodeList.add((ATerm)currentNodeList.get(0));
        for (int i = 0; i < nodeCount; ++i) {
            ATerm x = this.sourceABox.nodeList.get(i);
            Node node = this.sourceABox.getNode(x);
            Node copyNode = node.copyTo(this);
            this.nodes.put(x, copyNode);
            this.nodeList.add(x);
        }
        if (currentSize > 1) {
            this.nodeList.addAll(currentNodeList.subList(1, currentSize));
        }
        for (Node node : this.nodes.values()) {
            if (!this.sourceABox.nodes.containsKey(node.getName())) continue;
            node.updateNodeReferences();
        }
        int n = this.branches.size();
        for (int i = 0; i < n; ++i) {
            Branch branch = this.branches.get(i);
            Branch copy = branch.copyTo(this);
            this.branches.set(i, copy);
            if (i >= this.sourceABox.getBranches().size()) {
                copy.nodeCount += nodeCount;
                continue;
            }
            ++copy.nodeCount;
        }
        t.stop();
        this.sourceABox = null;
    }

    public void clearCaches(boolean clearSatCache) {
        this.pseudoModel = null;
        this.lastCompletion = null;
        if (clearSatCache) {
            this.cache = new ConceptCacheLRU();
        }
    }

    public Bool getCachedSat(ATermAppl c) {
        return this.cache.getSat(c);
    }

    public ConceptCache getAllCached() {
        return this.cache;
    }

    public ConceptCache getCache() {
        return this.cache;
    }

    public CachedNode getCached(ATermAppl c) {
        return (CachedNode)this.cache.get(c);
    }

    private void cache(Individual rootNode, ATermAppl c, boolean isConsistent) {
        if (!isConsistent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(c + " is not satisfiable"));
                log.debug((Object)(ATermUtils.negate(c) + " is TOP"));
            }
            this.cache.putSat(c, false);
        } else {
            DependencySet ds = rootNode.getMergeDependency(true);
            rootNode = rootNode.getSame();
            if (this.kb.getExpressivity().hasNominal()) {
                rootNode.getABox().collectComplexPropertyValues(rootNode);
            }
            rootNode = (Individual)rootNode.copy();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache " + rootNode.debugString()));
            }
            this.cache.put(c, CachedNode.createNode(rootNode, ds));
        }
    }

    Bool mergable(Individual root1, Individual root2, boolean independent) {
        Role role;
        Individual[] roots = new Individual[]{root1, root2};
        if (roots[0] == CachedNode.BOTTOM_IND || roots[1] == CachedNode.BOTTOM_IND) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"(1) true ");
            }
            return Bool.FALSE;
        }
        if (roots[0] == CachedNode.TOP_IND && roots[1] != CachedNode.BOTTOM_IND) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"(2) false ");
            }
            return Bool.TRUE;
        }
        if (roots[1] == CachedNode.TOP_IND && roots[0] != CachedNode.BOTTOM_IND) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"(3) false ");
            }
            return Bool.TRUE;
        }
        if (roots[0] == CachedNode.DUMMY_IND || roots[1] == CachedNode.DUMMY_IND) {
            return Bool.UNKNOWN;
        }
        Bool result = Bool.TRUE;
        int root = roots[0].getTypes().size() < roots[1].getTypes().size() ? 0 : 1;
        int otherRoot = 1 - root;
        for (ATermAppl c : roots[root].getTypes()) {
            boolean allIndependent;
            ATermAppl notC = ATermUtils.negate(c);
            if (!roots[otherRoot].hasType((ATerm)notC)) continue;
            DependencySet ds1 = roots[root].getDepends((ATerm)c);
            DependencySet ds2 = roots[otherRoot].getDepends((ATerm)notC);
            boolean bl = allIndependent = independent && ds1.isIndependent() && ds2.isIndependent();
            if (allIndependent) {
                return Bool.FALSE;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(roots[root] + " has " + c + " " + roots[otherRoot] + " has negation " + ds1.max() + " " + ds2.max()));
            }
            result = Bool.UNKNOWN;
        }
        if (result.isUnknown()) {
            return result;
        }
        for (root = 0; root < 2; ++root) {
            otherRoot = 1 - root;
            for (ATermAppl av : roots[root].getTypes(3)) {
                ATerm r = av.getArgument(0);
                if (r.getType() == 4) {
                    r = ((ATermList)r).getFirst();
                }
                if (!(role = this.getRole(r)).hasComplexSubRole()) {
                    if (!roots[otherRoot].hasRNeighbor(role)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(roots[root] + " has " + av + " " + roots[otherRoot] + " has " + role + " neighbor"));
                    }
                    return Bool.UNKNOWN;
                }
                TransitionGraph tg = role.getFSM();
                for (Transition t : tg.getInitialState().getTransitions()) {
                    if (!roots[otherRoot].hasRNeighbor((Role)t.getName())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(roots[root] + " has " + av + " " + roots[otherRoot] + " has " + t.getName() + " neighbor"));
                    }
                    return Bool.UNKNOWN;
                }
            }
            for (ATermAppl mc : roots[root].getTypes(5)) {
                int n2;
                ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
                Role maxR = this.getRole(maxCard.getArgument(0));
                int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
                int n1 = roots[root].getRNeighborEdges(maxR).getFilteredNeighbors(roots[root], ATermUtils.getTop(maxR)).size();
                if (n1 + (n2 = roots[otherRoot].getRNeighborEdges(maxR).getFilteredNeighbors(roots[otherRoot], ATermUtils.getTop(maxR)).size()) <= max) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(roots[root] + " has " + mc + " " + roots[otherRoot] + " has R-neighbor"));
                }
                return Bool.UNKNOWN;
            }
        }
        if (this.kb.getExpressivity().hasFunctionality()) {
            root = roots[0].getOutEdges().size() + roots[0].getInEdges().size() < roots[1].getOutEdges().size() + roots[1].getInEdges().size() ? 0 : 1;
            otherRoot = 1 - root;
            HashSet<Role> checked = new HashSet<Role>();
            for (Edge edge : roots[root].getOutEdges()) {
                role = edge.getRole();
                if (!role.isFunctional()) continue;
                Set functionalSupers = role.getFunctionalSupers();
                for (Role supRole : functionalSupers) {
                    if (checked.contains(supRole)) continue;
                    checked.add(supRole);
                    if (!roots[otherRoot].hasRNeighbor(supRole)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(root1 + " and " + root2 + " has " + supRole));
                    }
                    return Bool.UNKNOWN;
                }
            }
            for (Edge edge : roots[root].getInEdges()) {
                role = edge.getRole().getInverse();
                if (role == null || !role.isFunctional()) continue;
                Set functionalSupers = role.getFunctionalSupers();
                for (Role supRole : functionalSupers) {
                    if (checked.contains(supRole)) continue;
                    checked.add(supRole);
                    if (!roots[otherRoot].hasRNeighbor(supRole)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(root1 + " and " + root2 + " has " + supRole));
                    }
                    return Bool.UNKNOWN;
                }
            }
        }
        if (this.kb.getExpressivity().hasNominal()) {
            boolean nom1 = root1.isNamedIndividual();
            Iterator<Object> i = root1.getTypes(6).iterator();
            while (!nom1 && i.hasNext()) {
                ATermAppl nom = i.next();
                ATermAppl name = (ATermAppl)nom.getArgument(0);
                nom1 = !ATermUtils.isAnon(name);
            }
            boolean nom2 = root2.isNamedIndividual();
            Iterator<ATermAppl> i2 = root2.getTypes(6).iterator();
            while (!nom2 && i2.hasNext()) {
                ATermAppl nom = i2.next();
                ATermAppl name = (ATermAppl)nom.getArgument(0);
                nom2 = !ATermUtils.isAnon(name);
            }
            if (nom1 && nom2) {
                return Bool.UNKNOWN;
            }
        }
        return Bool.TRUE;
    }

    public Bool isKnownSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool type;
        CachedNode cached = this.getCached(c1);
        if (cached != null && !this.doExplanation && (type = this.isType(cached.node, c2, cached.depends.isIndependent())).isKnown()) {
            return type;
        }
        return Bool.UNKNOWN;
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isKnownSubClass = this.isKnownSubClassOf(c1, c2);
        if (isKnownSubClass.isKnown()) {
            return isKnownSubClass.isTrue();
        }
        if (log.isDebugEnabled()) {
            long count = this.kb.timers.getTimer("subClassSat") == null ? 0L : this.kb.timers.getTimer("subClassSat").getCount();
            log.debug((Object)(count + ") Checking subclass [" + c1 + " " + c2 + "]"));
        }
        ATermAppl notC2 = ATermUtils.negate(c2);
        ATermAppl c = ATermUtils.makeAnd((ATerm)c1, (ATerm)notC2);
        Timer t = this.kb.timers.startTimer("subClassSat");
        boolean sub = !this.isSatisfiable(c, false);
        t.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Result: " + sub + " (" + t.getLast() + "ms)"));
        }
        return sub;
    }

    public boolean isSatisfiable(ATermAppl c) {
        boolean cacheModel = PelletOptions.USE_CACHING && (ATermUtils.isPrimitiveOrNegated(c) || PelletOptions.USE_ADVANCED_CACHING);
        return this.isSatisfiable(c, cacheModel);
    }

    public boolean isSatisfiable(ATermAppl c, boolean cacheModel) {
        CachedNode cached;
        if ((c = ATermUtils.normalize(c)).equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Satisfiability for " + c));
        }
        if (cacheModel && (cached = this.getCached(c)) != null) {
            boolean needToCacheModel;
            boolean satisfiable = !cached.isBottom();
            boolean bl = needToCacheModel = cacheModel && !cached.isComplete();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cached sat for " + c + " is " + satisfiable));
            }
            if (!(needToCacheModel || !satisfiable && this.doExplanation)) {
                return satisfiable;
            }
        }
        ++this.satisfiabilityCount;
        Timer t = this.kb.timers.startTimer("satisfiability");
        boolean isSat = this.isConsistent(SetUtils.EMPTY_SET, c, cacheModel);
        t.stop();
        if (!isSat && this.doExplanation && PelletOptions.USE_TRACING) {
            ATermAppl tempAxiom = ATermUtils.makeTypeAtom(ATermUtils.CONCEPT_SAT_IND, c);
            Set<ATermAppl> explanationSet = this.getExplanationSet();
            boolean removed = explanationSet.remove(tempAxiom);
            if (!removed) {
                log.warn((Object)("Explanation set is missing an axiom.\n\tAxiom: " + tempAxiom + "\n\tExplantionSet: " + explanationSet));
            }
        }
        return isSat;
    }

    public CandidateSet getObviousInstances(ATermAppl c) {
        return this.getObviousInstances(c, this.kb.getIndividuals());
    }

    public CandidateSet getObviousInstances(ATermAppl c, Collection individuals) {
        c = ATermUtils.normalize(c);
        Set<ATermAppl> subs = this.kb.isClassified() ? this.kb.taxonomy.getFlattenedSubs(c, false) : SetUtils.EMPTY_SET;
        subs.remove(ATermUtils.BOTTOM);
        CandidateSet cs = new CandidateSet();
        for (ATermAppl x : individuals) {
            Bool isType = this.isKnownType(x, c, subs);
            cs.add(x, isType);
        }
        return cs;
    }

    public void getObviousTypes(ATermAppl x, List<ATermAppl> types, List<ATermAppl> nonTypes) {
        Individual pNode = this.pseudoModel.getIndividual((ATerm)x);
        pNode = !pNode.getMergeDependency(true).isIndependent() ? this.getIndividual((ATerm)x) : pNode.getSame();
        pNode.getObviousTypes(types, nonTypes);
    }

    public CandidateSet getObviousSubjects(ATermAppl p, ATermAppl o) {
        CandidateSet candidates = new CandidateSet(this.kb.getIndividuals());
        this.getObviousSubjects(p, o, candidates);
        return candidates;
    }

    public void getSubjects(ATermAppl p, ATermAppl o, CandidateSet candidates) {
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = (ATermAppl)i.next();
            Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
            candidates.update(s, hasObviousValue);
        }
    }

    public void getObviousSubjects(ATermAppl p, ATermAppl o, CandidateSet candidates) {
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = (ATermAppl)i.next();
            Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
            if (hasObviousValue.isFalse()) {
                i.remove();
                continue;
            }
            candidates.update(s, hasObviousValue);
        }
    }

    public void getObviousObjects(ATermAppl p, CandidateSet candidates) {
        p = this.getRole((ATerm)p).getInverse().getName();
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = (ATermAppl)i.next();
            Bool hasObviousValue = this.hasObviousObjectPropertyValue(s, p, null);
            candidates.update(s, hasObviousValue);
        }
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c) {
        return this.isKnownType(x, c, (Collection)SetUtils.EMPTY_SET);
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c, Collection subs) {
        Individual pNode = this.pseudoModel.getIndividual((ATerm)x);
        boolean isIndependent = true;
        if (pNode.isMerged()) {
            isIndependent = pNode.getMergeDependency(true).isIndependent();
            pNode = pNode.getSame();
        }
        Bool isType = this.isKnownType(pNode, c, subs);
        if (isIndependent) {
            return isType;
        }
        if (isType.isTrue()) {
            return Bool.UNKNOWN;
        }
        return isType;
    }

    public Bool isKnownType(Individual pNode, ATermAppl concept, Collection subs) {
        Bool isType = this.isType(pNode, concept, true);
        if (isType.isUnknown()) {
            Set concepts = ATermUtils.isAnd(concept) ? ATermUtils.listToSet((ATermList)concept.getArgument(0)) : SetUtils.singleton(concept);
            for (ATermAppl c : concepts) {
                if (pNode.getABox() != null && (pNode.hasObviousType(c) || pNode.hasObviousType(subs))) {
                    isType = Bool.TRUE;
                    continue;
                }
                isType = Bool.UNKNOWN;
                Collection<ATermAppl> axioms = this.kb.getTBox().getAxioms(c);
                for (ATermAppl axiom : axioms) {
                    ATermAppl term = (ATermAppl)axiom.getArgument(1);
                    boolean equivalent = axiom.getAFun().equals(ATermUtils.EQCLASSFUN);
                    if (!equivalent) continue;
                    Iterator i = ATermUtils.isAnd(term) ? new MultiListIterator((ATermList)term.getArgument(0)) : Collections.singleton(term).iterator();
                    Bool knownType = Bool.TRUE;
                    while (i.hasNext() && knownType.isTrue()) {
                        term = (ATermAppl)i.next();
                        knownType = this.isKnownType(pNode, term, (Collection)SetUtils.EMPTY_SET);
                    }
                    if (!knownType.isTrue()) continue;
                    isType = Bool.TRUE;
                    break;
                }
                if (!isType.isUnknown()) continue;
                return Bool.UNKNOWN;
            }
        }
        return isType;
    }

    private Bool isType(Individual pNode, ATermAppl c, boolean isIndependent) {
        Timer t;
        ATermAppl notC = ATermUtils.negate(c);
        CachedNode cached = this.getCached(notC);
        if (cached != null && cached.isComplete()) {
            t = this.kb.timers.startTimer("mergable");
            Bool mergable = this.mergable(pNode, cached.node, isIndependent &= cached.depends.isIndependent());
            t.stop();
            if (mergable.isKnown()) {
                return mergable.not();
            }
        }
        if (PelletOptions.CHECK_NOMINAL_EDGES && (cached = this.getCached(c)) != null && cached.depends.isIndependent()) {
            Set<ATermAppl> neighbors;
            Role role;
            t = this.kb.timers.startTimer("checkNominalEdges");
            Individual cNode = cached.node;
            for (Edge edge : cNode.getOutEdges()) {
                role = edge.getRole();
                if (!edge.getDepends().isIndependent()) continue;
                boolean found = false;
                Node val = edge.getTo();
                if (!role.isObjectRole()) {
                    found = pNode.hasRSuccessor(role);
                } else if (!val.isRootNominal()) {
                    if (!role.hasComplexSubRole()) {
                        found = pNode.hasRNeighbor(role);
                    } else {
                        TransitionGraph tg = role.getFSM();
                        Iterator<Transition> it = tg.getInitialState().getTransitions().iterator();
                        while (!found && it.hasNext()) {
                            Transition tr = it.next();
                            found = pNode.hasRNeighbor((Role)tr.getName());
                        }
                    }
                } else {
                    neighbors = null;
                    if (role.isSimple() || pNode.isConceptRoot()) {
                        neighbors = pNode.getRNeighborNames(role);
                    } else {
                        neighbors = new HashSet<ATermAppl>();
                        this.getObjectPropertyValues(pNode.getName(), role, neighbors, neighbors, false);
                    }
                    found = neighbors.contains(val.getName());
                }
                if (found) continue;
                t.stop();
                return Bool.FALSE;
            }
            for (Edge edge : cNode.getInEdges()) {
                role = edge.getRole().getInverse();
                Individual val = edge.getFrom();
                if (!edge.getDepends().isIndependent()) continue;
                boolean found = false;
                if (!val.isRootNominal()) {
                    if (role.isSimple()) {
                        found = pNode.hasRNeighbor(role);
                    } else {
                        Iterator<Transition> it = role.getFSM().getInitialState().getTransitions().iterator();
                        while (!found && it.hasNext()) {
                            Transition tr = it.next();
                            found = pNode.hasRNeighbor((Role)tr.getName());
                        }
                    }
                } else {
                    neighbors = null;
                    if (role.isSimple() || pNode.isConceptRoot()) {
                        neighbors = pNode.getRNeighborNames(role);
                    } else {
                        neighbors = new HashSet<ATermAppl>();
                        this.getObjectPropertyValues(pNode.getName(), role, neighbors, neighbors, false);
                    }
                    found = neighbors.contains(val.getName());
                }
                if (found) continue;
                t.stop();
                return Bool.FALSE;
            }
            t.stop();
        }
        return Bool.UNKNOWN;
    }

    public boolean isSameAs(ATermAppl ind1, ATermAppl ind2) {
        ATermAppl c = ATermUtils.makeValue((ATerm)ind2);
        return this.isType(ind1, c);
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        Set<Object> subs;
        c = ATermUtils.normalize(c);
        if (this.kb.isClassified() && this.kb.taxonomy.contains(c)) {
            subs = this.kb.taxonomy.getFlattenedSubs(c, false);
            subs.remove(ATermUtils.BOTTOM);
        } else {
            subs = SetUtils.emptySet();
        }
        Bool type = this.isKnownType(x, c, subs);
        if (type.isKnown()) {
            return type.isTrue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking type " + c + " for individual " + x));
        }
        ATermAppl notC = ATermUtils.negate(c);
        Timer t = this.kb.timers.startTimer("isType");
        boolean isType = !this.isConsistent(SetUtils.singleton(x), notC, false);
        t.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Type " + isType + " " + c + " for individual " + x));
        }
        return isType;
    }

    public boolean isType(List inds, ATermAppl c) {
        ATermAppl notC;
        boolean isType;
        c = ATermUtils.normalize(c);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking type " + c + " for individuals " + inds));
        }
        boolean bl = isType = !this.isConsistent(inds, notC = ATermUtils.negate(c), false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Type " + isType + " " + c + " for individuals " + inds));
        }
        return isType;
    }

    public Bool hasObviousPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole((ATerm)p);
        if (prop.isDatatypeRole()) {
            Object value = o == null ? null : this.dtReasoner.getValue(o);
            return this.hasObviousDataPropertyValue(s, p, value);
        }
        return this.hasObviousObjectPropertyValue(s, p, o);
    }

    public Bool hasObviousDataPropertyValue(ATermAppl s, ATermAppl p, Object value) {
        Individual subj = this.pseudoModel.getIndividual((ATerm)s);
        Role prop = this.getRole((ATerm)p);
        boolean onlyPositive = false;
        if (!subj.getMergeDependency(true).isIndependent()) {
            onlyPositive = true;
            subj = this.getIndividual((ATerm)s);
        } else {
            subj = subj.getSame();
        }
        Bool hasValue = subj.hasDataPropertyValue(prop, value);
        if (onlyPositive && hasValue.isFalse()) {
            return Bool.UNKNOWN;
        }
        return hasValue;
    }

    public Bool hasObviousObjectPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole((ATerm)p);
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        this.getObjectPropertyValues(s, prop, knowns, unknowns, true);
        if (o == null) {
            if (!knowns.isEmpty()) {
                return Bool.TRUE;
            }
            if (!unknowns.isEmpty()) {
                return Bool.UNKNOWN;
            }
            return Bool.FALSE;
        }
        if (knowns.contains(o)) {
            return Bool.TRUE;
        }
        if (unknowns.contains(o)) {
            return Bool.UNKNOWN;
        }
        return Bool.FALSE;
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Timer t = this.kb.timers.startTimer("hasPropertyValue");
        Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
        if (hasObviousValue.isKnown()) {
            return hasObviousValue.isTrue();
        }
        ATermAppl c = null;
        c = o == null ? (this.kb.isDatatypeProperty((ATerm)p) ? ATermUtils.makeMin((ATerm)p, 1, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)p, 1, (ATerm)ATermUtils.TOP)) : ATermUtils.makeHasValue((ATerm)p, (ATerm)o);
        boolean isType = this.isType(s, c);
        t.stop();
        return isType;
    }

    public Set<Role> getPossibleProperties(ATermAppl s) {
        Role role;
        Edge edge;
        int i;
        Individual subj = this.pseudoModel.getIndividual((ATerm)s).getSame();
        HashSet<Role> set = new HashSet<Role>();
        EdgeList edges = subj.getOutEdges();
        for (i = 0; i < edges.size(); ++i) {
            edge = edges.edgeAt(i);
            role = edge.getRole();
            set.addAll(role.getSubRoles());
            set.addAll(role.getSuperRoles());
        }
        edges = subj.getInEdges();
        for (i = 0; i < edges.size(); ++i) {
            edge = edges.edgeAt(i);
            role = edge.getRole();
            role = role.getInverse();
            set.addAll(role.getSubRoles());
            set.addAll(role.getSuperRoles());
        }
        Iterator i2 = set.iterator();
        while (i2.hasNext()) {
            Role role2 = (Role)i2.next();
            if (!role2.isAnon()) continue;
            i2.remove();
        }
        return set;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl s, Role role, Datatype datatype) {
        return this.getDataPropertyValues(s, role, datatype, false);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl s, Role role, Datatype datatype, boolean onlyObvious) {
        Individual subj = this.pseudoModel.getIndividual((ATerm)s);
        ArrayList<ATermAppl> values = new ArrayList<ATermAppl>();
        boolean isIndependent = true;
        if (subj.isMerged()) {
            isIndependent = subj.getMergeDependency(true).isIndependent();
            subj = subj.getSame();
        }
        EdgeList edges = subj.getRSuccessorEdges(role);
        for (int i = 0; i < edges.size(); ++i) {
            ATermAppl hasValue;
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            ATermAppl literalValue = literal.getTerm();
            if (literalValue == null || datatype != null && !datatype.contains(literal.getValue())) continue;
            if (isIndependent && ds.isIndependent()) {
                values.add(literalValue);
                continue;
            }
            if (onlyObvious || !this.isType(s, hasValue = ATermUtils.makeHasValue((ATerm)role.getName(), (ATerm)literalValue))) continue;
            values.add(literalValue);
        }
        return values;
    }

    public List getObviousDataPropertyValues(ATermAppl s, Role prop, Datatype datatype) {
        return this.getDataPropertyValues(s, prop, datatype, true);
    }

    public void getObjectPropertyValues(ATermAppl s, Role role, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames) {
        Individual subj = this.pseudoModel != null ? this.pseudoModel.getIndividual((ATerm)s) : this.getIndividual((ATerm)s);
        boolean isIndependent = true;
        if (subj.isMerged()) {
            isIndependent = subj.getMergeDependency(true).isIndependent();
            subj = subj.getSame();
        }
        if (role.isSimple()) {
            this.getSimpleObjectPropertyValues(subj, role, knowns, unknowns, getSames);
        } else if (!role.hasComplexSubRole()) {
            this.getTransitivePropertyValues(subj, role, knowns, unknowns, getSames, new HashSet<ATermAppl>(), true);
        } else {
            TransitionGraph tg = role.getFSM();
            this.getComplexObjectPropertyValues(subj, tg.getInitialState(), tg, knowns, unknowns, getSames, new HashSet<Pair<Individual, State>>(), true);
        }
        if (!isIndependent) {
            unknowns.addAll(knowns);
            knowns.clear();
        }
    }

    void getSimpleObjectPropertyValues(Individual subj, Role role, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames) {
        EdgeList edges = subj.getRNeighborEdges(role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            if (!value.isRootNominal()) continue;
            if (ds.isIndependent()) {
                if (getSames) {
                    this.getSames(value, knowns, unknowns);
                    continue;
                }
                knowns.add(value.getName());
                continue;
            }
            if (getSames) {
                this.getSames(value, unknowns, unknowns);
                continue;
            }
            unknowns.add(value.getName());
        }
    }

    void getTransitivePropertyValues(Individual subj, Role prop, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames, Set<ATermAppl> visited, boolean isIndependent) {
        if (visited.contains(subj.getName())) {
            return;
        }
        visited.add(subj.getName());
        EdgeList edges = subj.getRNeighborEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Role edgeRole;
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            Role role = edgeRole = edge.getFrom().equals(subj) ? edge.getRole() : edge.getRole().getInverse();
            if (value.isRootNominal()) {
                if (isIndependent && ds.isIndependent()) {
                    if (getSames) {
                        this.getSames(value, knowns, unknowns);
                    } else {
                        knowns.add(value.getName());
                    }
                } else if (getSames) {
                    this.getSames(value, unknowns, unknowns);
                } else {
                    unknowns.add(value.getName());
                }
            }
            if (prop.isSimple()) continue;
            Set<Role> transRoles = SetUtils.intersection(edgeRole.getSuperRoles(), prop.getTransitiveSubRoles());
            for (Role transRole : transRoles) {
                this.getTransitivePropertyValues(value, transRole, knowns, unknowns, getSames, visited, isIndependent && ds.isIndependent());
            }
        }
    }

    void getComplexObjectPropertyValues(Individual subj, State st, TransitionGraph tg, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames, Set<Pair<Individual, State>> visited, boolean isIndependent) {
        Pair<Individual, State> key = new Pair<Individual, State>(subj, st);
        if (visited.contains(key)) {
            return;
        }
        visited.add(key);
        if (tg.isFinal(st) && subj.isRootNominal()) {
            log.debug((Object)("add " + subj));
            if (isIndependent) {
                if (getSames) {
                    this.getSames(subj, knowns, unknowns);
                } else {
                    knowns.add(subj.getName());
                }
            } else if (getSames) {
                this.getSames(subj, unknowns, unknowns);
            } else {
                unknowns.add(subj.getName());
            }
        }
        log.debug((Object)subj);
        for (Transition t : st.getTransitions()) {
            Role r = (Role)t.getName();
            EdgeList edges = subj.getRNeighborEdges(r);
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge = edges.edgeAt(i);
                DependencySet ds = edge.getDepends();
                Individual value = (Individual)edge.getNeighbor(subj);
                this.getComplexObjectPropertyValues(value, t.getTo(), tg, knowns, unknowns, getSames, visited, isIndependent && ds.isIndependent());
            }
        }
    }

    void collectComplexPropertyValues(Individual subj) {
        HashSet collected = new HashSet();
        Set<Role> roles = subj.getOutEdges().getRoles();
        for (Role role : roles) {
            if (role.isSimple() || collected.contains(role)) continue;
            this.collectComplexPropertyValues(subj, role);
        }
        roles = subj.getInEdges().getRoles();
        for (Role role : roles) {
            if ((role = role.getInverse()).isSimple() || collected.contains(role)) continue;
            this.collectComplexPropertyValues(subj, role);
        }
    }

    void collectComplexPropertyValues(Individual subj, Role role) {
        Individual ind;
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        this.getObjectPropertyValues(subj.getName(), role, knowns, unknowns, false);
        for (ATermAppl val : knowns) {
            ind = this.getIndividual((ATerm)val);
            subj.addEdge(role, ind, DependencySet.INDEPENDENT);
        }
        for (ATermAppl val : unknowns) {
            ind = this.getIndividual((ATerm)val);
            subj.addEdge(role, ind, DependencySet.EMPTY);
        }
    }

    public void getSames(Individual ind, Set<ATermAppl> knowns, Set<ATermAppl> unknowns) {
        knowns.add(ind.getName());
        boolean thisMerged = ind.isMerged() && !ind.getMergeDependency(true).isIndependent();
        for (Individual individual : ind.getMerged()) {
            boolean otherMerged;
            if (!individual.isRootNominal()) continue;
            boolean bl = otherMerged = individual.isMerged() && !individual.getMergeDependency(true).isIndependent();
            if (thisMerged || otherMerged) {
                unknowns.add(individual.getName());
                this.getSames(individual, unknowns, unknowns);
                continue;
            }
            knowns.add(individual.getName());
            this.getSames(individual, knowns, unknowns);
        }
    }

    public boolean isConsistent() {
        boolean isConsistent = false;
        if (this.kb.canUseIncConsistency()) {
            isConsistent = this.isIncConsistent();
        } else {
            Object c = this.isEmpty() ? ATermUtils.TOP : null;
            isConsistent = this.isConsistent(SetUtils.EMPTY_SET, (ATermAppl)c, false);
            if (isConsistent) {
                this.cache.putSat(ATermUtils.BOTTOM, false);
            }
        }
        return isConsistent;
    }

    private boolean isConsistent(Collection individuals, ATermAppl c, boolean cacheModel) {
        boolean consistent;
        ABox abox;
        Timer t = this.kb.timers.startTimer("isConsistent");
        if (log.isInfoEnabled()) {
            if (c == null) {
                log.info((Object)("ABox consistency for " + individuals.size() + " individuals"));
            } else {
                log.info((Object)("Consistency " + c + " for " + individuals.size() + " individuals " + individuals));
            }
        }
        Expressivity expr = this.kb.getExpressivity().compute(c);
        boolean buildPseudoModel = c == null;
        boolean preUID = PelletOptions.USE_INCREMENTAL_DELETION;
        boolean preUT = PelletOptions.USE_TRACING;
        if (!buildPseudoModel && PelletOptions.USE_INCREMENTAL_DELETION) {
            PelletOptions.USE_INCREMENTAL_DELETION = false;
        }
        boolean conceptSatisfiability = !buildPseudoModel && individuals.isEmpty();
        boolean hasNominal = expr.hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
        boolean canUseEmptyModel = conceptSatisfiability && !hasNominal;
        boolean canUsePseudoModel = !buildPseudoModel && this.pseudoModel != null && PelletOptions.USE_PSEUDO_MODEL && this.kb.chooseStrategy(this).supportsPseudoModelCompletion();
        ATermAppl x = null;
        if (conceptSatisfiability) {
            x = ATermUtils.CONCEPT_SAT_IND;
            individuals = SetUtils.singleton(x);
        }
        ABox aBox = canUseEmptyModel ? this.copy(x, false) : (abox = canUsePseudoModel ? this.pseudoModel.copy(x, true) : this.copy(x, true));
        if (abox.getClash() != null && buildPseudoModel && this.getKB().aboxDeletion && abox.getClash().depends.isIndependent()) {
            abox.setClash(null);
        }
        for (ATermAppl ind : individuals) {
            abox.setSyntacticUpdate(true);
            abox.addType(ind, c);
            abox.setSyntacticUpdate(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consistency check starts");
        }
        ABox completion = null;
        if (abox.isEmpty()) {
            completion = abox;
        } else {
            CompletionStrategy strategy = this.kb.chooseStrategy(abox, expr);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Strategy: " + strategy.getClass().getName()));
            }
            completion = strategy.complete();
        }
        boolean bl = consistent = !completion.isClosed();
        if (buildPseudoModel) {
            this.pseudoModel = completion;
        }
        if (x != null && c != null && cacheModel) {
            this.cache(completion.getIndividual((ATerm)x), c, consistent);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Consistent: " + consistent + " Tree depth: " + completion.treeDepth + " Tree size: " + completion.getNodes().size() + " Time: " + t.getElapsed()));
        }
        if (!consistent) {
            this.lastClash = completion.getClash();
            if (log.isDebugEnabled()) {
                log.debug((Object)completion.getClash().detailedString());
            }
        }
        ++this.consistencyCount;
        this.lastCompletion = this.keepLastCompletion ? completion : null;
        PelletOptions.USE_INCREMENTAL_DELETION = preUID;
        PelletOptions.USE_TRACING = preUT;
        t.stop();
        return consistent;
    }

    private boolean isIncConsistent() {
        Timer incT = this.kb.timers.startTimer("isIncConsistent");
        Timer t = this.kb.timers.startTimer("isConsistent");
        this.lastCompletion = null;
        ABox abox = this.pseudoModel;
        if (this.kb.aboxDeletion) {
            this.kb.restoreDependencies();
        }
        this.kb.status = 0;
        abox.setInitialized(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consistency check starts");
        }
        if (abox.isEmpty()) {
            this.lastCompletion = abox;
        } else {
            Timer timer = this.kb.timers.startTimer("loadStrat");
            SROIQIncStrategy incStrategy = new SROIQIncStrategy(abox);
            timer.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Strategy: " + incStrategy.getClass().getName()));
            }
            abox.setComplete(false);
            this.lastCompletion = ((CompletionStrategy)incStrategy).complete();
        }
        boolean consistent = !this.lastCompletion.isClosed();
        this.pseudoModel = this.lastCompletion;
        if (log.isInfoEnabled()) {
            log.info((Object)("Consistent: " + consistent + " Tree depth: " + this.lastCompletion.treeDepth + " Tree size: " + this.lastCompletion.getNodes().size()));
        }
        if (!consistent) {
            this.lastClash = this.lastCompletion.getClash();
            if (log.isDebugEnabled()) {
                log.debug((Object)this.lastCompletion.getClash().detailedString());
            }
        }
        ++this.consistencyCount;
        if (!this.keepLastCompletion) {
            this.lastCompletion = null;
        }
        t.stop();
        incT.stop();
        return consistent;
    }

    public EdgeList getInEdges(ATerm x) {
        return this.getNode(x).getInEdges();
    }

    public EdgeList getOutEdges(ATerm x) {
        Node node = this.getNode(x);
        if (node instanceof Literal) {
            return new EdgeList();
        }
        return ((Individual)node).getOutEdges();
    }

    public Individual getIndividual(ATerm x) {
        return (Individual)this.nodes.get(x);
    }

    public Literal getLiteral(ATerm x) {
        return (Literal)this.nodes.get(x);
    }

    public Node getNode(ATerm x) {
        return this.nodes.get(x);
    }

    public void addType(ATermAppl x, ATermAppl c) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(Collections.singleton(ATermUtils.makeTypeAtom(x, c))) : DependencySet.INDEPENDENT;
        this.addType(x, c, ds);
    }

    public void addType(ATermAppl x, ATermAppl c, DependencySet ds) {
        c = ATermUtils.normalize(c);
        int remember = this.branch;
        this.branch = -1;
        Node node = this.getNode((ATerm)x);
        if (node.isMerged()) {
            ds = node.getMergeDependency(true);
            node = node.getSame();
            if (!ds.isIndependent()) {
                this.typeAssertions.put(x, c);
            }
        }
        node.addType(c, ds);
        this.branch = remember;
    }

    public void removeType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        Node node = this.getNode((ATerm)x);
        node.removeType(c);
    }

    public Literal addLiteral() {
        return this.createLiteral(ATermUtils.makeLiteral(this.createUniqueName(false)));
    }

    public Literal addLiteral(ATermAppl dataValue) {
        return this.addLiteral(dataValue, DependencySet.INDEPENDENT);
    }

    public Literal addLiteral(ATermAppl dataValue, DependencySet ds) {
        if (dataValue == null || !ATermUtils.isLiteral(dataValue)) {
            throw new InternalReasonerException("Invalid value to create a literal. Value: " + dataValue);
        }
        return this.createLiteral(dataValue, ds);
    }

    private Literal createLiteral(ATermAppl dataValue) {
        return this.createLiteral(dataValue, DependencySet.INDEPENDENT);
    }

    private Literal createLiteral(ATermAppl dataValue, DependencySet ds) {
        ATermAppl name = this.kb.getDatatypeReasoner().getCanonicalRepresentation(dataValue);
        Node node = this.getNode((ATerm)name);
        if (node != null) {
            if (node instanceof Literal) {
                if (((Literal)node).getValue() == null && PelletOptions.USE_COMPLETION_QUEUE) {
                    QueueElement newElement = new QueueElement(node.getName(), null);
                    this.completionQueue.add(newElement, CompletionQueue.LITERALLIST);
                }
                if (this.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
                    this.completionQueue.addEffected(this.getBranch(), node.getName());
                }
                return (Literal)node;
            }
            throw new InternalReasonerException("Same term refers to both a literal and an individual: " + name);
        }
        Literal lit = new Literal(name, dataValue, this, ds);
        lit.addType(ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal"), DependencySet.INDEPENDENT);
        this.nodes.put((ATerm)name, lit);
        this.nodeList.add((ATerm)name);
        if (lit.getValue() == null && PelletOptions.USE_COMPLETION_QUEUE) {
            QueueElement newElement = new QueueElement(lit.getName(), null);
            this.completionQueue.add(newElement, CompletionQueue.LITERALLIST);
        }
        if (this.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue.addEffected(this.getBranch(), lit.getName());
        }
        return lit;
    }

    public Individual addIndividual(ATermAppl x) {
        Individual ind = this.addIndividual(x, 0);
        if (!PelletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl valueX = ATermUtils.makeValue((ATerm)x);
            ind.addType(valueX, DependencySet.INDEPENDENT);
        }
        if (this.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue.addEffected(this.getBranch(), ind.getName());
        }
        return ind;
    }

    Individual addFreshIndividual(boolean isNominal) {
        ATermAppl name = this.createUniqueName(isNominal);
        Individual ind = this.addIndividual(name, Integer.MAX_VALUE);
        if (isNominal) {
            ind.setNominalLevel(1);
        }
        return ind;
    }

    public void removeIndividual(ATermAppl c) {
        if (this.nodes.containsKey(c)) {
            this.nodes.remove(c);
            this.nodeList.remove(c);
        }
    }

    private Individual addIndividual(ATermAppl x, int nominalLevel) {
        if (this.nodes.containsKey(x)) {
            throw new InternalReasonerException("adding a node twice " + x);
        }
        this.changed = true;
        if (this.kb.canUseIncConsistency() && this.getPseudoModel() != null) {
            this.getPseudoModel().changed = true;
        }
        Individual n = new Individual(x, this, nominalLevel);
        n.branch = this.branch;
        this.nodes.put((ATerm)x, n);
        this.nodeList.add((ATerm)x);
        n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
        if (this.getBranch() > 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue.addEffected(this.getBranch(), n.getName());
        }
        return n;
    }

    public void addSame(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual((ATerm)x);
        Individual ind2 = this.getIndividual((ATerm)y);
        ATermAppl sameAxiom = ATermUtils.makeSameAs((ATerm)x, (ATerm)y);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getSyntacticAssertions().add(sameAxiom);
        }
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(sameAxiom) : DependencySet.INDEPENDENT;
        this.toBeMerged.add(new NodeMerge(ind1, ind2, ds));
    }

    public void addDifferent(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual((ATerm)x);
        Individual ind2 = this.getIndividual((ATerm)y);
        ATermAppl diffAxiom = ATermUtils.makeDifferent((ATerm)x, (ATerm)y);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getSyntacticAssertions().add(diffAxiom);
        }
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(diffAxiom) : DependencySet.INDEPENDENT;
        ind1.setDifferent(ind2, ds);
    }

    public void addAllDifferent(ATermList list) {
        ATermAppl allDifferent = ATermUtils.makeAllDifferent(list);
        ATermList outer = list;
        while (!outer.isEmpty()) {
            ATermList inner = outer.getNext();
            while (!inner.isEmpty()) {
                Individual ind1 = this.getIndividual(outer.getFirst());
                Individual ind2 = this.getIndividual(inner.getFirst());
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    this.kb.getSyntacticAssertions().add(allDifferent);
                }
                DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(allDifferent) : DependencySet.INDEPENDENT;
                ind1.setDifferent(ind2, ds);
                inner = inner.getNext();
            }
            outer = outer.getNext();
        }
    }

    public boolean isNode(ATerm x) {
        return this.getNode(x) != null;
    }

    private final ATermAppl createUniqueName(boolean isNominal) {
        String str = "anon" + ++this.anonCount;
        ATermAppl name = isNominal ? ATermUtils.makeAnonNominal(str) : ATermUtils.makeTermAppl(str);
        return name;
    }

    public final Collection<Node> getNodes() {
        return this.nodes.values();
    }

    final Map getNodeMap() {
        return this.nodes;
    }

    public final List getNodeNames() {
        return this.nodeList;
    }

    public String toString() {
        return "[size: " + this.nodes.size() + " freeMemory: " + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + "mb]";
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.dtReasoner;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public boolean isClosed() {
        return !PelletOptions.SATURATE_TABLEAU && this.clash != null;
    }

    public Clash getClash() {
        return this.clash;
    }

    public void setClash(Clash clash) {
        if (clash != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CLSH: " + clash));
                if (clash.depends.max() > this.branch && this.branch != -1) {
                    log.error((Object)("Invalid clash dependency " + clash + " > " + this.branch));
                }
            }
            if (this.clash != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clash was already set \nExisting: " + this.clash + "\nNew     : " + clash));
                }
                if (this.clash.depends.max() < clash.depends.max()) {
                    return;
                }
            }
        }
        this.clash = clash;
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getDependencyIndex().setClashDependencies(this.clash);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Role getRole(ATerm r) {
        return this.kb.getRole(r);
    }

    public RBox getRBox() {
        return this.kb.getRBox();
    }

    public TBox getTBox() {
        return this.kb.getTBox();
    }

    int getBranch() {
        return this.branch;
    }

    void setBranch(int branch) {
        this.branch = branch;
    }

    void incrementBranch() {
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue.incrementBranch(this.branch);
        }
        ++this.branch;
    }

    public boolean isInitialized() {
        return this.initialized && !this.kb.isChanged();
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public final boolean doExplanation() {
        return this.doExplanation || log.isDebugEnabled();
    }

    public void setDoExplanation(boolean doExplanation) {
        this.doExplanation = doExplanation;
    }

    public String getExplanation() {
        if (this.lastClash == null) {
            return "No inconsistency was found! There is no explanation generated.";
        }
        return this.lastClash.detailedString();
    }

    public Set<ATermAppl> getExplanationSet() {
        if (this.lastClash == null) {
            throw new RuntimeException("No explanation was generated!");
        }
        return this.lastClash.depends.explain;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public IndividualIterator getIndIterator() {
        return new IndividualIterator(this);
    }

    public void validate() {
        if (!PelletOptions.VALIDATE_ABOX) {
            return;
        }
        System.out.print("VALIDATING...");
        IndividualIterator n = this.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            if (node.isPruned()) continue;
            this.validate(node);
        }
    }

    void validate(Individual node) {
        int e;
        List[] negatedTypes = new List[]{node.getTypes(0), node.getTypes(2), node.getTypes(1), node.getTypes(5)};
        for (int j = 0; j < negatedTypes.length; ++j) {
            int n = negatedTypes[j].size();
            for (int i = 0; i < n; ++i) {
                ATermAppl notA;
                ATermAppl a = (ATermAppl)negatedTypes[j].get(i);
                if (a.getArity() == 0 || !node.hasType((ATerm)(notA = (ATermAppl)a.getArgument(0)))) continue;
                if (!node.hasType((ATerm)a)) {
                    throw new InternalReasonerException("Invalid type found: " + node + " " + j + " " + a + " " + node.debugString() + " " + node.depends);
                }
                throw new InternalReasonerException("Clash found: " + node + " " + a + " " + node.debugString() + " " + node.depends);
            }
        }
        if (!node.isRoot()) {
            if (node.getPredecessors().size() != 1) {
                throw new InternalReasonerException("Invalid blockable node: " + node + " " + node.getInEdges());
            }
        } else if (node.isNominal()) {
            ATermAppl nominal = ATermUtils.makeValue((ATerm)node.getName());
            if (!ATermUtils.isAnonNominal(node.getName()) && !node.hasType((ATerm)nominal)) {
                throw new InternalReasonerException("Invalid nominal node: " + node + " " + node.getTypes());
            }
        }
        for (ATermAppl c : node.getDepends().keySet()) {
            DependencySet ds = node.getDepends((ATerm)c);
            if (ds.max() <= this.branch && (PelletOptions.USE_SMART_RESTORE || ds.branch <= this.branch)) continue;
            throw new InternalReasonerException("Invalid ds found: " + node + " " + c + " " + ds + " " + this.branch);
        }
        for (Node ind : node.getDifferents()) {
            DependencySet ds = node.getDifferenceDependency(ind);
            if (ds.max() > this.branch || ds.branch > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + node + " != " + ind + " " + ds);
            }
            if (ind.getDifferenceDependency(node) != null) continue;
            throw new InternalReasonerException("Invalid difference: " + node + " != " + ind + " " + ds);
        }
        EdgeList edges = node.getOutEdges();
        for (e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            Node succ = edge.getTo();
            if (this.nodes.get(succ.getName()) != succ) {
                throw new InternalReasonerException("Invalid edge to a non-existing node: " + edge + " " + this.nodes.get(succ.getName()) + "(" + this.nodes.get(succ.getName()).hashCode() + ")" + succ + "(" + succ.hashCode() + ")");
            }
            if (!succ.getInEdges().hasEdge(edge)) {
                throw new InternalReasonerException("Invalid edge: " + edge);
            }
            if (succ.isMerged()) {
                throw new InternalReasonerException("Invalid edge to a removed node: " + edge + " " + succ.isMerged());
            }
            DependencySet ds = edge.getDepends();
            if (ds.max() > this.branch || ds.branch > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + edge + " " + ds);
            }
            EdgeList allEdges = node.getEdgesTo(succ);
            if (allEdges.getRoles().size() == allEdges.size()) continue;
            throw new InternalReasonerException("Duplicate edges: " + allEdges);
        }
        edges = node.getInEdges();
        for (e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            DependencySet ds = edge.getDepends();
            if (ds.max() <= this.branch && ds.branch <= this.branch) continue;
            throw new InternalReasonerException("Invalid ds: " + edge + " " + ds);
        }
    }

    public void printTree() {
        if (!PelletOptions.PRINT_ABOX) {
            return;
        }
        System.err.println("PRINTING...");
        for (Node node : this.nodes.values()) {
            if (!node.isRoot() || node instanceof Literal) continue;
            this.printNode((Individual)node, new HashSet<Individual>(), "   ");
        }
    }

    private void printNode(Individual node, Set<Individual> printed, String indent) {
        boolean printOnlyName;
        boolean bl = printOnlyName = node.isNominal() && !printed.isEmpty();
        if (printed.contains(node)) {
            System.err.println(" " + node.getNameStr());
            return;
        }
        printed.add(node);
        if (node.isMerged()) {
            System.err.println(node.getNameStr() + " -> " + node.getSame().getNameStr() + " " + node.getMergeDependency(true));
            return;
        }
        if (node.isPruned()) {
            throw new InternalReasonerException("Pruned node: " + node);
        }
        System.err.println(node.debugString() + " " + node.getDifferents());
        if (printOnlyName) {
            return;
        }
        indent = indent + "  ";
        for (Node succ : node.getSuccessors()) {
            EdgeList edges = node.getEdgesTo(succ);
            System.err.print(indent + "[");
            for (int e = 0; e < edges.size(); ++e) {
                if (e > 0) {
                    System.err.print(", ");
                }
                System.err.print(edges.edgeAt(e).getRole());
            }
            System.err.print("] ");
            if (succ instanceof Individual) {
                this.printNode((Individual)succ, printed, indent);
                continue;
            }
            System.err.println(" (Literal) " + succ.getName() + " " + succ.getTypes());
        }
    }

    public Clash getLastClash() {
        return this.lastClash;
    }

    public ABox getLastCompletion() {
        return this.lastCompletion;
    }

    public boolean isKeepLastCompletion() {
        return this.keepLastCompletion;
    }

    public void setKeepLastCompletion(boolean keepLastCompletion) {
        this.keepLastCompletion = keepLastCompletion;
    }

    public ABox getPseudoModel() {
        return this.pseudoModel;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void setLastCompletion(ABox comp) {
        this.lastCompletion = comp;
    }

    protected void setSyntacticUpdate(boolean val) {
        this.syntacticUpdate = val;
    }

    protected boolean isSyntacticUpdate() {
        return this.syntacticUpdate;
    }

    public CompletionQueue getCompletionQueue() {
        return this.completionQueue;
    }

    public Set<Edge> getNewEdges() {
        return this.newEdges;
    }

    public Set<Individual> getNewIndividuals() {
        return this.newIndividuals;
    }

    public Set<ATermAppl> getUnPrunedIndividuals() {
        return this.unPrunedIndividuals;
    }

    public Set<Individual> getUpdatedIndividuals() {
        return this.updatedIndividuals;
    }

    public Set<Edge> getRemovedEdges() {
        return this.removedEdges;
    }

    public Map<ATermAppl, Set<ATermAppl>> getRemovedTypes() {
        return this.removedTypes;
    }
}

