/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

class GuessBranch
extends Branch {
    List mergePairs;
    Role r;
    int minGuess;

    GuessBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int minGuess, int maxGuess, DependencySet ds) {
        super(abox, strategy, x, ds, maxGuess - minGuess + 1);
        this.r = r;
        this.minGuess = minGuess;
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual((ATerm)this.ind.getName());
        GuessBranch b = new GuessBranch(abox, null, x, this.r, this.minGuess, this.minGuess + this.tryCount - 1, this.termDepends);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        b.nodeName = this.ind.getName();
        b.strategy = this.strategy;
        b.tryNext = this.tryNext;
        return b;
    }

    protected void tryBranch() {
        this.abox.incrementBranch();
        DependencySet ds = this.termDepends;
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            int n = this.minGuess + this.tryCount - this.tryNext - 1;
            if (log.isDebugEnabled()) {
                log.debug((Object)("GUES: (" + (this.tryNext + 1) + "/" + this.tryCount + ") at branch (" + this.branch + ") to  " + this.ind + " -> " + this.r + " -> anon" + (n == 1 ? "" : this.abox.anonCount + 1 + " - anon") + (this.abox.anonCount + n) + " " + ds));
            }
            ds = ds.union(new DependencySet(this.branch), this.abox.doExplanation());
            this.strategy.addType(this.ind, ATermUtils.makeNormalizedMax(this.r.getName(), n, ATermUtils.TOP), ds);
            Individual[] y = new Individual[n];
            for (int c1 = 0; c1 < n; ++c1) {
                y[c1] = this.strategy.createFreshIndividual(true);
                this.strategy.addEdge(this.ind, this.r, y[c1], ds);
                for (int c2 = 0; c2 < c1; ++c2) {
                    y[c1].setDifferent(y[c2], ds);
                }
            }
            this.strategy.addType(this.ind, ATermUtils.makeMin((ATerm)this.r.getName(), n, (ATerm)ATermUtils.TOP), ds);
            boolean earlyClash = this.abox.isClosed();
            if (earlyClash) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CLASH: Branch " + this.branch + " " + this.abox.getClash() + "!"));
                }
                if (!(clashDepends = this.abox.getClash().depends).contains(this.branch)) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        ds = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.branch);
        }
        this.abox.setClash(Clash.unexplained(this.ind, ds));
    }

    public String toString() {
        if (this.tryNext < this.mergePairs.size()) {
            return "Branch " + this.branch + " max rule on " + this.ind + " merged  " + this.mergePairs.get(this.tryNext);
        }
        return "Branch " + this.branch + " max rule on " + this.ind + " exhausted merge possibilities";
    }

    protected void shiftTryNext(int openIndex) {
    }
}

