/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Individual
extends Node {
    private EdgeList outEdges;
    private ArrayList<ATermAppl>[] types = new ArrayList[7];
    int[] applyNext = new int[7];
    private int nominalLevel;
    List<Node> ancestors;

    Individual(ATermAppl name) {
        this(name, null, Integer.MAX_VALUE);
    }

    Individual(ATermAppl name, ABox abox, int nominalLevel) {
        super(name, abox);
        this.nominalLevel = nominalLevel;
        for (int i = 0; i < 7; ++i) {
            this.types[i] = new ArrayList();
            this.applyNext[i] = 0;
        }
        this.outEdges = new EdgeList();
    }

    Individual(Individual ind, ABox abox) {
        super(ind, abox);
        int i;
        this.nominalLevel = ind.nominalLevel;
        for (i = 0; i < 7; ++i) {
            this.types[i] = new ArrayList<ATermAppl>(ind.types[i]);
            this.applyNext[i] = ind.applyNext[i];
        }
        if (abox == null) {
            this.mergedTo = null;
            this.outEdges = new EdgeList(ind.outEdges.size());
            for (i = 0; i < ind.outEdges.size(); ++i) {
                Edge edge = ind.outEdges.edgeAt(i);
                Individual from = this;
                Individual to = new Individual(edge.getTo().getName());
                to.nominalLevel = edge.getTo().getNominalLevel();
                Edge newEdge = new Edge(edge.getRole(), from, to, edge.getDepends());
                this.outEdges.addEdge(newEdge);
            }
        } else {
            this.outEdges = this.isPruned() ? ind.outEdges.unmodifiable() : new EdgeList(ind.outEdges.size());
        }
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return true;
    }

    @Override
    public boolean isNominal() {
        return this.nominalLevel != Integer.MAX_VALUE;
    }

    @Override
    public boolean isBlockable() {
        return this.nominalLevel == Integer.MAX_VALUE;
    }

    public void setNominalLevel(int level) {
        this.nominalLevel = level;
        if (this.nominalLevel != Integer.MAX_VALUE) {
            this.ancestors = null;
        }
    }

    @Override
    public int getNominalLevel() {
        return this.nominalLevel;
    }

    @Override
    public ATermAppl getTerm() {
        return this.name;
    }

    @Override
    public Node copyTo(ABox abox) {
        return new Individual(this, abox);
    }

    public Set<Node> getMerged() {
        if (this.merged == null) {
            return SetUtils.emptySet();
        }
        return this.merged;
    }

    public List<ATermAppl> getTypes(int type) {
        return this.types[type];
    }

    @Override
    public boolean isDifferent(Node node) {
        if (PelletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return !this.name.equals(node.name);
        }
        return this.differents.containsKey(node);
    }

    @Override
    public Set<Node> getDifferents() {
        return this.differents.keySet();
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        if (PelletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return DependencySet.INDEPENDENT;
        }
        return (DependencySet)this.differents.get(node);
    }

    public void getObviousTypes(List<ATermAppl> types, List<ATermAppl> nonTypes) {
        List<ATermAppl> atomic = this.getTypes(0);
        for (ATermAppl c : atomic) {
            if (!this.getDepends((ATerm)c).isIndependent()) continue;
            if (ATermUtils.isPrimitive(c)) {
                types.add(c);
                continue;
            }
            if (!ATermUtils.isNegatedPrimitive(c)) continue;
            nonTypes.add((ATermAppl)c.getArgument(0));
        }
    }

    public boolean canApply(int type) {
        return this.applyNext[type] < this.types[type].size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addType(ATermAppl c, DependencySet ds) {
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c);
        }
        if (this.isMerged()) {
            return;
        }
        if (this.depends.containsKey(c)) {
            return;
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        int max = ds.max();
        if (ds.branch == -1 && max != 0) {
            ds.branch = max + 1;
        }
        this.depends.put(c, ds);
        this.abox.changed = true;
        if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().addEffected(this.abox.getBranch(), this.getName());
        }
        QueueElement qElement = new QueueElement(this.getName(), c);
        ATermAppl notC = ATermUtils.negate(c);
        DependencySet clashDepends = (DependencySet)this.depends.get(notC);
        if (clashDepends != null) {
            if (this.abox.doExplanation()) {
                ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
                this.abox.setClash(Clash.atomic(this, clashDepends.union(ds, this.abox.doExplanation()), positive));
            } else {
                this.abox.setClash(Clash.atomic(this, clashDepends.union(ds, this.abox.doExplanation())));
            }
        }
        if (ATermUtils.isPrimitive(c)) {
            this.setChanged(0, true);
            this.types[0].add(c);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, CompletionQueue.ATOMLIST);
            return;
        } else if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(conj, ds);
                cs = cs.getNext();
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.setChanged(3, true);
            this.types[3].add(c);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, CompletionQueue.ALLLIST);
            return;
        } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
            if (this.checkMinClash(c, ds)) {
                return;
            }
            if (this.isRedundantMin(c)) return;
            this.types[4].add(c);
            this.setChanged(4, true);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, CompletionQueue.MINLIST);
            return;
        } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
            ATermAppl x = (ATermAppl)c.getArgument(0);
            if (ATermUtils.isAnd(x)) {
                this.setChanged(1, true);
                this.types[1].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.ORLIST);
                return;
            } else if (ATermUtils.isAllValues(x)) {
                this.setChanged(2, true);
                this.types[2].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.SOMELIST);
                return;
            } else if (ATermUtils.isMin(x)) {
                if (this.checkMaxClash(c, ds)) {
                    return;
                }
                if (this.isRedundantMax(x)) return;
                this.types[5].add(c);
                this.setChanged(5, true);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.MAXLIST);
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.CHOOSELIST);
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.GUESSLIST);
                return;
            } else if (ATermUtils.isNominal(x)) {
                this.setChanged(0, true);
                this.types[0].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.ATOMLIST);
                return;
            } else if (ATermUtils.isSelf(x)) {
                EdgeList selfEdges;
                ATermAppl p = (ATermAppl)x.getArgument(0);
                Role role = this.abox.getRole((ATerm)p);
                if (role == null || (selfEdges = this.outEdges.getEdges(role).getEdgesTo(this)).isEmpty()) return;
                this.abox.setClash(Clash.unexplained(this, selfEdges.getDepends(this.abox.doExplanation())));
                return;
            } else {
                if (x.getArity() != 0) throw new InternalReasonerException("Invalid type " + c + " for individual " + this.name);
                this.setChanged(0, true);
                this.types[0].add(c);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(qElement, CompletionQueue.ATOMLIST);
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
            this.setChanged(6, true);
            this.types[6].add(c);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(qElement, CompletionQueue.NOMLIST);
            return;
        } else if (ATermUtils.isSelf(c)) {
            this.setChanged(0, true);
            this.types[0].add(c);
            return;
        } else {
            System.err.println("Warning: Adding invalid class constructor - " + c);
            this.depends.put(ATermUtils.BOTTOM, ds);
        }
    }

    public boolean checkMinClash(ATermAppl minCard, DependencySet minDepends) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        if (minR == null) {
            return false;
        }
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        ATermAppl minC = (ATermAppl)minCard.getArgument(2);
        if (minR.isFunctional() && min > 1) {
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " on FunctionalProperty";
            }
            this.abox.setClash(new Clash((Node)this, 1, minDepends, exp));
            return true;
        }
        for (ATermAppl mc : this.types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            if (maxR == null) {
                return false;
            }
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            ATermAppl maxC = (ATermAppl)maxCard.getArgument(2);
            if (max >= min || !minC.equals(maxC) || !minR.isSubRoleOf(maxR)) continue;
            DependencySet maxDepends = this.getDepends((ATerm)mc);
            DependencySet subDepends = maxR.getExplainSub((ATerm)minR.getName());
            DependencySet ds = minDepends.union(maxDepends, this.abox.doExplanation()).union(subDepends, this.abox.doExplanation());
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " max(" + maxR + ", " + max + ")";
            }
            this.abox.setClash(new Clash((Node)this, 1, ds, exp));
            return true;
        }
        return false;
    }

    public boolean checkMaxClash(ATermAppl normalizedMax, DependencySet maxDepends) {
        ATermAppl maxCard = (ATermAppl)normalizedMax.getArgument(0);
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        if (maxR == null) {
            return false;
        }
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        ATermAppl maxC = (ATermAppl)maxCard.getArgument(2);
        for (ATermAppl minCard : this.types[4]) {
            Role minR = this.abox.getRole(minCard.getArgument(0));
            if (minR == null) {
                return false;
            }
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            ATermAppl minC = (ATermAppl)minCard.getArgument(2);
            if (max >= min || !minC.equals(maxC) || !minR.isSubRoleOf(maxR)) continue;
            DependencySet minDepends = this.getDepends((ATerm)minCard);
            DependencySet subDepends = maxR.getExplainSub((ATerm)minR.getName());
            DependencySet ds = minDepends.union(maxDepends, this.abox.doExplanation()).union(subDepends, this.abox.doExplanation());
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " max(" + maxR + ", " + max + ")";
            }
            this.abox.setClash(new Clash((Node)this, 1, ds, exp));
            return true;
        }
        return false;
    }

    public boolean isRedundantMin(ATermAppl minCard) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        if (minR == null) {
            return false;
        }
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        ATermAppl minQ = (ATermAppl)minCard.getArgument(2);
        for (ATermAppl prevMinCard : this.types[4]) {
            Role prevMinR = this.abox.getRole(prevMinCard.getArgument(0));
            if (prevMinR == null) continue;
            int prevMin = ((ATermInt)prevMinCard.getArgument(1)).getInt() - 1;
            ATermAppl prevMinQ = (ATermAppl)prevMinCard.getArgument(2);
            if (min > prevMin || !prevMinR.isSubRoleOf(minR) || !minQ.equals(prevMinQ) && !ATermUtils.isTop(minQ)) continue;
            return true;
        }
        return false;
    }

    public boolean isRedundantMax(ATermAppl maxCard) {
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        if (maxR == null) {
            return false;
        }
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        if (max == 1 && maxR != null && maxR.isFunctional()) {
            return true;
        }
        ATermAppl maxQ = (ATermAppl)maxCard.getArgument(2);
        for (ATermAppl mc : this.types[5]) {
            ATermAppl prevMaxCard = (ATermAppl)mc.getArgument(0);
            Role prevMaxR = this.abox.getRole(prevMaxCard.getArgument(0));
            if (prevMaxR == null) continue;
            int prevMax = ((ATermInt)prevMaxCard.getArgument(1)).getInt() - 1;
            ATermAppl prevMaxQ = (ATermAppl)prevMaxCard.getArgument(2);
            if (max < prevMax || !maxR.isSubRoleOf(prevMaxR) || !maxQ.equals(prevMaxQ) && !ATermUtils.isTop(prevMaxQ)) continue;
            return true;
        }
        return false;
    }

    public DependencySet hasMax1(Role r) {
        Iterator<ATermAppl> i = this.types[5].iterator();
        while (i.hasNext()) {
            ATermAppl maxCard = (ATermAppl)i.next().getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            ATermAppl maxQ = (ATermAppl)maxCard.getArgument(2);
            if (max != 1 || !r.isSubRoleOf(maxR) || !ATermUtils.isTop(maxQ)) continue;
            return this.getDepends((ATerm)maxCard);
        }
        return null;
    }

    public int getMaxCard(Role r) {
        int min = Integer.MAX_VALUE;
        for (ATermAppl mc : this.types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            if (!r.isSubRoleOf(maxR) || max >= min) continue;
            min = max;
        }
        if (r.isFunctional() && min > 1) {
            min = 1;
        }
        return min;
    }

    public int getMinCard(Role r) {
        int max = 0;
        for (ATermAppl minCard : this.types[4]) {
            Role minR = this.abox.getRole(minCard.getArgument(0));
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            if (!minR.isSubRoleOf(r) || max >= min) continue;
            max = min;
        }
        return max;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        this.setChanged(true);
        if (ATermUtils.isPrimitive(c) || ATermUtils.isSelf(c)) {
            this.types[0].remove(c);
            return;
        } else {
            if (c.getAFun().equals(ATermUtils.ANDFUN)) return;
            if (c.getAFun().equals(ATermUtils.ALLFUN)) {
                this.types[3].remove(c);
                return;
            } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
                this.types[4].remove(c);
                return;
            } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl x = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAnd(x)) {
                    this.types[1].remove(c);
                    return;
                } else if (ATermUtils.isAllValues(x)) {
                    this.types[2].remove(c);
                    return;
                } else if (ATermUtils.isMin(x)) {
                    this.types[5].remove(c);
                    return;
                } else if (ATermUtils.isNominal(x)) {
                    this.types[0].remove(c);
                    return;
                } else {
                    if (x.getArity() != 0) throw new InternalReasonerException("Invalid type " + c + " for individual " + this.name);
                    this.types[0].remove(c);
                }
                return;
            } else {
                if (!c.getAFun().equals(ATermUtils.VALUEFUN)) throw new RuntimeException("Invalid concept " + c);
                this.types[6].remove(c);
            }
        }
    }

    @Override
    public final boolean isLeaf() {
        return !this.isRoot() && this.outEdges.isEmpty();
    }

    @Override
    public final Individual getSame() {
        return (Individual)super.getSame();
    }

    public final Set<Node> getSuccessors() {
        return this.outEdges.getSuccessors();
    }

    public final Set<Node> getSortedSuccessors() {
        Set<Node> successors = this.outEdges.sort().getSuccessors();
        successors.remove(this);
        return successors;
    }

    public final Set<Node> getRSuccessors(Role r, ATermAppl c) {
        HashSet<Node> result = new HashSet<Node>();
        EdgeList edges = this.outEdges.getEdges(r);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = edges.edgeAt(i);
            Node other = edge.getNeighbor(this);
            if (!other.hasType((ATerm)c)) continue;
            result.add(other);
        }
        return result;
    }

    public final Set<Node> getRSuccessors(Role r) {
        return this.outEdges.getEdges(r).getNeighbors(this);
    }

    public final EdgeList getRSuccessorEdges(Role r) {
        return this.outEdges.getEdges(r);
    }

    public final EdgeList getRPredecessorEdges(Role r) {
        return this.inEdges.getEdges(r);
    }

    public final Set<ATermAppl> getRNeighborNames(Role r) {
        return this.getRNeighborEdges(r).getNeighborNames(this);
    }

    public final Set<Node> getRNeighbors(Role r) {
        return this.getRNeighborEdges(r).getNeighbors(this);
    }

    public EdgeList getRNeighborEdges(Role r) {
        EdgeList neighbors = this.outEdges.getEdges(r);
        if (r == null) {
            throw new NullPointerException();
        }
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addEdgeList(this.inEdges.getEdges(invR));
        }
        return neighbors;
    }

    public EdgeList getRNeighborEdges(Role r, Node node) {
        EdgeList neighbors = this.outEdges.getEdges(r, node);
        if (r == null) {
            throw new NullPointerException();
        }
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addEdgeList(this.inEdges.getEdges(invR, node));
        }
        return neighbors;
    }

    public EdgeList getEdgesTo(Node x) {
        return this.outEdges.getEdgesTo(x);
    }

    public EdgeList getEdgesTo(Node x, Role r) {
        return this.outEdges.getEdgesTo(x).getEdges(r);
    }

    DependencySet hasDistinctRNeighborsForMax(Role r, int n, ATermAppl c) {
        boolean hasNeighbors = false;
        EdgeList edges = this.getRNeighborEdges(r);
        if (edges.size() >= n) {
            ArrayList allDisjointSets = new ArrayList();
            block0: for (int i = 0; i < edges.size(); ++i) {
                Node y = edges.edgeAt(i).getNeighbor(this);
                if (!y.hasType((ATerm)c)) continue;
                boolean added = false;
                for (int j = 0; j < allDisjointSets.size(); ++j) {
                    Node z;
                    int k;
                    List disjointSet = (List)allDisjointSets.get(j);
                    for (k = 0; k < disjointSet.size() && y.isDifferent(z = (Node)disjointSet.get(k)); ++k) {
                    }
                    if (k != disjointSet.size()) continue;
                    added = true;
                    disjointSet.add(y);
                    if (disjointSet.size() < n) continue;
                    hasNeighbors = true;
                    break block0;
                }
                if (added) continue;
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
                if (n != 1) continue;
                hasNeighbors = true;
                break;
            }
        }
        if (!hasNeighbors) {
            return null;
        }
        DependencySet ds = DependencySet.EMPTY;
        for (Edge edge : edges) {
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
            Node node = edge.getNeighbor(this);
            DependencySet typeDS = node.getDepends((ATerm)c);
            if (typeDS == null) continue;
            ds = ds.union(typeDS, this.abox.doExplanation());
        }
        return ds;
    }

    boolean hasDistinctRNeighborsForMin(Role r, int n, ATermAppl c) {
        return this.hasDistinctRNeighborsForMin(r, n, c, false);
    }

    boolean hasDistinctRNeighborsForMin(Role r, int n, ATermAppl c, boolean onlyNominals) {
        EdgeList edges = this.getRNeighborEdges(r);
        if (n == 1 && !onlyNominals && c.equals(ATermUtils.TOP)) {
            return !edges.isEmpty();
        }
        if (edges.size() < n) {
            return false;
        }
        ArrayList allDisjointSets = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            Node y = edges.edgeAt(i).getNeighbor(this);
            if (!y.hasType((ATerm)c)) continue;
            if (onlyNominals) {
                if (y.isBlockable()) continue;
                if (n == 1) {
                    return true;
                }
            }
            boolean added = false;
            for (int j = 0; j < allDisjointSets.size(); ++j) {
                boolean addToThis = true;
                List disjointSet = (List)allDisjointSets.get(j);
                for (int k = 0; k < disjointSet.size(); ++k) {
                    Node z = (Node)disjointSet.get(k);
                    if (y.isDifferent(z)) continue;
                    addToThis = false;
                    break;
                }
                if (!addToThis) continue;
                added = true;
                disjointSet.add(y);
                if (disjointSet.size() < n) continue;
                return true;
            }
            if (!added) {
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
            }
            if (n != 1 || allDisjointSets.size() < 1) continue;
            return true;
        }
        return false;
    }

    public final boolean hasRNeighbor(Role r) {
        if (this.outEdges.hasEdge(r)) {
            return true;
        }
        Role invR = r.getInverse();
        return invR != null && this.inEdges.hasEdge(invR);
    }

    public boolean hasRSuccessor(Role r) {
        return this.outEdges.hasEdge(r);
    }

    @Override
    public boolean hasSuccessor(Node x) {
        return this.outEdges.hasEdgeTo(x);
    }

    final boolean hasRSuccessor(Role r, Node x) {
        return this.outEdges.hasEdge(this, r, x);
    }

    public Bool hasDataPropertyValue(Role r, Object value) {
        Bool hasValue = Bool.FALSE;
        EdgeList edges = this.outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (value != null && literalValue == null) {
                Datatype datatype = literal.getDatatype();
                if (datatype.size() != 1 || !datatype.contains(value)) continue;
                hasValue = Bool.UNKNOWN;
                continue;
            }
            if (value != null && !literalValue.equals(value)) continue;
            if (ds.isIndependent()) {
                return Bool.TRUE;
            }
            hasValue = Bool.UNKNOWN;
        }
        return hasValue;
    }

    boolean hasRNeighbor(Role r, Node x) {
        if (this.hasRSuccessor(r, x)) {
            return true;
        }
        if (x instanceof Individual) {
            return ((Individual)x).hasRSuccessor(r.getInverse(), this);
        }
        return false;
    }

    @Override
    protected void addInEdge(Edge edge) {
        this.setChanged(3, true);
        this.setChanged(5, true);
        this.inEdges.addEdge(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.setChanged(3, true);
        this.setChanged(5, true);
        this.outEdges.addEdge(edge);
    }

    public Edge addEdge(Role r, Node x, DependencySet ds) {
        if (this.abox.getBranch() > 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().addEffected(this.abox.getBranch(), this.getName());
            this.abox.getCompletionQueue().addEffected(this.abox.getBranch(), x.getName());
        }
        if (this.hasRSuccessor(r, x)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("EDGE: " + this + " -> " + r + " -> " + x + ": " + ds + " " + this.getRNeighborEdges(r).getEdgesContaining(x)));
            }
            return null;
        }
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding edge to a pruned node " + this + " " + r + " " + x);
        }
        if (this.isMerged()) {
            return null;
        }
        this.abox.changed = true;
        this.setChanged(3, true);
        this.setChanged(5, true);
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        Edge edge = new Edge(r, this, x, ds);
        this.outEdges.addEdge(edge);
        x.addInEdge(edge);
        return edge;
    }

    public final EdgeList getOutEdges() {
        return this.outEdges;
    }

    public List getAncestors() {
        if (this.ancestors == null) {
            if (this.isNominal()) {
                this.ancestors = Collections.emptyList();
            } else {
                this.ancestors = new ArrayList<Node>();
                for (Individual node = this.getParent(); node != null; node = node.getParent()) {
                    this.ancestors.add(node);
                }
            }
        }
        return this.ancestors;
    }

    @Override
    public boolean restore(int branch) {
        boolean restored = super.restore(branch);
        if (!restored) {
            return false;
        }
        for (int i = 0; i < 7; ++i) {
            this.applyNext[i] = 0;
        }
        boolean removed = false;
        Iterator<Edge> i = this.outEdges.iterator();
        while (i.hasNext()) {
            Edge e = i.next();
            Node n = e.getTo();
            DependencySet d = e.getDepends();
            if (d.branch <= branch) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RESTORE: " + this.name + " remove edge " + e + " " + d.max() + " " + branch + " " + n.branch));
            }
            i.remove();
            if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
            this.abox.getRemovedEdges().add(e);
            removed = true;
        }
        if (removed) {
            this.abox.getCompletionQueue().add(new QueueElement(this.name, null), CompletionQueue.SOMELIST);
            this.abox.getCompletionQueue().add(new QueueElement(this.name, null), CompletionQueue.MINLIST);
        }
        return true;
    }

    public final boolean removeEdge(Edge edge) {
        boolean removed = this.outEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    @Override
    public void prune(DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().addEffected(this.abox.getBranch(), this.getName());
        }
        this.pruned = ds;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            Node succ = edge.getTo();
            if (succ.equals(this)) continue;
            if (succ.isNominal()) {
                succ.removeInEdge(edge);
                continue;
            }
            succ.prune(ds);
        }
    }

    @Override
    public void unprune(int branch) {
        super.unprune(branch);
        boolean added = false;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            DependencySet d = edge.getDepends();
            if (d.branch > branch) continue;
            Node succ = edge.getTo();
            Role role = edge.getRole();
            if (succ.inEdges.hasEdge(this, role, succ)) continue;
            succ.addInEdge(edge);
            if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
            added = true;
            this.abox.getCompletionQueue().addEffected(d.branch, succ.name);
            this.abox.getCompletionQueue().addEffected(d.branch, this.name);
            if (!(succ instanceof Individual)) continue;
            Individual succInd = (Individual)succ;
            succInd.applyNext[5] = 0;
            this.abox.getCompletionQueue().add(new QueueElement(succInd.name, null), CompletionQueue.MAXLIST);
            this.abox.getCompletionQueue().add(new QueueElement(succInd.name, null), CompletionQueue.GUESSLIST);
            this.abox.getCompletionQueue().add(new QueueElement(succInd.name, null), CompletionQueue.CHOOSELIST);
        }
        if (added) {
            this.applyNext[5] = 0;
            this.abox.getCompletionQueue().add(new QueueElement(this.name, null), CompletionQueue.MAXLIST);
            this.abox.getCompletionQueue().add(new QueueElement(this.name, null), CompletionQueue.GUESSLIST);
            this.abox.getCompletionQueue().add(new QueueElement(this.name, null), CompletionQueue.CHOOSELIST);
        }
    }

    public String debugString() {
        return this.name.getName() + " = " + this.types[0] + this.types[3] + this.types[2] + this.types[1] + this.types[4] + this.types[5] + this.types[6] + "; **" + this.outEdges + "**" + "; **" + this.inEdges + "**" + " --> " + this.depends + "";
    }

    @Override
    protected void updateNodeReferences() {
        super.updateNodeReferences();
        if (this.isPruned()) {
            EdgeList oldEdges = this.outEdges;
            this.outEdges = new EdgeList(oldEdges.size());
            for (int i = 0; i < oldEdges.size(); ++i) {
                Edge edge = oldEdges.edgeAt(i);
                Node to = this.abox.getNode((ATerm)edge.getTo().getName());
                Edge newEdge = new Edge(edge.getRole(), this, to, edge.getDepends());
                this.outEdges.addEdge(newEdge);
            }
        }
    }
}

