/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.QueueElement;

public class OptimizedBasicCompletionQueue
extends CompletionQueue {
    public static final Log log = LogFactory.getLog(ABox.class);
    private boolean previouslyClosed = false;
    protected List<ATermAppl>[] queue = new ArrayList[SIZE];
    protected Set<ATermAppl>[] newQueue = new HashSet[SIZE];
    protected List<ATermAppl>[] newQueueList = new ArrayList[SIZE];
    protected int[] current = new int[SIZE];
    protected int[] end;
    protected int[] cutOff = new int[SIZE];
    protected boolean backtracked;

    protected OptimizedBasicCompletionQueue(ABox abox) {
        super(abox);
        this.end = new int[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            this.queue[i] = new ArrayList<ATermAppl>();
            this.newQueue[i] = new HashSet<ATermAppl>();
            this.newQueueList[i] = new ArrayList<ATermAppl>();
            this.current[i] = 0;
            this.cutOff[i] = 0;
            this.end[i] = 0;
        }
        this.backtracked = false;
    }

    protected void findNext(int type) {
        Node node;
        while (!(this.current[type] >= this.cutOff[type] || (node = this.abox.getNode((ATerm)this.queue[type].get(this.current[type]))) != null && ((node = node.getSame()) instanceof Literal && this.allowLiterals() || node instanceof Individual && !this.allowLiterals()) && !node.isPruned())) {
            int n = type;
            this.current[n] = this.current[n] + 1;
        }
    }

    public boolean hasNext() {
        this.findNext(this.currentType);
        return this.current[this.currentType] < this.cutOff[this.currentType];
    }

    public void restore(int branch) {
        for (int i = 0; i < SIZE; ++i) {
            this.queue[i].addAll(this.newQueueList[i]);
            this.newQueue[i].clear();
            this.newQueueList[i].clear();
            this.end[i] = this.queue[i].size();
            this.current[i] = 0;
            this.cutOff[i] = this.end[i];
        }
        this.backtracked = true;
    }

    public Individual next() {
        this.findNext(this.currentType);
        Individual ind = (Individual)this.abox.getNode((ATerm)this.queue[this.currentType].get(this.current[this.currentType]));
        ind = ind.getSame();
        int n = this.currentType;
        this.current[n] = this.current[n] + 1;
        return ind;
    }

    public Node nextLiteral() {
        this.findNext(this.currentType);
        Node node = this.abox.getNode((ATerm)this.queue[this.currentType].get(this.current[this.currentType]));
        node = node.getSame();
        int n = this.currentType;
        this.current[n] = this.current[n] + 1;
        return node;
    }

    public void add(QueueElement x, int type) {
        if (type == -1) {
            for (int i = 0; i < SIZE; ++i) {
                if (this.newQueue[i].contains(x.getNode())) continue;
                this.newQueue[i].add(x.getNode());
                this.newQueueList[i].add(x.getNode());
            }
        } else if (!this.newQueue[type].contains(x.getNode())) {
            this.newQueue[type].add(x.getNode());
            this.newQueueList[type].add(x.getNode());
        }
    }

    public void reset() {
        this.cutOff[this.currentType] = this.end[this.currentType];
        this.current[this.currentType] = 0;
    }

    public void incrementBranch(int branch) {
    }

    public OptimizedBasicCompletionQueue copy() {
        int i;
        OptimizedBasicCompletionQueue copy = new OptimizedBasicCompletionQueue(this.abox);
        for (i = 0; i < SIZE; ++i) {
            copy.queue[i] = new ArrayList<ATermAppl>(this.queue[i]);
            copy.newQueue[i] = new HashSet<ATermAppl>(this.newQueue[i]);
            copy.newQueueList[i] = new ArrayList<ATermAppl>(this.newQueueList[i]);
            copy.current[i] = this.current[i];
            copy.cutOff[i] = this.cutOff[i];
            copy.end[i] = this.end[i];
        }
        copy.backtracked = this.backtracked;
        copy.setAllowLiterals(this.allowLiterals());
        for (i = 0; i < this.branchEffects.size(); ++i) {
            HashSet cp = new HashSet();
            cp.addAll((Set)this.branchEffects.get(i));
            copy.branchEffects.add(cp);
        }
        return copy;
    }

    public void setABox(ABox ab) {
        this.abox = ab;
    }

    public void print(int type) {
        if (type > SIZE) {
            return;
        }
        System.out.println("Queue " + type + ": " + this.queue[type]);
    }

    public void print() {
        for (int i = 0; i < SIZE; ++i) {
            System.out.println("Queue " + i + ": " + this.queue[i]);
        }
    }

    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }

    protected void flushQueue() {
        for (int i = 0; i < SIZE; ++i) {
            if (!this.backtracked && !this.closed) {
                this.queue[i].clear();
            } else if (this.closed && !this.abox.isClosed()) {
                this.closed = false;
            }
            this.queue[i].addAll(this.newQueueList[i]);
            this.newQueue[i].clear();
            this.newQueueList[i].clear();
            this.end[i] = this.queue[i].size();
        }
        this.backtracked = false;
    }

    protected void flushQueue(int index) {
        if (index == ALLLIST || !this.backtracked) {
            this.queue[index].clear();
        }
        this.queue[index].addAll(this.newQueueList[index]);
        this.newQueue[index].clear();
        this.newQueueList[index].clear();
        this.end[index] = this.queue[index].size();
    }

    protected void clearQueue(int index) {
        this.queue[index].clear();
        this.newQueue[index].clear();
        this.newQueueList[index].clear();
        this.end[index] = this.queue[index].size();
    }
}

