/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleTaxonomyBuilder {
    protected static Log log = LogFactory.getLog(Taxonomy.class);
    private byte PROPOGATE_UP = 1;
    private byte NO_PROPOGATE = 0;
    private byte PROPOGATE_DOWN = (byte)-1;
    protected Collection<Role> properties;
    protected Taxonomy<ATermAppl> taxonomy;
    protected RBox rbox;
    int count = 0;

    public RoleTaxonomyBuilder(RBox rbox) {
        this.rbox = rbox;
        this.properties = rbox.getRoles();
        this.taxonomy = new Taxonomy();
    }

    public Taxonomy<ATermAppl> classify() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Properties: " + this.properties.size()));
        }
        for (Role r : this.properties) {
            if (r.isAnnotationRole() || r.isOntologyRole()) continue;
            this.classify(r);
        }
        return this.taxonomy;
    }

    private void classify(Role c) {
        TaxonomyNode<ATermAppl> sup;
        if (this.taxonomy.contains(c.getName())) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Property (" + ++this.count + ") " + c + "..."));
        }
        HashMap<TaxonomyNode<Object>, Boolean> marked = new HashMap<TaxonomyNode<ATermAppl>, Boolean>();
        this.mark(this.taxonomy.getTop(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        Collection<TaxonomyNode<ATermAppl>> superNodes = this.search(true, c, this.taxonomy.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), marked);
        marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        if (superNodes.size() == 1 && this.subsumed(sup = superNodes.iterator().next(), c, marked)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this.getName(c.getName()) + " = " + this.getName(sup.getName())));
            }
            this.taxonomy.addEquivalentNode(c.getName(), sup);
            return;
        }
        Collection<TaxonomyNode<ATermAppl>> subNodes = this.search(false, c, this.taxonomy.getBottom(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), marked);
        ArrayList<ATermAppl> supers = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : superNodes) {
            if (n == this.taxonomy.getTop()) continue;
            supers.add(n.getName());
        }
        ArrayList<ATermAppl> subs = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : subNodes) {
            if (n == this.taxonomy.getBottom()) continue;
            subs.add(n.getName());
        }
        TaxonomyNode<ATermAppl> node = this.taxonomy.addNode(Collections.singleton(c.getName()), supers, subs, c.isAnon());
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean topSearch, Role c, TaxonomyNode<ATermAppl> x, Set<TaxonomyNode<ATermAppl>> visited, List<TaxonomyNode<ATermAppl>> result, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        ArrayList<TaxonomyNode<ATermAppl>> posSucc = new ArrayList<TaxonomyNode<ATermAppl>>();
        visited.add(x);
        List<TaxonomyNode<ATermAppl>> list = topSearch ? x.getSubs() : x.getSupers();
        for (int i = 0; i < list.size(); ++i) {
            TaxonomyNode<ATermAppl> taxonomyNode = list.get(i);
            if (topSearch) {
                if (!this.subsumes(taxonomyNode, c, marked)) continue;
                posSucc.add(taxonomyNode);
                continue;
            }
            if (!this.subsumed(taxonomyNode, c, marked)) continue;
            posSucc.add(taxonomyNode);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            for (TaxonomyNode taxonomyNode : posSucc) {
                if (visited.contains(taxonomyNode)) continue;
                this.search(topSearch, c, taxonomyNode, visited, result, marked);
            }
        }
        return result;
    }

    private boolean subsumes(TaxonomyNode<ATermAppl> node, Role c, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        Boolean cached = marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumes = this.subsumes(this.rbox.getRole((ATerm)node.getName()), c);
        Boolean value = subsumes ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumes ? this.NO_PROPOGATE : this.PROPOGATE_DOWN;
        this.mark(node, marked, value, propogate);
        return subsumes;
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> node, Role c, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        Boolean cached = marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumed = this.subsumes(c, this.rbox.getRole((ATerm)node.getName()));
        Boolean value = subsumed ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumed ? this.NO_PROPOGATE : this.PROPOGATE_UP;
        this.mark(node, marked, value, propogate);
        return subsumed;
    }

    private void mark(TaxonomyNode<ATermAppl> node, Map<TaxonomyNode<ATermAppl>, Boolean> marked, Boolean value, byte propogate) {
        Boolean exists = marked.get(node);
        if (exists != null) {
            if (exists != value) {
                throw new RuntimeException("Inconsistent classification result " + node.getName() + " " + exists + " " + value);
            }
            return;
        }
        marked.put(node, value);
        if (propogate != this.NO_PROPOGATE) {
            List<TaxonomyNode<ATermAppl>> others = propogate == this.PROPOGATE_UP ? node.getSupers() : node.getSubs();
            for (TaxonomyNode<ATermAppl> next : others) {
                this.mark(next, marked, value, propogate);
            }
        }
    }

    private boolean subsumes(Role sup, Role sub) {
        boolean result = sup.isSuperRoleOf(sub);
        ATermUtils.assertTrue(sub.isSubRoleOf(sup) == result);
        return result;
    }

    private String getName(ATermAppl c) {
        return URIUtils.getLocalName(c.getName());
    }
}

