/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class RuleBranch
extends Branch {
    private ATermAppl[] disj;
    private ATermAppl disjunction;
    private ATermAppl[] inds;
    int[] order;
    DependencySet[] prevDS;

    RuleBranch(ABox abox, CompletionStrategy completion, Individual x, ATermAppl[] inds, ATermAppl disjunction, DependencySet ds, ATermAppl[] disj) {
        super(abox, completion, x, ds, disj.length);
        this.inds = inds;
        this.disjunction = disjunction;
        this.disj = disj;
        this.prevDS = new DependencySet[disj.length];
        this.order = new int[disj.length];
        for (int i = 0; i < disj.length; ++i) {
            this.order[i] = i;
        }
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual((ATerm)this.ind.getName());
        RuleBranch b = new RuleBranch(abox, null, x, this.inds, this.disjunction, this.termDepends, this.disj);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        b.nodeName = this.ind.getName();
        b.strategy = this.strategy;
        b.tryNext = this.tryNext;
        b.prevDS = new DependencySet[this.disj.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.tryNext);
        b.order = new int[this.disj.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.disj.length);
        return b;
    }

    private int preferredDisjunct() {
        if (this.disj.length != 2) {
            return -1;
        }
        if (ATermUtils.isPrimitive(this.disj[0]) && ATermUtils.isAllValues(this.disj[1]) && ATermUtils.isNot((ATermAppl)this.disj[1].getArgument(1))) {
            return 1;
        }
        if (ATermUtils.isPrimitive(this.disj[1]) && ATermUtils.isAllValues(this.disj[0]) && ATermUtils.isNot((ATermAppl)this.disj[0].getArgument(1))) {
            return 0;
        }
        return -1;
    }

    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.tryNext >= 0) {
            this.prevDS[this.tryNext] = ds;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void tryBranch() {
        this.abox.incrementBranch();
        int[] stats = null;
        if (PelletOptions.USE_DISJUNCT_SORTING) {
            stats = this.abox.disjBranchStats.get(this.disjunction);
            if (stats == null) {
                int preference = this.preferredDisjunct();
                stats = new int[this.disj.length];
                for (int i = 0; i < this.disj.length; ++i) {
                    stats[i] = i != preference ? 0 : Integer.MIN_VALUE;
                }
                this.abox.disjBranchStats.put(this.disjunction, stats);
            }
            if (this.tryNext > 0) {
                int n = this.order[this.tryNext - 1];
                stats[n] = stats[n] + 1;
            }
            if (stats != null) {
                int minIndex = this.tryNext;
                int minValue = stats[this.tryNext];
                for (int i = this.tryNext + 1; i < stats.length; ++i) {
                    boolean tryEarlier;
                    boolean bl = tryEarlier = stats[i] < minValue;
                    if (!tryEarlier) continue;
                    minIndex = i;
                    minValue = stats[i];
                }
                if (minIndex != this.tryNext) {
                    ATermAppl selDisj = this.disj[minIndex];
                    this.disj[minIndex] = this.disj[this.tryNext];
                    this.disj[this.tryNext] = selDisj;
                    ATermAppl in = this.inds[minIndex];
                    this.inds[minIndex] = this.inds[this.tryNext];
                    this.inds[this.tryNext] = in;
                    this.order[minIndex] = this.tryNext;
                    this.order[this.tryNext] = minIndex;
                }
            }
        }
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            ATermAppl d = this.disj[this.tryNext];
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.tryNext; ++m) {
                    this.strategy.addType(this.abox.getNode((ATerm)this.inds[m]).getSame(), ATermUtils.negate(this.disj[m]), this.prevDS[m]);
                }
            }
            DependencySet ds = null;
            if (this.tryNext == this.tryCount - 1 && !PelletOptions.SATURATE_TABLEAU) {
                ds = this.termDepends;
                for (int m = 0; m < this.tryNext; ++m) {
                    ds = ds.union(this.prevDS[m], this.abox.doExplanation());
                }
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    ds.explain = this.termDepends.explain;
                } else {
                    ds.remove(this.branch);
                }
            } else {
                ds = PelletOptions.USE_INCREMENTAL_DELETION ? this.termDepends.union(new DependencySet(this.branch), this.abox.doExplanation()) : new DependencySet(this.branch);
            }
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("RULE: Branch (" + this.branch + ") try (" + (this.tryNext + 1) + "/" + this.tryCount + ") " + this.inds[this.tryNext] + " " + d + " " + this.disjunction + " " + ds));
                }
                catch (Exception e) {
                    log.error((Object)d);
                }
            }
            Individual nextInd = this.abox.getIndividual((ATerm)this.inds[this.tryNext]).getSame();
            ATermAppl notD = ATermUtils.negate(d);
            DependencySet dependencySet = clashDepends = PelletOptions.SATURATE_TABLEAU ? null : nextInd.getDepends((ATerm)notD);
            if (clashDepends == null) {
                this.strategy.addType(nextInd, d, ds);
                if (this.abox.isClosed()) {
                    clashDepends = this.abox.getClash().depends;
                }
            } else {
                clashDepends = clashDepends.union(ds, this.abox.doExplanation());
            }
            if (clashDepends == null) return;
            if (log.isDebugEnabled()) {
                log.debug((Object)("CLASH: Branch " + this.branch + " " + Clash.atomic(nextInd, clashDepends, d) + "!"));
            }
            if (PelletOptions.USE_DISJUNCT_SORTING) {
                if (stats == null) {
                    stats = new int[this.disj.length];
                    for (int i = 0; i < this.disj.length; ++i) {
                        stats[i] = 0;
                    }
                    this.abox.disjBranchStats.put(this.disjunction, stats);
                }
                int n = this.order[this.tryNext];
                stats[n] = stats[n] + 1;
            }
            if (this.tryNext < this.tryCount - 1 && clashDepends.contains(this.branch)) {
                if (this.abox.isClosed()) {
                    this.strategy.restore(this);
                    this.abox.incrementBranch();
                }
            } else {
                if (this.abox.doExplanation()) {
                    ATermAppl positive = ATermUtils.isNot(notD) ? d : notD;
                    this.abox.setClash(Clash.atomic(nextInd, clashDepends.union(ds, this.abox.doExplanation()), positive));
                } else {
                    this.abox.setClash(Clash.atomic(nextInd, clashDepends.union(ds, this.abox.doExplanation())));
                }
                if (!PelletOptions.USE_INCREMENTAL_DELETION) return;
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this.abox.getClash().depends);
                return;
            }
            this.setLastClash(clashDepends.copy());
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    protected void shiftTryNext(int openIndex) {
    }
}

