/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Blocking;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DoubleBlocking;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Timer;

public class SROIQStrategy
extends CompletionStrategy {
    public SROIQStrategy(ABox abox) {
        super(abox, new DoubleBlocking());
    }

    protected SROIQStrategy(ABox abox, Blocking blocking) {
        super(abox, blocking);
    }

    boolean supportsPseudoModelCompletion() {
        return true;
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            this.completionTimer.check();
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            if (lastBranch > this.abox.getBranches().size()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but has only " + this.abox.getBranches().size() + " branches. Clash found: " + this.abox.getClash());
            }
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                Branch br = this.abox.getBranches().get(lastBranch - 1);
                if (br.tryNext == br.tryCount - 1 && this.abox.getClash().depends.size() == 2) {
                    this.abox.getKB().getDependencyIndex().addCloseBranchDependency(br, this.abox.getClash().depends);
                    return false;
                }
            }
            List<Branch> branches = this.abox.getBranches();
            if (PelletOptions.USE_TRACING && PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                List<Branch> brList = branches.subList(lastBranch, branches.size());
                Iterator<Branch> it = brList.iterator();
                while (it.hasNext()) {
                    this.abox.getKB().getDependencyIndex().removeBranchDependencies(it.next());
                }
                brList.clear();
            } else {
                branches.subList(lastBranch, branches.size()).clear();
            }
            Branch newBranch = branches.get(lastBranch - 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JUMP: Branch " + lastBranch));
            }
            if (lastBranch != newBranch.branch) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but got " + newBranch.branch);
            }
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.setLastClash(this.abox.getClash().depends);
            }
            ++newBranch.tryNext;
            if (newBranch.tryNext < newBranch.tryCount) {
                this.restore(newBranch);
                branchFound = newBranch.tryNext();
            } else {
                this.abox.getClash().depends.remove(lastBranch);
            }
            if (branchFound || !log.isDebugEnabled()) continue;
            log.debug((Object)("FAIL: Branch " + lastBranch));
        }
        return branchFound;
    }

    ABox complete() {
        this.completionTimer.start();
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.initialize();
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                Timer t;
                IndividualIterator i;
                this.completionTimer.check();
                this.abox.changed = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb"));
                    this.abox.validate();
                    this.printBlocked();
                    this.abox.printTree();
                }
                IndividualIterator individualIterator = i = PelletOptions.USE_COMPLETION_QUEUE ? this.abox.getCompletionQueue() : this.abox.getIndIterator();
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().flushQueue();
                }
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    t = this.timers.startTimer("rule-nominal");
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.getCompletionQueue().setType(CompletionQueue.NOMLIST);
                    }
                    this.applyNominalRule(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-guess");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.GUESSLIST);
                }
                this.applyGuessingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-choose");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.CHOOSELIST);
                }
                this.applyChooseRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-max");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.MAXLIST);
                }
                this.applyMaxRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    t = this.timers.startTimer("check-dt-count");
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.getCompletionQueue().setType(CompletionQueue.DATATYPELIST);
                    }
                    this.checkDatatypeCount(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                    t = this.timers.startTimer("rule-lit");
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.getCompletionQueue().setType(CompletionQueue.LITERALLIST);
                        this.abox.getCompletionQueue().setAllowLiterals(true);
                    }
                    this.applyLiteralRule();
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.getCompletionQueue().setAllowLiterals(false);
                    }
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-unfold");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.ATOMLIST);
                }
                this.applyUnfoldingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-disj");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.ORLIST);
                }
                this.applyDisjunctionRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-some");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.SOMELIST);
                }
                this.applySomeValuesRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-min");
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().setType(CompletionQueue.MINLIST);
                }
                this.applyMinRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().setClosed(this.abox.isClosed());
            }
            if (this.abox.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash()));
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                    this.abox.getCompletionQueue().setClosed(false);
                    continue;
                }
                this.abox.setComplete(true);
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().flushQueue();
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this.abox.getBranches().get(i);
                    ++unexploredBranch.tryNext;
                    if (unexploredBranch.tryNext < unexploredBranch.tryCount) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.branch + " tryNext = " + unexploredBranch.tryNext + " tryCount = " + unexploredBranch.tryCount);
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.branch);
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        this.completionTimer.stop();
        return this.abox;
    }
}

