/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.net.URI;
import java.util.Set;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class OWLAPIExample {
    public static final void main(String[] args) throws Exception {
        String file = "http://www.mindswap.org/2004/owl/mindswappers#";
        System.out.print("Reading file " + file + "...");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.loadOntology(URI.create(file));
        Reasoner reasoner = new Reasoner(manager);
        System.out.println("done.");
        reasoner.loadOntology(ontology);
        reasoner.getKB().realize();
        reasoner.getKB().printClassTree();
        OWLClass Person = manager.getOWLDataFactory().getOWLClass(URI.create("http://xmlns.com/foaf/0.1/Person"));
        OWLObjectProperty workHomepage = manager.getOWLDataFactory().getOWLObjectProperty(URI.create("http://xmlns.com/foaf/0.1/workInfoHomepage"));
        OWLDataProperty foafName = manager.getOWLDataFactory().getOWLDataProperty(URI.create("http://xmlns.com/foaf/0.1/name"));
        Set<OWLIndividual> individuals = reasoner.getIndividuals((OWLDescription)Person, false);
        for (OWLIndividual ind : individuals) {
            String name = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)foafName).getLiteral();
            OWLClass type = reasoner.getType(ind);
            OWLIndividual homepage = reasoner.getRelatedIndividual(ind, (OWLObjectPropertyExpression)workHomepage);
            System.out.println("Name: " + name);
            System.out.println("Type: " + type.getURI().getFragment());
            if (homepage == null) {
                System.out.println("Homepage: Unknown");
            } else {
                System.out.println("Homepage: " + homepage.getURI());
            }
            System.out.println();
        }
    }
}

