/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class RulesExample {
    public static void main(String[] args) {
        String ont = "http://owldl.com/ontologies/dl-safe.owl";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(ont);
        ObjectProperty sibling = model.getObjectProperty(ont + "#sibling");
        OntClass BadChild = model.getOntClass(ont + "#BadChild");
        OntClass Child = model.getOntClass(ont + "#Child");
        Individual Abel = model.getIndividual(ont + "#Abel");
        Individual Cain = model.getIndividual(ont + "#Cain");
        Individual Remus = model.getIndividual(ont + "#Remus");
        Individual Romulus = model.getIndividual(ont + "#Romulus");
        model.prepare();
        RulesExample.printPropertyValues(Cain, (Property)sibling);
        RulesExample.printPropertyValues(Abel, (Property)sibling);
        RulesExample.printPropertyValues(Remus, (Property)sibling);
        RulesExample.printPropertyValues(Romulus, (Property)sibling);
        RulesExample.printInstances(BadChild);
        RulesExample.printInstances(Child);
    }

    public static void printPropertyValues(Individual ind, Property prop) {
        System.out.print(ind.getLocalName() + " has " + prop.getLocalName() + "(s): ");
        RulesExample.printIterator((Iterator)ind.listPropertyValues(prop));
    }

    public static void printInstances(OntClass cls) {
        System.out.print(cls.getLocalName() + " instances: ");
        RulesExample.printIterator((Iterator)cls.listInstances());
    }

    public static void printIterator(Iterator i) {
        if (!i.hasNext()) {
            System.out.print("none");
        } else {
            while (i.hasNext()) {
                Resource val = (Resource)i.next();
                System.out.print(val.getLocalName());
                if (!i.hasNext()) continue;
                System.out.print(", ");
            }
        }
        System.out.println();
    }
}

