/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.rules.model.AtomDConstant;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.AtomObject;
import org.mindswap.pellet.rules.model.AtomObjectVisitor;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomVisitor;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesToReteTranslator {
    private static Log log = ABox.log;
    private ABox abox;

    public RulesToReteTranslator(ABox abox) {
        this.abox = abox;
    }

    public TermTuple translateAtom(RuleAtom atom, DependencySet ds) {
        AtomTranslator translator = new AtomTranslator(ds);
        atom.accept(translator);
        return translator.getResult();
    }

    public Pair<Term, DependencySet> translateAtomObject(AtomObject obj) {
        AtomObjectTranslator translator = new AtomObjectTranslator();
        obj.accept(translator);
        return new Pair<Term, DependencySet>(translator.getResult(), translator.getDependency());
    }

    public List<TermTuple> translateAtoms(Collection<RuleAtom> atoms, DependencySet ds) {
        ArrayList<TermTuple> result = new ArrayList<TermTuple>(atoms.size());
        for (RuleAtom atom : atoms) {
            TermTuple triple = this.translateAtom(atom, ds);
            if (triple == null) {
                return null;
            }
            result.add(triple);
        }
        return result;
    }

    public org.mindswap.pellet.rete.Rule translateRule(Rule rule) {
        org.mindswap.pellet.rete.Rule reteRule;
        DependencySet ds = DependencySet.INDEPENDENT;
        List<TermTuple> head = this.translateAtoms(rule.getHead(), ds);
        List<TermTuple> body = this.translateAtoms(rule.getBody(), ds);
        if (head == null || body == null) {
            log.info((Object)("Not translating rule " + rule + " to rete format."));
            reteRule = null;
        } else {
            reteRule = new org.mindswap.pellet.rete.Rule(body, head);
        }
        return reteRule;
    }

    public Collection<org.mindswap.pellet.rete.Rule> translateRules(Collection<Rule> rules) {
        ArrayList<org.mindswap.pellet.rete.Rule> reteRules = new ArrayList<org.mindswap.pellet.rete.Rule>(rules.size());
        for (Rule rule : rules) {
            org.mindswap.pellet.rete.Rule reteRule = this.translateRule(rule);
            if (reteRule == null) continue;
            reteRules.add(reteRule);
        }
        return reteRules;
    }

    private class AtomTranslator
    implements RuleAtomVisitor {
        private DependencySet ds = null;
        private TermTuple result = null;

        public AtomTranslator(DependencySet ds) {
            this.ds = ds;
        }

        public TermTuple getResult() {
            return this.result;
        }

        public void visit(BuiltInAtom atom) {
            log.debug((Object)("Not translating built-in " + atom + " to rete triple."));
        }

        public void visit(ClassAtom atom) {
            Pair<Term, DependencySet> arg = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument());
            DependencySet mergedDS = this.ds;
            if (arg.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, new Term[]{Compiler.TYPE, (Term)arg.first, new Constant((ATermAppl)atom.getPredicate())});
        }

        public void visit(DataRangeAtom atom) {
            log.debug((Object)("Not translating data range atom " + atom + " to rete triple."));
        }

        public void visit(DatavaluedPropertyAtom atom) {
            Pair<Term, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<Term, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, new Term[]{new Constant((ATermAppl)atom.getPredicate()), (Term)arg1.first, (Term)arg2.first});
        }

        public void visit(DifferentIndividualsAtom atom) {
            Pair<Term, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<Term, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, new Term[]{Compiler.DIFF_FROM, (Term)arg1.first, (Term)arg2.first});
        }

        public void visit(IndividualPropertyAtom atom) {
            Pair<Term, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<Term, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, new Term[]{new Constant((ATermAppl)atom.getPredicate()), (Term)arg1.first, (Term)arg2.first});
        }

        public void visit(SameIndividualAtom atom) {
            Pair<Term, DependencySet> arg1 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument1());
            Pair<Term, DependencySet> arg2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)atom.getArgument2());
            DependencySet mergedDS = this.ds;
            if (arg1.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg1.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (arg2.second != DependencySet.INDEPENDENT) {
                mergedDS = this.ds.union((DependencySet)arg2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(mergedDS, new Term[]{Compiler.SAME_AS, (Term)arg1.first, (Term)arg2.first});
        }
    }

    private class AtomObjectTranslator
    implements AtomObjectVisitor {
        private DependencySet dependency = DependencySet.INDEPENDENT;
        private Term result = null;

        private AtomObjectTranslator() {
        }

        public DependencySet getDependency() {
            return this.dependency;
        }

        public Term getResult() {
            return this.result;
        }

        public void visit(AtomDConstant constant) {
            ATermAppl canonical = RulesToReteTranslator.this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(constant.getValue());
            this.result = new Constant(canonical);
        }

        public void visit(AtomDVariable variable) {
            this.result = new Variable(variable.getName());
        }

        public void visit(AtomIConstant constant) {
            RulesToReteTranslator.this.abox.copyOnWrite();
            Individual individual = RulesToReteTranslator.this.abox.getIndividual((ATerm)constant.getValue());
            if (individual.isMerged()) {
                this.dependency = individual.getMergeDependency(true);
                individual = individual.getSame();
            }
            this.result = new Constant(individual.getName());
        }

        public void visit(AtomIVariable variable) {
            this.result = new Variable(variable.getName());
        }
    }
}

