/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.rules.BindingHelper;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.VariableUtils;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.AtomObject;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomVisitor;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrivialSatisfactionHelpers {
    private ABox abox;

    public TrivialSatisfactionHelpers(ABox abox) {
        this.abox = abox;
    }

    public Collection<BindingHelper> getHelpers(Rule rule) {
        ArrayList<BindingHelper> helpers = new ArrayList<BindingHelper>();
        BodyAtomVisitor bodyVisitor = new BodyAtomVisitor();
        for (RuleAtom atom : rule.getBody()) {
            atom.accept(bodyVisitor);
            if (bodyVisitor.getHelper() == null) continue;
            helpers.add(bodyVisitor.getHelper());
        }
        HeadAtomVisitor headVisitor = new HeadAtomVisitor();
        for (RuleAtom atom : rule.getHead()) {
            atom.accept(headVisitor);
        }
        helpers.add(headVisitor.getHelper());
        return helpers;
    }

    public boolean isAtomTrue(RuleAtom atom, VariableBinding binding) {
        HeadAtomVisitor visitor = new HeadAtomVisitor();
        atom.accept(visitor);
        BindingHelper helper = visitor.getHelper();
        helper.rebind(binding);
        return !helper.selectNextBinding();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class UnaryBindingTester<R extends AtomObject>
    implements BindingTester {
        R arg;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public UnaryBindingTester(R arg) {
            this.this$0 = var1_1;
            this.arg = arg;
        }

        public R getArg() {
            return this.arg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestNotSame
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestNotSame(AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg1, (AtomObject)arg2);
        }

        @Override
        public boolean check(VariableBinding binding) {
            return !binding.get((AtomIObject)this.arg1).isSame(binding.get((AtomIObject)this.arg2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TestNotProperty<S extends AtomObject>
    extends BinaryBindingTester<AtomIObject, S> {
        Role r;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public TestNotProperty(ATermAppl p, AtomIObject arg1, S arg2) {
            this.this$0 = var1_1;
            super((TrivialSatisfactionHelpers)var1_1, (AtomObject)arg1, arg2);
            this.r = ((TrivialSatisfactionHelpers)var1_1).abox.getRole((ATerm)p);
            if (this.r == null) {
                throw new InternalReasonerException("Cannot retreive role!: " + p);
            }
        }

        public boolean check(Individual node1, Node node2) {
            return !node1.getRNeighbors(this.r).contains(node2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestNotIndividualProperty
    extends TestNotProperty<AtomIObject> {
        public TestNotIndividualProperty(ATermAppl p, AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, p, arg1, (AtomObject)arg2);
        }

        @Override
        public boolean check(VariableBinding binding) {
            return this.check(binding.get((AtomIObject)this.getArg1()), binding.get((AtomIObject)this.getArg2()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestNotDifferent
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestNotDifferent(AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg1, (AtomObject)arg2);
        }

        @Override
        public boolean check(VariableBinding binding) {
            return !binding.get((AtomIObject)this.arg1).isDifferent(binding.get((AtomIObject)this.arg2));
        }

        public String toString() {
            return "notDifferent(" + this.getArg1() + "," + this.getArg2() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestNotDataProperty
    extends TestNotProperty<AtomDObject> {
        public TestNotDataProperty(ATermAppl p, AtomIObject arg1, AtomDObject arg2) {
            super(TrivialSatisfactionHelpers.this, p, arg1, (AtomObject)arg2);
        }

        @Override
        public boolean check(VariableBinding binding) {
            return this.check(binding.get((AtomIObject)this.getArg1()), binding.get((AtomDObject)this.getArg2()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestNotClass
    extends UnaryBindingTester<AtomIObject> {
        private ATermAppl c;

        public TestNotClass(ATermAppl c, AtomIObject arg) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg);
            this.c = c;
        }

        @Override
        public boolean check(VariableBinding binding) {
            Individual ind = binding.get((AtomIObject)this.getArg());
            return !ind.hasType((ATerm)this.c);
        }

        public String toString() {
            return "notClass(" + this.getArg() + ":" + this.c + ")";
        }
    }

    private class HeadAtomVisitor
    implements RuleAtomVisitor {
        private Collection<BindingTester> testers = new ArrayList<BindingTester>();
        private Collection<AtomVariable> vars = new HashSet<AtomVariable>();

        private HeadAtomVisitor() {
        }

        public BindingHelper getHelper() {
            return new FilterHelper(this.testers, this.vars);
        }

        public void visit(BuiltInAtom atom) {
        }

        public void visit(ClassAtom atom) {
            this.testers.add(new TestNotClass(ATermUtils.normalize((ATermAppl)atom.getPredicate()), (AtomIObject)atom.getArgument()));
            this.vars.addAll(VariableUtils.getVars(atom));
        }

        public void visit(DataRangeAtom atom) {
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.testers.add(new TestNotDataProperty((ATermAppl)atom.getPredicate(), (AtomIObject)atom.getArgument1(), (AtomDObject)atom.getArgument2()));
            this.vars.addAll(VariableUtils.getVars(atom));
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.testers.add(new TestNotDifferent((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2()));
            this.vars.addAll(VariableUtils.getVars(atom));
        }

        public void visit(IndividualPropertyAtom atom) {
            this.testers.add(new TestNotIndividualProperty((ATermAppl)atom.getPredicate(), (AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2()));
            this.vars.addAll(VariableUtils.getVars(atom));
        }

        public void visit(SameIndividualAtom atom) {
            this.testers.add(new TestNotSame((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2()));
            this.vars.addAll(VariableUtils.getVars(atom));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterHelper
    implements BindingHelper {
        private boolean result = false;
        private Collection<? extends BindingTester> testers;
        private Collection<? extends AtomVariable> vars;

        public FilterHelper(BindingTester tester, Collection<? extends AtomVariable> vars) {
            this(Collections.singleton(tester), vars);
        }

        public FilterHelper(Collection<? extends BindingTester> testers, Collection<? extends AtomVariable> vars) {
            this.testers = testers;
            this.vars = vars;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars() {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars() {
            return this.vars;
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            this.result = true;
            for (BindingTester bindingTester : this.testers) {
                if (bindingTester.check(newBinding)) continue;
                this.result = false;
                break;
            }
        }

        @Override
        public boolean selectNextBinding() {
            boolean result = this.result;
            this.result = false;
            return result;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
        }

        public String toString() {
            return "Filter(" + this.testers + ")";
        }
    }

    private class BodyAtomVisitor
    implements RuleAtomVisitor {
        private BindingHelper helper = null;

        private BodyAtomVisitor() {
        }

        public BindingHelper getHelper() {
            return this.helper;
        }

        public void visit(BuiltInAtom atom) {
            this.helper = null;
        }

        public void visit(ClassAtom atom) {
            this.helper = new FilterHelper(new TestNotClass(ATermUtils.normalize(ATermUtils.negate((ATermAppl)atom.getPredicate())), (AtomIObject)atom.getArgument()), VariableUtils.getVars(atom));
        }

        public void visit(DataRangeAtom atom) {
            this.helper = null;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.helper = null;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.helper = new FilterHelper(new TestNotSame((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2()), VariableUtils.getVars(atom));
        }

        public void visit(IndividualPropertyAtom atom) {
            this.helper = null;
        }

        public void visit(SameIndividualAtom atom) {
            this.helper = new FilterHelper(new TestNotDifferent((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2()), VariableUtils.getVars(atom));
        }
    }

    private static interface BindingTester {
        public boolean check(VariableBinding var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BinaryBindingTester<R extends AtomObject, S extends AtomObject>
    implements BindingTester {
        R arg1;
        S arg2;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public BinaryBindingTester(R arg1, S arg2) {
            this.this$0 = var1_1;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public R getArg1() {
            return this.arg1;
        }

        public S getArg2() {
            return this.arg2;
        }
    }
}

