/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.rules.model.AtomDConstant;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.AtomObjectVisitor;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.DefaultAtomObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableBinding {
    private ABox abox;
    private Map<AtomDVariable, Literal> dataVars;
    private Map<AtomIVariable, Individual> instanceVars;

    public VariableBinding(ABox abox) {
        this.abox = abox;
        this.dataVars = new HashMap<AtomDVariable, Literal>();
        this.instanceVars = new HashMap<AtomIVariable, Individual>();
    }

    public VariableBinding(VariableBinding binding) {
        this.abox = binding.abox;
        this.dataVars = new HashMap<AtomDVariable, Literal>(binding.dataVars);
        this.instanceVars = new HashMap<AtomIVariable, Individual>(binding.instanceVars);
    }

    public boolean containsKey(AtomDVariable key) {
        return this.dataVars.containsKey(key);
    }

    public boolean containsKey(AtomIVariable key) {
        return this.instanceVars.containsKey(key);
    }

    public Set<Map.Entry<? extends AtomVariable, ? extends Node>> entrySet() {
        HashSet<Map.Entry<? extends AtomVariable, ? extends Node>> entries = new HashSet<Map.Entry<? extends AtomVariable, ? extends Node>>();
        entries.addAll(this.dataVars.entrySet());
        entries.addAll(this.instanceVars.entrySet());
        return entries;
    }

    public boolean equals(Object other) {
        if (other instanceof VariableBinding) {
            VariableBinding otherBinding = (VariableBinding)other;
            if (((Object)this.dataVars).equals(otherBinding.dataVars) && ((Object)this.instanceVars).equals(otherBinding.instanceVars)) {
                return true;
            }
        }
        return false;
    }

    public Literal get(AtomDObject key) {
        DataValueCollector collector = new DataValueCollector();
        key.accept(collector);
        return collector.getValue();
    }

    public Individual get(AtomIObject key) {
        IndividualValueCollector collector = new IndividualValueCollector();
        key.accept(collector);
        return collector.getValue();
    }

    public int hashCode() {
        return ((Object)this.dataVars).hashCode() + ((Object)this.instanceVars).hashCode();
    }

    public Literal set(AtomDObject key, Literal value) {
        ValueSettingVisitor visitor = new ValueSettingVisitor(null, value);
        key.accept(visitor);
        return visitor.getData();
    }

    public Literal set(AtomDVariable key, ATermAppl value) {
        AtomDConstant constant = new AtomDConstant(value);
        DataValueCollector collector = new DataValueCollector();
        constant.accept(collector);
        return this.set((AtomDObject)key, collector.getValue());
    }

    public Individual set(AtomIObject key, Individual value) {
        ValueSettingVisitor visitor = new ValueSettingVisitor(value, null);
        key.accept(visitor);
        return visitor.getIndividual();
    }

    public Individual set(AtomIVariable key, ATermAppl value) {
        AtomIConstant constant = new AtomIConstant(value);
        IndividualValueCollector collector = new IndividualValueCollector();
        constant.accept(collector);
        return this.set((AtomIObject)key, collector.getValue());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append(this.instanceVars);
        buffer.append(", ");
        buffer.append(this.dataVars);
        buffer.append("}");
        return buffer.toString();
    }

    private class ValueSettingVisitor
    implements AtomObjectVisitor {
        Literal data;
        Individual individual;

        public ValueSettingVisitor(Individual individual, Literal data) {
            this.data = data;
            this.individual = individual;
        }

        public Literal getData() {
            return this.data;
        }

        public Individual getIndividual() {
            return this.individual;
        }

        public void visit(AtomDConstant constant) {
            this.data = null;
        }

        public void visit(AtomDVariable var) {
            if (this.data != null) {
                this.data = VariableBinding.this.dataVars.put(var, this.data);
            }
        }

        public void visit(AtomIConstant constant) {
            this.individual = null;
        }

        public void visit(AtomIVariable var) {
            if (this.individual != null) {
                this.individual = VariableBinding.this.instanceVars.put(var, this.individual);
            }
        }
    }

    private class IndividualValueCollector
    extends DefaultAtomObjectVisitor {
        Individual value = null;

        private IndividualValueCollector() {
        }

        public Individual getValue() {
            return this.value;
        }

        public void visit(AtomIConstant constant) {
            VariableBinding.this.abox.copyOnWrite();
            this.value = VariableBinding.this.abox.getIndividual((ATerm)constant.getValue());
        }

        public void visit(AtomIVariable variable) {
            this.value = (Individual)VariableBinding.this.instanceVars.get(variable);
        }
    }

    private class DataValueCollector
    extends DefaultAtomObjectVisitor {
        Literal value = null;

        private DataValueCollector() {
        }

        public Literal getValue() {
            return this.value;
        }

        public void visit(AtomDConstant constant) {
            ATermAppl canonical = VariableBinding.this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(constant.getValue());
            VariableBinding.this.abox.copyOnWrite();
            this.value = VariableBinding.this.abox.getLiteral((ATerm)canonical);
            if (this.value == null) {
                this.value = VariableBinding.this.abox.addLiteral(constant.getValue());
            }
        }

        public void visit(AtomDVariable variable) {
            this.value = (Literal)VariableBinding.this.dataVars.get(variable);
        }
    }
}

