/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tbox.impl.TermDefinition;

public class TBoxBase {
    public static Log log = LogFactory.getLog(TBoxBase.class);
    protected KnowledgeBase kb;
    protected Map<ATermAppl, TermDefinition> termhash = new HashMap<ATermAppl, TermDefinition>();

    public TBoxBase(KnowledgeBase kb) {
        this.kb = kb;
    }

    public boolean addDef(ATermAppl def) {
        ATermAppl name = (ATermAppl)def.getArgument(0);
        if (this.termhash.containsKey(name)) {
            this.getTD((ATerm)name).addDef(def);
        } else {
            TermDefinition td = new TermDefinition();
            td.addDef(def);
            this.termhash.put(name, td);
        }
        return true;
    }

    public boolean removeDef(ATermAppl axiom) {
        boolean removed = false;
        ATermAppl name = (ATermAppl)axiom.getArgument(0);
        TermDefinition td = this.getTD((ATerm)name);
        if (td != null) {
            removed = td.removeDef(axiom);
        }
        return removed;
    }

    public boolean contains(ATerm name) {
        return this.termhash.containsKey(name);
    }

    public TermDefinition getTD(ATerm name) {
        return this.termhash.get(name);
    }

    public boolean isEmpty() {
        return this.termhash.size() == 0;
    }

    public int size() {
        return this.termhash.size();
    }
}

