/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermDefinition {
    private List<ATermAppl> subClassAxioms;
    private List<ATermAppl> eqClassAxioms;
    private Set<ATermAppl> seen;
    public Set<ATermAppl> dependencies;

    public TermDefinition() {
        this.subClassAxioms = new ArrayList<ATermAppl>();
        this.eqClassAxioms = new ArrayList<ATermAppl>();
        this.seen = new HashSet<ATermAppl>();
        this.updateDependencies();
    }

    public TermDefinition(TermDefinition td) {
        this.subClassAxioms = new ArrayList<ATermAppl>(td.subClassAxioms);
        this.eqClassAxioms = new ArrayList<ATermAppl>(td.eqClassAxioms);
        this.seen = new HashSet<ATermAppl>(td.seen);
        this.updateDependencies();
    }

    public ATermAppl getName() {
        if (!this.subClassAxioms.isEmpty()) {
            return (ATermAppl)this.subClassAxioms.get(0).getArgument(0);
        }
        if (!this.eqClassAxioms.isEmpty()) {
            return (ATermAppl)this.eqClassAxioms.get(0).getArgument(0);
        }
        return null;
    }

    public boolean addDef(ATermAppl appl) {
        if (this.seen.contains(appl)) {
            return false;
        }
        this.seen.add(appl);
        boolean added = false;
        AFun fun = appl.getAFun();
        if (fun.equals(ATermUtils.SUBFUN)) {
            added = this.subClassAxioms.add(appl);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            added = this.eqClassAxioms.add(appl);
        } else {
            throw new RuntimeException("Cannot add non-definition!");
        }
        if (added) {
            this.updateDependencies();
        }
        return added;
    }

    public boolean removeDef(ATermAppl axiom) {
        boolean removed;
        this.seen.remove(axiom);
        AFun fun = axiom.getAFun();
        if (fun.equals(ATermUtils.SUBFUN)) {
            removed = this.subClassAxioms.remove(axiom);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            removed = this.eqClassAxioms.remove(axiom);
        } else {
            throw new RuntimeException("Cannot remove non-definition!");
        }
        this.updateDependencies();
        return removed;
    }

    public boolean isPrimitive() {
        return this.eqClassAxioms.isEmpty();
    }

    public boolean isUnique() {
        int numEqClasses = this.eqClassAxioms.size();
        return numEqClasses == 0 || numEqClasses == 1 && this.subClassAxioms.isEmpty();
    }

    public List<ATermAppl> getSubClassAxioms() {
        return this.subClassAxioms;
    }

    public List<ATermAppl> getEqClassAxioms() {
        return this.eqClassAxioms;
    }

    public List<ATermAppl> getSames() {
        return this.getEqClassAxioms();
    }

    public String toString() {
        return this.subClassAxioms + "; " + this.eqClassAxioms;
    }

    protected void updateDependencies() {
        this.dependencies = new HashSet<ATermAppl>();
        for (ATermAppl sub : this.getSubClassAxioms()) {
            this.dependencies.addAll(ATermUtils.findPrimitives((ATermAppl)sub.getArgument(1)));
        }
        for (ATermAppl same : this.getEqClassAxioms()) {
            this.dependencies.addAll(ATermUtils.findPrimitives((ATermAppl)same.getArgument(1)));
        }
    }

    public TermDefinition clone() {
        TermDefinition newtd = new TermDefinition();
        newtd.subClassAxioms = this.subClassAxioms;
        newtd.eqClassAxioms = this.eqClassAxioms != null ? new ArrayList<ATermAppl>(this.eqClassAxioms) : null;
        newtd.seen = this.seen != null ? new HashSet<ATermAppl>(this.seen) : null;
        newtd.updateDependencies();
        return newtd;
    }
}

