/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Interpreter;
import org.mindswap.pellet.rules.RulesToReteTranslator;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class OWLAPITests
extends PelletTestCase {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public void testOWL_1_1() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "owl1.1.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
        OWLClass owlThing = manager.getOWLDataFactory().getOWLClass(OWLRDFVocabulary.OWL_THING.getURI());
        OWLClass C = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "C"));
        OWLClass D = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D"));
        OWLClass D1 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D1"));
        OWLClass D2 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D2"));
        OWLClass D3 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D3"));
        OWLClass test1 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "test1"));
        OWLClass test2 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "test2"));
        OWLClass test3 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "test3"));
        OWLClass OlderThan10 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "OlderThan10"));
        OWLClass YoungerThan20 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "YoungerThan20"));
        OWLClass Teenager = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teenager"));
        OWLClass Teen = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teen"));
        OWLIndividual ind1 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind1"));
        OWLIndividual ind3 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind3"));
        OWLIndividual ind4 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind4"));
        OWLIndividual ind5 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind5"));
        OWLIndividual ind6 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind6"));
        OWLObjectProperty p = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "p"));
        OWLObjectProperty r = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "r"));
        OWLObjectProperty invR = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "invR"));
        OWLObjectProperty ir = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "ir"));
        OWLObjectProperty as = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "as"));
        OWLObjectProperty d1 = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "d1"));
        OWLObjectProperty d2 = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "d2"));
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
        OWLAPITests.assertTrue((boolean)reasoner.isReflexive(r));
        OWLAPITests.assertTrue((boolean)reasoner.isReflexive(invR));
        OWLAPITests.assertTrue((boolean)reasoner.isIrreflexive(ir));
        OWLAPITests.assertTrue((boolean)reasoner.isAntiSymmetric(as));
        OWLObjectUnionOf union = manager.getOWLDataFactory().getOWLObjectUnionOf(SetUtils.create(new OWLDescription[]{D1, D2, D3}));
        OWLAPITests.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)D, (OWLDescription)union));
        OWLAPITests.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)D, (OWLDescription)test1));
        OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D1, (OWLDescription)D2));
        OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D1, (OWLDescription)D3));
        OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D2, (OWLDescription)D3));
        OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith(d1, d2));
        OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith(d2, d1));
        OWLAPITests.assertFalse((boolean)reasoner.isDisjointWith(p, r));
        OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)r, ind1));
        OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)invR, ind1));
        OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(ind1, ind3));
        OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(ind1, ind4));
        OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(ind5, ind6));
        OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)p, ind1));
        OWLAPITests.assertTrue((boolean)reasoner.hasType(ind1, (OWLDescription)test2));
        OWLAPITests.assertTrue((boolean)reasoner.hasType(ind1, (OWLDescription)test3));
        OWLAPITests.assertIteratorValues(SetUtils.union(reasoner.getTypes(ind1, false)).iterator(), new Object[]{owlThing, C, test2, test3});
        OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Teenager, (OWLDescription)OlderThan10));
        OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Teenager, (OWLDescription)YoungerThan20));
        OWLAPITests.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)Teenager, (OWLDescription)Teen));
    }

    public void testUncle() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "uncle.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLIndividual Bob = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Bob"));
        OWLIndividual Sam = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Sam"));
        OWLObjectProperty uncleOf = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "uncleOf"));
        this.assertPropertyValues(reasoner, Bob, uncleOf, new OWLIndividual[]{Sam});
    }

    public void assertPropertyValues(Reasoner reasoner, OWLIndividual subj, OWLObjectProperty pred, OWLIndividual[] values) {
        OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(subj, (OWLObjectPropertyExpression)pred).iterator(), values);
        OWLAPITests.assertIteratorValues(reasoner.getObjectPropertyRelationships(subj).get(pred).iterator(), values);
    }

    public void testPropertyChain() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "propertyChain.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass C = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "C"));
        OWLClass S0 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "S0"));
        OWLClass R0 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "R0"));
        OWLClass R1 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "R1"));
        OWLObjectProperty r = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "r"));
        OWLObjectProperty s = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "s"));
        OWLIndividual[] a = new OWLIndividual[17];
        for (int i = 0; i < a.length; ++i) {
            a[i] = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "a" + i));
        }
        if (PelletOptions.USE_LOCAL_NAME) {
            ns = "";
        }
        Object[] theList = new OWLIndividual[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]};
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
        OWLAPITests.assertTrue((boolean)reasoner.isTransitive(r));
        OWLAPITests.assertFalse((boolean)reasoner.isTransitive(s));
        OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)C, false).iterator(), theList);
        OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)S0, false).iterator(), theList);
        OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)R0, false).iterator(), new OWLIndividual[]{a[7], a[9]});
        OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)R1, false).iterator(), new OWLIndividual[]{a[2], a[3], a[4], a[5], a[6]});
        OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(a[0], (OWLObjectPropertyExpression)r).iterator(), new OWLIndividual[]{a[7], a[9]});
        OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(a[1], (OWLObjectPropertyExpression)r).iterator(), new OWLIndividual[]{a[2], a[3], a[4], a[5], a[6]});
        OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(a[0], (OWLObjectPropertyExpression)s).iterator(), theList);
    }

    public void testQualifiedCardinality1() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "qcr.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass sub = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "sub"));
        OWLClass sup = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "sup"));
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
        OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)sub, (OWLDescription)sup));
        OWLAPITests.assertTrue((boolean)reasoner.getDescendantClasses((OWLDescription)sup).contains(SetUtils.singleton(sub)));
        OWLAPITests.assertTrue((boolean)reasoner.getAncestorClasses((OWLDescription)sub).contains(SetUtils.singleton(sup)));
    }

    public void testQualifiedCardinality2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = OWLAPITests.term("c");
        ATermAppl d = OWLAPITests.term("d");
        ATermAppl p = OWLAPITests.term("p");
        ATermAppl f = OWLAPITests.term("f");
        ATermAppl sub = OWLAPITests.term("sub");
        ATermAppl sup = OWLAPITests.term("sup");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)f);
        kb.addFunctionalProperty(f);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        OWLAPITests.assertTrue((boolean)kb.isSubClassOf(OWLAPITests.min(p, 2, OWLAPITests.and(c, d)), OWLAPITests.some(p, c)));
        OWLAPITests.assertTrue((boolean)kb.isSubClassOf(OWLAPITests.max(p, 1, sup), OWLAPITests.max(p, 2, sub)));
        OWLAPITests.assertTrue((boolean)kb.isSubClassOf(OWLAPITests.and(OWLAPITests.max(f, 1, TOP), OWLAPITests.all(f, c)), OWLAPITests.max(f, 1, c)));
        OWLAPITests.assertTrue((boolean)kb.isSubClassOf(OWLAPITests.and(OWLAPITests.min(p, 2, c), OWLAPITests.min(p, 2, OWLAPITests.not(c))), OWLAPITests.min(p, 4, TOP)));
    }

    public void testReflexive2() throws OWLException {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        URI ontURI = URI.create(base + "reflexive.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLObjectProperty[] knows = new OWLObjectProperty[]{manager.getOWLDataFactory().getOWLObjectProperty(URI.create(foaf + "knows")), manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "knows2")), manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "knows3"))};
        OWLIndividual[] people = new OWLIndividual[5];
        for (int i = 0; i < people.length; ++i) {
            people[i] = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "P" + (i + 1)));
            for (int j = 0; j < knows.length; ++j) {
                OWLAPITests.assertTrue((String)(people[i] + " " + knows[j]), (boolean)reasoner.hasObjectPropertyRelationship(people[i], (OWLObjectPropertyExpression)knows[j], people[i]));
                OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(people[i], (OWLObjectPropertyExpression)knows[j]).iterator(), new OWLIndividual[]{people[i]});
            }
        }
        Map answers = this.createMap(new Object[][]{{people[0], people[0]}, {people[1], people[1]}, {people[2], people[2]}, {people[3], people[3]}, {people[4], people[4]}});
        Map<OWLIndividual, Set<OWLIndividual>> result = reasoner.getPropertyValues(knows[0]);
        OWLAPITests.assertEquals((Object)answers, result);
    }

    public void testInfiniteChain() throws Exception {
        URI ontURI = URI.create(base + "infiniteChain.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLAPITests.assertTrue((!reasoner.isConsistent() ? 1 : 0) != 0);
    }

    public void testRemoveLiteral() throws Exception {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "RemoveLiteral.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLDataProperty pInt = manager.getOWLDataFactory().getOWLDataProperty(URI.create(ns + "pInt"));
        OWLDataProperty pDouble = manager.getOWLDataFactory().getOWLDataProperty(URI.create(ns + "pDouble"));
        OWLDataProperty pBoolean = manager.getOWLDataFactory().getOWLDataProperty(URI.create(ns + "pBoolean"));
        OWLIndividual ind = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind"));
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
        OWLConstant valDouble = reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pDouble).iterator().next();
        RemoveAxiom change = new RemoveAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pDouble, valDouble));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        OWLAPITests.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pDouble).isEmpty());
        OWLConstant valInt = reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pInt).iterator().next();
        change = new RemoveAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pInt, valInt));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        OWLAPITests.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pInt).isEmpty());
        OWLConstant valBoolean = reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pBoolean).iterator().next();
        change = new RemoveAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pBoolean, valBoolean));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        OWLAPITests.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pBoolean).isEmpty());
        OWLAPITests.assertTrue((boolean)reasoner.getDataPropertyRelationships(ind).isEmpty());
        OWLTypedConstant newVal = manager.getOWLDataFactory().getOWLTypedConstant("0.0", manager.getOWLDataFactory().getOWLDataType(XSDVocabulary.DOUBLE.getURI()));
        change = new AddAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pDouble, (OWLConstant)newVal));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
    }

    public void testUserDefinedDatatypes() throws Exception {
        PelletOptions.AUTO_XML_SCHEMA_LOADING = true;
        String ns = "http://www.mindswap.org/ontologies/family.owl#";
        URI ontURI = URI.create("http://www.mindswap.org/ontologies/family-ages.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass Child = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Child"));
        OWLClass Teenage = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teenage"));
        OWLClass Adult = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Adult"));
        OWLClass Senior = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Senior"));
        OWLIndividual Daughter = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Daughter"));
        OWLIndividual Son = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Son"));
        OWLIndividual Dad = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Dad"));
        OWLIndividual Grandpa = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Grandpa"));
        OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Senior, (OWLDescription)Adult));
        OWLAPITests.assertIteratorValues(reasoner.getSubClasses((OWLDescription)Adult).iterator(), new Object[]{SetUtils.singleton(Senior)});
        OWLAPITests.assertTrue((boolean)reasoner.hasType(Daughter, (OWLDescription)Child));
        OWLAPITests.assertTrue((boolean)reasoner.hasType(Son, (OWLDescription)Teenage));
        OWLAPITests.assertTrue((boolean)reasoner.hasType(Dad, (OWLDescription)Adult));
        OWLAPITests.assertTrue((boolean)reasoner.hasType(Grandpa, (OWLDescription)Senior));
        PelletOptions.AUTO_XML_SCHEMA_LOADING = false;
    }

    public void testFamily() throws OWLException {
        String ns = "http://www.example.org/family#";
        URI ontURI = URI.create(base + "family.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLObjectProperty hasBrother = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasBrother"));
        OWLObjectProperty hasSon = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSon"));
        OWLObjectProperty hasFather = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasFather"));
        OWLObjectProperty hasParent = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasParent"));
        OWLObjectProperty hasChild = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasChild"));
        OWLObjectProperty hasMother = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasMother"));
        OWLObjectProperty hasDaughter = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasDaughter"));
        OWLObjectProperty hasAncestor = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasAncestor"));
        OWLObjectProperty likes = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "likes"));
        OWLObjectProperty isMarriedTo = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "isMarriedTo"));
        OWLObjectProperty dislikes = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "dislikes"));
        OWLObjectProperty hasSister = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSister"));
        OWLObjectProperty hasDescendant = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasDescendant"));
        OWLObjectProperty hasSibling = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSibling"));
        OWLClass Child = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Child"));
        OWLClass Person = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Person"));
        OWLClass PersonWithAtLeastTwoMaleChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastTwoMaleChildren"));
        OWLClass PersonWithAtLeastTwoFemaleChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastTwoFemaleChildren"));
        OWLClass PersonWithAtLeastTwoChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastTwoChildren"));
        OWLClass PersonWithAtLeastFourChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastFourChildren"));
        OWLClass Teen = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teen"));
        OWLClass Teenager = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teenager"));
        OWLClass Male = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Male"));
        OWLClass Adult = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Adult"));
        OWLClass Female = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Female"));
        OWLClass Senior = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Senior"));
        OWLIndividual grandmother = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "grandmother"));
        OWLIndividual grandfather = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "grandfather"));
        OWLIndividual father = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "father"));
        OWLIndividual son = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "son"));
        OWLIndividual mother = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "mother"));
        OWLIndividual daughter = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "daughter"));
        OWLIndividual personX = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "personX"));
        OWLIndividual personY = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "personY"));
        OWLIndividual personZ = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "personZ"));
        OWLAPITests.assertTrue((boolean)reasoner.isConsistent());
        KnowledgeBase kb = reasoner.getKB();
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                kb.realize();
            }
            OWLAPITests.assertTrue((boolean)reasoner.isTransitive(hasAncestor));
            OWLAPITests.assertFalse((boolean)reasoner.isFunctional(hasAncestor));
            OWLAPITests.assertTrue((boolean)reasoner.isTransitive(hasDescendant));
            OWLAPITests.assertFalse((boolean)reasoner.isFunctional(hasDescendant));
            OWLAPITests.assertTrue((boolean)reasoner.isSymmetric(isMarriedTo));
            OWLAPITests.assertTrue((boolean)reasoner.isIrreflexive(isMarriedTo));
            OWLAPITests.assertTrue((boolean)reasoner.isSubPropertyOf(hasParent, hasAncestor));
            OWLAPITests.assertTrue((boolean)reasoner.isSubPropertyOf(hasFather, hasAncestor));
            OWLAPITests.assertTrue((boolean)reasoner.isSubPropertyOf(hasMother, hasAncestor));
            OWLAPITests.assertTrue((boolean)reasoner.isSubPropertyOf(hasChild, hasDescendant));
            OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith(likes, dislikes));
            OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith(dislikes, likes));
            OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith(hasFather, hasMother));
            OWLAPITests.assertTrue((boolean)reasoner.isDisjointWith(hasMother, hasFather));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)PersonWithAtLeastTwoChildren));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)PersonWithAtLeastTwoMaleChildren));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Male));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Senior));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)isMarriedTo, grandmother));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)hasChild, father));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)hasSon, father));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, grandmother));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, father));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, mother));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, son));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, daughter));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Female));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Senior));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)isMarriedTo, grandfather));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)hasChild, father));
            OWLAPITests.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)hasSon, father));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Male));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Adult));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasParent, grandfather));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasParent, grandmother));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasFather, grandfather));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasMother, grandmother));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasChild, son));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasSon, son));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasChild, daughter));
            OWLAPITests.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasDaughter, daughter));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(mother, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(mother, (OWLDescription)Female));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Male));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Teenager));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Teen));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasParent, father));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasFather, father));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasSibling, daughter));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasSister, daughter));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(daughter, (OWLDescription)Female));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(daughter, (OWLDescription)Child));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasAncestor, grandfather));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasAncestor, grandmother));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasParent, father));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasFather, father));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasParent, mother));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasMother, mother));
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasSibling, son));
            OWLAPITests.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasBrother, son));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(personX, personY));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(personX, personZ));
            OWLAPITests.assertTrue((boolean)reasoner.isDifferentFrom(personY, personZ));
            OWLAPITests.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)Teen, (OWLDescription)Teenager));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Senior, (OWLDescription)Adult));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoChildren, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastFourChildren, (OWLDescription)Person));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastFourChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            OWLAPITests.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            OWLAPITests.assertFalse((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)PersonWithAtLeastTwoMaleChildren));
            OWLAPITests.assertFalse((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)PersonWithAtLeastTwoFemaleChildren));
        }
    }

    public void testRete() throws OWLException {
        URI ontURI = URI.create(base + "rules.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        Interpreter interp = new Interpreter(reasoner.getKB().getABox());
        interp.rete.compile(new RulesToReteTranslator(reasoner.getKB().getABox()).translateRules(reasoner.getKB().getRules()));
        Set<Fact> facts = interp.rete.compileFacts(reasoner.getKB().getABox());
        interp.addFacts(facts, true);
        interp.run();
        OWLAPITests.assertEquals((int)interp.inferredFacts.size(), (int)2);
    }

    public void testAnonInverse() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "anon_inverse.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.loadOntology(ontURI);
        OWLClass C = factory.getOWLClass(URI.create(ns + "C"));
        OWLClass D = factory.getOWLClass(URI.create(ns + "D"));
        OWLObjectProperty invR = factory.getOWLObjectProperty(URI.create(ns + "invR"));
        OWLObjectSomeRestriction desc = factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)invR), (OWLDescription)D);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntologies(Collections.singleton(ont));
        OWLAPITests.assertEquals(Collections.singleton(Collections.singleton(C)), reasoner.getSubClasses((OWLDescription)desc));
    }

    public void testDLSafeRules() throws OWLOntologyCreationException, OWLReasonerException {
        String ns = "http://owldl.com/ontologies/dl-safe.owl#";
        URI ontURI = URI.create(base + "dl-safe.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLObjectProperty hates = factory.getOWLObjectProperty(URI.create(ns + "hates"));
        OWLObjectProperty sibling = factory.getOWLObjectProperty(URI.create(ns + "sibling"));
        OWLClass BadChild = factory.getOWLClass(URI.create(ns + "BadChild"));
        OWLClass Child = factory.getOWLClass(URI.create(ns + "Child"));
        OWLClass Grandchild = factory.getOWLClass(URI.create(ns + "Grandchild"));
        OWLClass Person = factory.getOWLClass(URI.create(ns + "Person"));
        OWLIndividual Abel = factory.getOWLIndividual(URI.create(ns + "Abel"));
        OWLIndividual Cain = factory.getOWLIndividual(URI.create(ns + "Cain"));
        OWLIndividual Oedipus = factory.getOWLIndividual(URI.create(ns + "Oedipus"));
        OWLIndividual Remus = factory.getOWLIndividual(URI.create(ns + "Remus"));
        OWLIndividual Romulus = factory.getOWLIndividual(URI.create(ns + "Romulus"));
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                reasoner.realise();
            }
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Abel, (OWLObjectPropertyExpression)sibling, Cain));
            OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(Abel, (OWLObjectPropertyExpression)sibling).iterator(), new Object[]{Cain});
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Cain, (OWLObjectPropertyExpression)sibling, Abel));
            OWLAPITests.assertIteratorValues(reasoner.getRelatedIndividuals(Cain, (OWLObjectPropertyExpression)sibling).iterator(), new Object[]{Abel});
            OWLAPITests.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Cain, (OWLObjectPropertyExpression)hates, Abel));
            OWLAPITests.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(Abel, (OWLObjectPropertyExpression)hates, Cain));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(Cain, (OWLDescription)Grandchild));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(Cain, (OWLDescription)BadChild));
            OWLAPITests.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(Romulus, (OWLObjectPropertyExpression)sibling, Remus));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(Romulus, (OWLDescription)Grandchild));
            OWLAPITests.assertFalse((boolean)reasoner.hasType(Romulus, (OWLDescription)BadChild));
            OWLAPITests.assertTrue((boolean)reasoner.hasType(Oedipus, (OWLDescription)Child));
        }
        OWLAPITests.assertIteratorValues(SetUtils.union(reasoner.getTypes(Cain, true)).iterator(), new Object[]{BadChild, Child, Person});
    }

    public void testDLSafeConstants() throws OWLReasonerException, OWLOntologyCreationException {
        String ns = "http://owldl.com/ontologies/dl-safe-constants.owl#";
        URI ontURI = URI.create(base + "dl-safe-constants.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass DreamTeamMember = factory.getOWLClass(URI.create(ns + "DreamTeamMember"));
        OWLClass DreamTeamMember1 = factory.getOWLClass(URI.create(ns + "DreamTeamMember1"));
        OWLClass DreamTeamMember2 = factory.getOWLClass(URI.create(ns + "DreamTeamMember2"));
        OWLIndividual Alice = factory.getOWLIndividual(URI.create(ns + "Alice"));
        OWLIndividual Bob = factory.getOWLIndividual(URI.create(ns + "Bob"));
        OWLIndividual Charlie = factory.getOWLIndividual(URI.create(ns + "Charlie"));
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                reasoner.realise();
            }
            OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember, false).iterator(), new Object[]{Alice, Bob, Charlie});
            OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember1, false).iterator(), new Object[]{Alice, Bob, Charlie});
            OWLAPITests.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember2, false).iterator(), new Object[]{Alice, Bob, Charlie});
        }
    }

    public void testInvalidTransitivity() throws Exception {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(ns);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.createOntology(ontURI);
        OWLClass C = factory.getOWLClass(URI.create(ns + "C"));
        OWLObjectProperty p1 = factory.getOWLObjectProperty(URI.create(ns + "p1"));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p1)));
        OWLObjectProperty p2 = factory.getOWLObjectProperty(URI.create(ns + "p2"));
        OWLIndividual x = factory.getOWLIndividual(URI.create(ns + "x"));
        OWLIndividual y = factory.getOWLIndividual(URI.create(ns + "y"));
        OWLIndividual z = factory.getOWLIndividual(URI.create(ns + "z"));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLClassAssertionAxiom(x, (OWLDescription)factory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)p1, (OWLDescription)C))));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom(x, (OWLObjectPropertyExpression)p1, y)));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom(y, (OWLObjectPropertyExpression)p1, z)));
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLAPITests.assertTrue((boolean)reasoner.hasType(y, (OWLDescription)C));
        OWLAPITests.assertTrue((boolean)reasoner.hasType(z, (OWLDescription)C));
        OWLAxiom[] axioms = new OWLAxiom[]{factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLAntiSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLDisjointObjectPropertiesAxiom(OWLAPITests.set(p1, p2)), factory.getOWLSubClassAxiom((OWLDescription)C, (OWLDescription)factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)p1, 2)), factory.getOWLClassAssertionAxiom(x, (OWLDescription)factory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)p1, 3)), factory.getOWLDisjointClassesAxiom(OWLAPITests.set(C, factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)p1, 2)))};
        for (int i = 0; i < axioms.length; ++i) {
            manager.applyChange((OWLOntologyChange)new AddAxiom(ont, axioms[i]));
            reasoner = new Reasoner(manager);
            reasoner.setOntology(ont);
            OWLAPITests.assertTrue((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)factory.getOWLClassAssertionAxiom(y, (OWLDescription)C)));
            OWLAPITests.assertFalse((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)factory.getOWLClassAssertionAxiom(z, (OWLDescription)C)));
            manager.applyChange((OWLOntologyChange)new RemoveAxiom(ont, axioms[i]));
        }
    }

    public void testInvalidTransitivity2() throws OWLOntologyCreationException {
        URI ontURI = URI.create(base + "invalidTransitivity.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        for (OWLAxiom axiom : ont.getAxioms()) {
            System.out.println(axiom);
        }
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        KnowledgeBase kb = reasoner.getKB();
        kb.prepare();
        for (Role r : kb.getRBox().getRoles()) {
            OWLAPITests.assertTrue((String)r.toString(), (boolean)r.isSimple());
            OWLAPITests.assertFalse((String)r.toString(), (boolean)r.isTransitive());
        }
        for (ATermAppl p : kb.getObjectProperties()) {
            OWLAPITests.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
        }
    }
}

