/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import aterm.ATerm;
import aterm.ATermAppl;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class IncConsistencyTests
extends PelletTestCase {
    private KnowledgeBase kb;
    private boolean preUCQ;
    private boolean preUIC;
    private boolean preUSR;
    private boolean preUAQ;
    private boolean preUT;
    private boolean preUID;
    private static final boolean PRINT_ABOX = false;
    private ATermAppl robert = ATermUtils.makeTermAppl("Robert");
    private ATermAppl mary = ATermUtils.makeTermAppl("Mary");
    private ATermAppl chris = ATermUtils.makeTermAppl("Chris");
    private ATermAppl john = ATermUtils.makeTermAppl("John");
    private ATermAppl bill = ATermUtils.makeTermAppl("Bill");
    private ATermAppl victor = ATermUtils.makeTermAppl("Victor");
    private ATermAppl mbox = ATermUtils.makeTermAppl("mbox");
    private ATermAppl relative = ATermUtils.makeTermAppl("relative");
    private ATermAppl sibling = ATermUtils.makeTermAppl("sibling");
    private ATermAppl person = ATermUtils.makeTermAppl("person");
    private ATermAppl animalOwner = ATermUtils.makeTermAppl("animalOwner");
    private ATermAppl owns = ATermUtils.makeTermAppl("owns");
    private ATermAppl ownedBy = ATermUtils.makeTermAppl("ownedBy");
    private ATermAppl knows = ATermUtils.makeTermAppl("knows");
    private ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
    private ATermAppl man = ATermUtils.makeTermAppl("man");
    private ATermAppl woman = ATermUtils.makeTermAppl("woman");
    private ATermAppl animal = ATermUtils.makeTermAppl("animal");
    private ATermAppl dog = ATermUtils.makeTermAppl("dog");
    private ATermAppl cat = ATermUtils.makeTermAppl("cat");
    private ATermAppl notCat = ATermUtils.makeNot((ATerm)this.cat);
    private ATermAppl notDog = ATermUtils.makeNot((ATerm)this.dog);
    private ATermAppl ssn = ATermUtils.makeTermAppl("ssn");
    private ATermAppl ownsAnimal = ATermUtils.makeTermAppl("ownsAnimal");

    public void setUp() {
        this.preUCQ = PelletOptions.USE_COMPLETION_QUEUE;
        this.preUIC = PelletOptions.USE_INCREMENTAL_CONSISTENCY;
        this.preUSR = PelletOptions.USE_SMART_RESTORE;
        this.preUID = PelletOptions.USE_INCREMENTAL_DELETION;
        this.preUT = PelletOptions.USE_TRACING;
        this.preUAQ = PelletOptions.USE_ADVANCED_COMPLETION_QUEUE;
        PelletOptions.USE_COMPLETION_QUEUE = true;
        PelletOptions.USE_ADVANCED_COMPLETION_QUEUE = false;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
        PelletOptions.USE_INCREMENTAL_DELETION = true;
        PelletOptions.USE_TRACING = true;
        PelletOptions.USE_SMART_RESTORE = true;
    }

    protected void tearDown() throws Exception {
        PelletOptions.USE_COMPLETION_QUEUE = this.preUCQ;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = this.preUIC;
        PelletOptions.USE_SMART_RESTORE = this.preUSR;
        PelletOptions.USE_TRACING = this.preUT;
        PelletOptions.USE_INCREMENTAL_DELETION = this.preUID;
        PelletOptions.USE_ADVANCED_COMPLETION_QUEUE = this.preUAQ;
    }

    public void testDisjunction() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.notPerson);
        this.kb.addDisjointClass(this.person, this.notPerson);
        this.kb.addClass(this.animalOwner);
        this.kb.addClass(this.animal);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.notDog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.notCat);
        this.kb.addDisjointClass(this.cat, this.notCat);
        this.kb.addDisjointClass(this.dog, this.notDog);
        this.kb.addDisjointClass(this.dog, this.cat);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addObjectProperty((ATerm)this.ownsAnimal);
        this.kb.addDomain((ATerm)this.ownsAnimal, this.person);
        this.kb.addRange((ATerm)this.ownsAnimal, this.animal);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral("012345678");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        ATermAppl catOrDog = ATermUtils.makeOr(this.dog, this.cat);
        this.kb.addSubClass(this.animal, catOrDog);
        ATermAppl ownsSomeAnimal = ATermUtils.makeSomeValues((ATerm)this.ownsAnimal, (ATerm)this.animal);
        this.kb.addClass(ownsSomeAnimal);
        this.kb.addSubClass(this.animalOwner, ownsSomeAnimal);
        ATermAppl ownsNoCats = ATermUtils.makeAllValues((ATerm)this.ownsAnimal, (ATerm)this.notCat);
        ATermAppl ownsNoDogs = ATermUtils.makeAllValues((ATerm)this.ownsAnimal, (ATerm)this.notDog);
        this.kb.addType(this.robert, ownsSomeAnimal);
        this.kb.addType(this.mary, ownsSomeAnimal);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, ownsNoCats);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoCats);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.mary, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.mary, ownsNoCats);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
    }

    public void testDisjunction2() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)this.dog);
        this.kb.addClass(owersAreDogs);
        this.kb.addSubClass(this.dog, owersAreDogs);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.robert, manOrDog);
        this.kb.addType(this.robert, ATermUtils.makeNot((ATerm)this.dog));
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, ATermUtils.makeNot((ATerm)this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasType((ATerm)this.dog));
    }

    public void testUC() {
        boolean preRoleA = PelletOptions.USE_ROLE_ABSORPTION;
        boolean preAb = PelletOptions.USE_ABSORPTION;
        PelletOptions.USE_ROLE_ABSORPTION = false;
        PelletOptions.USE_ABSORPTION = false;
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.knows);
        ATermAppl onlyKnowsPeople = ATermUtils.makeAllValues((ATerm)this.knows, (ATerm)this.person);
        this.kb.addClass(onlyKnowsPeople);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addDisjointClass(this.man, this.woman);
        ATermAppl notDog = ATermUtils.makeNot((ATerm)this.dog);
        this.kb.addClass(notDog);
        ATermAppl personAndNotDog = ATermUtils.makeAnd((ATerm)this.person, (ATerm)notDog);
        this.kb.addClass(personAndNotDog);
        ATermAppl manOrWoman = ATermUtils.makeOr(this.man, this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addSubClass(manOrWoman, personAndNotDog);
        this.kb.addIndividual(this.robert);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.mary).getTypes(1).isEmpty() ? 1 : 0) != 0);
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).getTypes(1).isEmpty() ? 1 : 0) != 0);
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).getTypes(1).isEmpty() ? 1 : 0) != 0);
        PelletOptions.USE_ROLE_ABSORPTION = preRoleA;
        PelletOptions.USE_ABSORPTION = preAb;
    }

    public void testMax() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.chris);
        this.kb.addPropertyValue(this.sibling, this.bill, this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.robert, this.chris);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.john);
        ATermAppl twoSiblings = ATermUtils.makeMax((ATerm)this.sibling, 2, (ATerm)this.person);
        this.kb.addClass(twoSiblings);
        ATermAppl manOrDog = ATermUtils.makeOr(twoSiblings, this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.robert, manOrDog);
        this.kb.addType(this.bill, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addDifferent(this.chris, this.victor);
        this.kb.addDifferent(this.chris, this.mary);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.bill, ATermUtils.makeNot((ATerm)this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.bill, ATermUtils.makeNot((ATerm)this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
    }

    public void testMerge() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        this.kb.addPropertyValue(this.sibling, this.chris, this.victor);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getNode((ATerm)this.bill).hasSuccessor(this.kb.getABox().getPseudoModel().getNode((ATerm)this.victor)) ? 1 : 0) != 0);
        this.kb.addSame(this.chris, this.bill);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.bill).hasSuccessor(this.kb.getABox().getPseudoModel().getNode((ATerm)this.victor)));
        this.kb.addDifferent(this.bill, this.chris);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
    }

    public void testMerge3() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.man);
        this.kb.addClass(this.dog);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        ATermAppl max = ATermUtils.makeMax((ATerm)this.sibling, 1, (ATerm)ATermUtils.TOP);
        this.kb.addClass(max);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).isSame(this.kb.getABox().getPseudoModel().getNode((ATerm)this.john)));
        this.kb.addType(this.bill, max);
        this.kb.addType(this.mary, manOrDog);
        this.kb.addType(this.chris, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).isSame(this.kb.getABox().getPseudoModel().getNode((ATerm)this.john)));
        this.kb.removeType(this.bill, max);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).isSame(this.kb.getABox().getPseudoModel().getNode((ATerm)this.john)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).hasType((ATerm)this.dog));
    }

    public void testMerge2() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.man);
        this.kb.addClass(this.dog);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        ATermAppl max = ATermUtils.makeMax((ATerm)this.sibling, 1, (ATerm)ATermUtils.TOP);
        this.kb.addClass(max);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.mary, manOrDog);
        this.kb.addType(this.chris, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).isSame(this.kb.getABox().getPseudoModel().getNode((ATerm)this.john)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).hasType((ATerm)this.dog));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        this.kb.addType(this.bill, max);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).isSame(this.kb.getABox().getPseudoModel().getNode((ATerm)this.john)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        this.kb.removeType(this.bill, max);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).isSame(this.kb.getABox().getPseudoModel().getNode((ATerm)this.john)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode((ATerm)this.mary).hasType((ATerm)this.dog));
    }

    public void testCompletionQueueBackjumping() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl allCat = ATermUtils.makeAllValues((ATerm)this.owns, (ATerm)this.cat);
        this.kb.addClass(allCat);
        ATermAppl catAndMan = ATermUtils.makeAnd((ATerm)allCat, (ATerm)this.man);
        this.kb.addClass(catAndMan);
        ATermAppl manOrWoman = ATermUtils.makeOr(this.man, this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addType(this.robert, manOrWoman);
        this.kb.addType(this.victor, manOrWoman);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        this.kb.addType(this.victor, ATermUtils.makeNot((ATerm)this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        this.kb.removeType(this.victor, ATermUtils.makeNot((ATerm)this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasType((ATerm)ATermUtils.makeNot((ATerm)this.man)));
        this.kb.addType(this.robert, ATermUtils.makeNot((ATerm)this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasType((ATerm)ATermUtils.makeNot((ATerm)this.man)));
        this.kb.removeType(this.robert, ATermUtils.makeNot((ATerm)this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasType((ATerm)ATermUtils.makeNot((ATerm)this.man)));
        this.kb.addType(this.robert, ATermUtils.makeNot((ATerm)this.woman));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
    }

    public void testRemoveBranch() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl allCat = ATermUtils.makeAllValues((ATerm)this.owns, (ATerm)this.cat);
        this.kb.addClass(allCat);
        ATermAppl catAndMan = ATermUtils.makeAnd((ATerm)allCat, (ATerm)this.man);
        this.kb.addClass(catAndMan);
        ATermAppl manOrWoman = ATermUtils.makeOr(this.man, this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addType(this.robert, manOrWoman);
        this.kb.addType(this.victor, manOrWoman);
        this.kb.addType(this.mary, manOrWoman);
        this.kb.addType(this.chris, manOrWoman);
        this.kb.addType(this.john, manOrWoman);
        this.kb.addType(this.bill, manOrWoman);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        this.kb.removeType(this.victor, manOrWoman);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.mary).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.chris).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.john).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.bill).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((this.kb.getABox().getPseudoModel().getBranches().size() == 5 ? 1 : 0) != 0);
        this.kb.addType(this.chris, ATermUtils.makeNot((ATerm)this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.chris).getTypes().contains(this.man));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.chris).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.mary).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
    }

    public void testUpdatedIndviduals() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addRange((ATerm)this.relative, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addPropertyValue(this.relative, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        ATermAppl siblingPerson = ATermUtils.makeAllValues((ATerm)this.sibling, (ATerm)this.person);
        this.kb.addClass(siblingPerson);
        this.kb.addType(this.victor, this.person);
        this.kb.addType(this.mary, this.person);
        this.kb.addType(this.robert, siblingPerson);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasType((ATerm)this.person));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.mary).hasType((ATerm)this.person));
        this.kb.removeType(this.victor, this.person);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).hasType((ATerm)this.person));
        this.kb.removeType(this.mary, this.person);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.mary).hasType((ATerm)this.person));
    }

    public void testClashDependency() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.notPerson);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addType(this.robert, this.person);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, this.notPerson);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, this.notPerson);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
    }

    public void testBlocking() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(ATermUtils.makeNot((ATerm)this.person));
        this.kb.addDisjointClass(this.person, ATermUtils.makeNot((ATerm)this.person));
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addInverseProperty(this.ownedBy, this.owns);
        ATermAppl allSPerson = ATermUtils.makeAllValues((ATerm)this.knows, (ATerm)ATermUtils.makeNot((ATerm)this.person));
        this.kb.addClass(allSPerson);
        ATermAppl allRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)allSPerson);
        this.kb.addClass(allRInvallSPerson);
        ATermAppl allRInvallRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)allRInvallSPerson);
        this.kb.addClass(allRInvallRInvallSPerson);
        ATermAppl allRInvallRInvallRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)allRInvallRInvallSPerson);
        this.kb.addClass(allRInvallRInvallRInvallSPerson);
        ATermAppl allRallRInvallRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.owns, (ATerm)allRInvallRInvallRInvallSPerson);
        this.kb.addClass(allRallRInvallRInvallSPerson);
        ATermAppl allRallRallRInvallRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.owns, (ATerm)allRallRInvallRInvallSPerson);
        this.kb.addClass(allRallRallRInvallRInvallSPerson);
        ATermAppl allRallRallRallRInvallRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.owns, (ATerm)allRallRallRInvallRInvallSPerson);
        this.kb.addClass(allRallRallRallRInvallRInvallSPerson);
        ATermAppl allSallRallRallRallRInvallRInvallSPerson = ATermUtils.makeAllValues((ATerm)this.knows, (ATerm)allRallRallRallRInvallRInvallSPerson);
        this.kb.addClass(allSallRallRallRallRInvallRInvallSPerson);
        ATermAppl neg = ATermUtils.makeNot((ATerm)allSallRallRallRallRInvallRInvallSPerson);
        neg = ATermUtils.normalize(neg);
        this.kb.addClass(neg);
        this.kb.addClass(this.man);
        this.kb.addEquivalentClass(this.man, neg);
        this.kb.addClass(this.woman);
        ATermAppl someWoman = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.woman);
        this.kb.addClass(someWoman);
        this.kb.addSubClass(this.woman, someWoman);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.john);
        this.kb.addType(this.mary, this.woman);
        this.kb.addPropertyValue(this.knows, this.robert, this.mary);
        this.kb.addPropertyValue(this.knows, this.mary, this.john);
        this.kb.prepare();
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.DEBUG);
        this.kb.isConsistent();
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.OFF);
        this.kb.addType(this.john, this.person);
        this.kb.addType(this.robert, ATermUtils.makeNot((ATerm)this.man));
        System.out.println("Checking consistency");
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.DEBUG);
        boolean cons = this.kb.isConsistent();
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.OFF);
        System.out.println("Done (" + cons + ")");
        IncConsistencyTests.assertFalse((boolean)cons);
    }

    public void testBacktracking() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)this.dog);
        this.kb.addClass(owersAreDogs);
        ATermAppl owersAreCats = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)this.cat);
        this.kb.addClass(owersAreCats);
        this.kb.addSubClass(this.dog, owersAreDogs);
        this.kb.addClass(ATermUtils.negate(this.dog));
        ATermAppl manOrDog = ATermUtils.makeOr(ATermUtils.negate(this.dog), this.woman);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.victor, manOrDog);
        this.kb.addType(this.robert, owersAreCats);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.victor, this.man);
        this.kb.addPropertyValue(this.ownedBy, this.robert, this.mary);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.mary).hasType((ATerm)this.cat));
    }

    public void testBacktracking3() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        ATermAppl catOrDog = ATermUtils.makeOr(this.cat, this.dog);
        this.kb.addClass(catOrDog);
        ATermAppl manOrDogAndWoman = ATermUtils.makeAnd((ATerm)this.woman, (ATerm)manOrDog);
        this.kb.addClass(manOrDog);
        ATermAppl womanOrDogAndWoman = ATermUtils.makeAnd((ATerm)this.woman, (ATerm)catOrDog);
        this.kb.addClass(manOrDogAndWoman);
        ATermAppl bigDisj = ATermUtils.makeOr(manOrDogAndWoman, womanOrDogAndWoman);
        this.kb.addClass(bigDisj);
        this.kb.addType(this.victor, ownsDog);
        this.kb.addPropertyValue(this.owns, this.victor, this.robert);
        this.kb.addType(this.robert, this.dog);
        this.kb.addType(this.mary, bigDisj);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removePropertyValue(this.owns, this.victor, this.robert);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).getRNeighborEdges(this.kb.getRBox().getRole((ATerm)this.owns)).size() > 0 ? 1 : 0) != 0);
        this.kb.addType(this.mary, ATermUtils.makeNot((ATerm)this.cat));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.victor).getRNeighborEdges(this.kb.getRBox().getRole((ATerm)this.owns)).size() > 0 ? 1 : 0) != 0);
    }

    public void testBacktracking2() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.bill);
        ATermAppl ownsDog = ATermUtils.makeSomeValues((ATerm)this.owns, (ATerm)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)this.dog);
        this.kb.addClass(owersAreDogs);
        ATermAppl owersAreCats = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)this.cat);
        this.kb.addClass(owersAreCats);
        ATermAppl owersownersAreCats = ATermUtils.makeAllValues((ATerm)this.ownedBy, (ATerm)owersAreCats);
        this.kb.addClass(owersownersAreCats);
        this.kb.addSubClass(this.dog, owersAreDogs);
        this.kb.addClass(ATermUtils.negate(this.dog));
        ATermAppl manOrDog = ATermUtils.makeOr(ATermUtils.negate(this.dog), this.woman);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.victor, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, owersownersAreCats);
        this.kb.addPropertyValue(this.ownedBy, this.robert, this.mary);
        this.kb.addPropertyValue(this.ownedBy, this.mary, this.chris);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.chris).hasType((ATerm)this.cat));
        this.kb.addType(this.victor, this.man);
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual((ATerm)this.chris).hasType((ATerm)this.cat));
    }
}

