/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.rules.BindingGeneratorImpl;
import org.mindswap.pellet.rules.BindingHelper;
import org.mindswap.pellet.rules.DataRangeBindingHelper;
import org.mindswap.pellet.rules.DatavaluePropertyBindingHelper;
import org.mindswap.pellet.rules.ObjectVariableBindingHelper;
import org.mindswap.pellet.rules.TrivialSatisfactionHelpers;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.model.AtomDConstant;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class BindingGeneratorsTest
extends PelletTestCase {
    KnowledgeBase kb;
    private static final ATermAppl data1 = ATermUtils.makePlainLiteral("data1");
    private static final ATermAppl data2 = ATermUtils.makePlainLiteral("data2");
    private static final ATermAppl data3 = ATermUtils.makePlainLiteral("data3");
    private static final ATermAppl data4 = ATermUtils.makeTypedLiteral("4", "http://www.w3.org/2001/XMLSchema#decimal");
    private static final ATermAppl dp1 = ATermUtils.makeTermAppl("dataProp1");
    private static final ATermAppl dp2 = ATermUtils.makeTermAppl("dataProp1");
    private static final ATermAppl mary = ATermUtils.makeTermAppl("Mary");
    private static final ATermAppl p = ATermUtils.makeTermAppl("p");
    private static final ATermAppl robert = ATermUtils.makeTermAppl("Robert");
    private static final ATermAppl victor = ATermUtils.makeTermAppl("Victor");
    private AtomIVariable x;
    private AtomIVariable y;
    private AtomDVariable z;

    public void setUp() {
        this.kb = new KnowledgeBase();
        this.x = new AtomIVariable("x");
        this.y = new AtomIVariable("y");
        this.z = new AtomDVariable("z");
        this.kb.addDatatypeProperty((ATerm)dp1);
        this.kb.addDatatypeProperty((ATerm)dp2);
        this.kb.addSubProperty((ATerm)dp1, dp2);
        this.kb.addIndividual(mary);
        this.kb.addIndividual(robert);
        this.kb.addIndividual(victor);
        this.kb.addPropertyValue(dp1, mary, data1);
        this.kb.addPropertyValue(dp2, mary, data2);
        this.kb.addPropertyValue(dp1, robert, data2);
        this.kb.addPropertyValue(dp1, robert, data3);
        this.kb.addPropertyValue(dp2, victor, data4);
    }

    public void testCombinatorialBindingGeneration() {
        ObjectVariableBindingHelper genHelper1 = new ObjectVariableBindingHelper(this.kb.getABox(), this.x);
        ObjectVariableBindingHelper genHelper2 = new ObjectVariableBindingHelper(this.kb.getABox(), this.y);
        Individual[] individualsUsed = new Individual[]{this.kb.getABox().getIndividual((ATerm)mary), this.kb.getABox().getIndividual((ATerm)robert), this.kb.getABox().getIndividual((ATerm)victor)};
        ArrayList<BindingHelper> genSet = new ArrayList<BindingHelper>();
        BindingGeneratorImpl emptyGen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), genSet);
        BindingGeneratorsTest.assertFalse((boolean)emptyGen.iterator().hasNext());
        genSet.add(genHelper1);
        genSet.add(genHelper2);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), genSet);
        LinkedList<VariableBinding> expected = new LinkedList<VariableBinding>();
        for (Individual xNode : individualsUsed) {
            for (Individual yNode : individualsUsed) {
                VariableBinding bindings = new VariableBinding(this.kb.getABox());
                bindings.set((AtomIObject)this.x, xNode);
                bindings.set((AtomIObject)this.y, yNode);
                expected.add(bindings);
            }
        }
        BindingGeneratorsTest.assertIteratorValues(gen.iterator(), expected.iterator());
    }

    public void testDataRangeBindingHelper() {
        DatavaluedPropertyAtom pattern = new DatavaluedPropertyAtom(dp2, this.x, this.z);
        DataRangeAtom atom = new DataRangeAtom(this.kb.getDatatypeReasoner().getDatatype("http://www.w3.org/2001/XMLSchema#integer"), this.z);
        DatavaluePropertyBindingHelper patternHelper = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern);
        DataRangeBindingHelper rangeHelper = new DataRangeBindingHelper(atom);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), Arrays.asList(patternHelper, rangeHelper));
        VariableBinding expectedBinding = new VariableBinding(this.kb.getABox());
        expectedBinding.set((AtomIObject)this.x, this.kb.getABox().getIndividual((ATerm)victor));
        expectedBinding.set((AtomDObject)this.z, this.kb.getABox().getLiteral((ATerm)data4));
        LinkedList<VariableBinding> expected = new LinkedList<VariableBinding>();
        expected.add(expectedBinding);
        BindingGeneratorsTest.assertIteratorValues(gen.iterator(), expected.iterator());
    }

    public void testDatavalueBindingGeneratorChained() {
        DatavaluedPropertyAtom pattern1 = new DatavaluedPropertyAtom(dp2, this.x, this.z);
        DatavaluedPropertyAtom pattern2 = new DatavaluedPropertyAtom(dp2, this.y, this.z);
        DatavaluePropertyBindingHelper genHelper1 = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern1);
        DatavaluePropertyBindingHelper genHelper2 = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern2);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), Arrays.asList(genHelper1, genHelper2));
        LinkedList<VariableBinding> expected = new LinkedList<VariableBinding>();
        ATermAppl[] names = new ATermAppl[]{mary, robert, victor};
        ATermAppl[] values = new ATermAppl[]{data1, data2, data3, data4};
        Role r = this.kb.getABox().getRole((ATerm)dp2);
        for (ATermAppl xName : names) {
            for (ATermAppl yName : names) {
                for (ATermAppl zValue : values) {
                    Individual xNode = this.kb.getABox().getIndividual((ATerm)xName);
                    Individual yNode = this.kb.getABox().getIndividual((ATerm)yName);
                    Literal zNode = this.kb.getABox().getLiteral((ATerm)zValue);
                    if (xNode.getRNeighborEdges(r).getEdgesContaining(zNode).size() <= 0 || yNode.getRNeighborEdges(r).getEdgesContaining(zNode).size() <= 0) continue;
                    VariableBinding binding = new VariableBinding(this.kb.getABox());
                    binding.set((AtomIObject)this.x, xNode);
                    binding.set((AtomIObject)this.y, yNode);
                    binding.set((AtomDObject)this.z, zNode);
                    expected.add(binding);
                }
            }
        }
        BindingGeneratorsTest.assertIteratorValues(gen.iterator(), expected.iterator());
    }

    public void testDatavalueBindingGeneratorChainedSubject() {
        ATermAppl[] names;
        DatavaluedPropertyAtom pattern1 = new DatavaluedPropertyAtom(dp2, this.x, new AtomDConstant(data2));
        DatavaluedPropertyAtom pattern2 = new DatavaluedPropertyAtom(dp2, this.y, new AtomDConstant(data2));
        DatavaluePropertyBindingHelper genHelper1 = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern1);
        DatavaluePropertyBindingHelper genHelper2 = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern2);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), Arrays.asList(genHelper1, genHelper2));
        LinkedList<VariableBinding> expected = new LinkedList<VariableBinding>();
        for (ATermAppl xName : names = new ATermAppl[]{mary, robert}) {
            for (ATermAppl yName : names) {
                Individual xNode = this.kb.getABox().getIndividual((ATerm)xName);
                Individual yNode = this.kb.getABox().getIndividual((ATerm)yName);
                VariableBinding binding = new VariableBinding(this.kb.getABox());
                binding.set((AtomIObject)this.x, xNode);
                binding.set((AtomIObject)this.y, yNode);
                expected.add(binding);
            }
        }
        BindingGeneratorsTest.assertIteratorValues(gen.iterator(), expected.iterator());
    }

    public void testDatavalueBindingGeneratorObjects() {
        DatavaluedPropertyAtom pattern = new DatavaluedPropertyAtom(dp2, new AtomIConstant(mary), this.z);
        DatavaluePropertyBindingHelper genHelper = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), Collections.singletonList(genHelper));
        BindingGeneratorsTest.assertIteratorValues((Iterator)new BindingToMapIterator(gen.iterator()), new Object[]{Collections.singletonMap(this.z, data1), Collections.singletonMap(this.z, data2)});
    }

    public void testDatavalueBindingGeneratorSubjects() {
        DatavaluedPropertyAtom pattern = new DatavaluedPropertyAtom(dp2, this.x, new AtomDConstant(data2));
        DatavaluePropertyBindingHelper genHelper = new DatavaluePropertyBindingHelper(this.kb.getABox(), pattern);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), Collections.singletonList(genHelper));
        BindingGeneratorsTest.assertIteratorValues((Iterator)new BindingToMapIterator(gen.iterator()), new Object[]{Collections.singletonMap(this.x, mary), Collections.singletonMap(this.x, robert)});
    }

    public void testIsAtomTrue() {
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(mary);
        this.kb.addIndividual(robert);
        this.kb.addPropertyValue(p, mary, robert);
        VariableBinding binding = new VariableBinding(this.kb.getABox());
        binding.set(this.x, mary);
        binding.set(this.y, robert);
        IndividualPropertyAtom atom = new IndividualPropertyAtom(p, this.x, this.y);
        TrivialSatisfactionHelpers tester = new TrivialSatisfactionHelpers(this.kb.getABox());
        BindingGeneratorsTest.assertTrue((boolean)tester.isAtomTrue(atom, binding));
    }

    public void testObjectVariableBindingGenerator() {
        this.kb.addIndividual(mary);
        this.kb.addIndividual(robert);
        this.kb.addIndividual(victor);
        ObjectVariableBindingHelper genHelper = new ObjectVariableBindingHelper(this.kb.getABox(), this.x);
        BindingGeneratorImpl gen = new BindingGeneratorImpl(this.kb.getABox(), new VariableBinding(this.kb.getABox()), Collections.singletonList(genHelper));
        BindingGeneratorsTest.assertIteratorValues((Iterator)new BindingToMapIterator(gen.iterator()), new Object[]{Collections.singletonMap(this.x, mary), Collections.singletonMap(this.x, robert), Collections.singletonMap(this.x, victor)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindingToMapIterator
    implements Iterator<Map<AtomVariable, ATermAppl>> {
        private Iterator<VariableBinding> iter;

        public BindingToMapIterator(Iterator<VariableBinding> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map<AtomVariable, ATermAppl> next() {
            HashMap<AtomVariable, ATermAppl> result = new HashMap<AtomVariable, ATermAppl>();
            VariableBinding binding = this.iter.next();
            for (Map.Entry<? extends AtomVariable, ? extends Node> entry : binding.entrySet()) {
                result.put(entry.getKey(), entry.getValue().getTerm());
            }
            return result;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

