/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.rules.VariableUtils;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class MiscRuleTests
extends PelletTestCase {
    public static final String base = "file:" + PelletTestSuite.base + "swrl-test/misc/";
    private static final URI luigiFamily = URI.create("http://www.csc.liv.ac.uk/~luigi/ontologies/basicFamily");

    public void testBuiltinHeads() {
        KnowledgeBase kb = new KnowledgeBase();
    }

    public void testDataPropertyChain1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl d = ATermUtils.makePlainLiteral("d");
        ATermAppl i = ATermUtils.makeTermAppl("i");
        ATermAppl j = ATermUtils.makeTermAppl("j");
        ATermAppl k = ATermUtils.makeTermAppl("k");
        ATermAppl p = ATermUtils.makeTermAppl("p");
        ATermAppl r = ATermUtils.makeTermAppl("r");
        kb.addDatatypeProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addIndividual(k);
        kb.addPropertyValue(p, i, d);
        kb.addPropertyValue(r, i, j);
        kb.addPropertyValue(r, j, k);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        IndividualPropertyAtom body1 = new IndividualPropertyAtom(r, x, y);
        DatavaluedPropertyAtom body2 = new DatavaluedPropertyAtom(p, x, z);
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, y, z);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        kb.addRule(rule);
        kb.realize();
        MiscRuleTests.assertTrue((boolean)kb.hasPropertyValue(j, p, d));
        MiscRuleTests.assertTrue((boolean)kb.hasPropertyValue(k, p, d));
    }

    public void testDataPropertyChain2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl d = ATermUtils.makePlainLiteral("d");
        ATermAppl i = ATermUtils.makeTermAppl("i");
        ATermAppl j = ATermUtils.makeTermAppl("j");
        ATermAppl k = ATermUtils.makeTermAppl("k");
        ATermAppl p = ATermUtils.makeTermAppl("p");
        ATermAppl r = ATermUtils.makeTermAppl("r");
        kb.addDatatypeProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addIndividual(k);
        kb.addSubClass(ATermUtils.TOP, ATermUtils.makeOr(ATermUtils.makeList((ATerm[])new ATermAppl[]{ATermUtils.makeValue((ATerm)i), ATermUtils.makeValue((ATerm)j), ATermUtils.makeValue((ATerm)k)})));
        kb.addSubClass(ATermUtils.TOP, ATermUtils.makeMin((ATerm)r, 3, (ATerm)ATermUtils.TOP));
        kb.addPropertyValue(p, i, d);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        IndividualPropertyAtom body1 = new IndividualPropertyAtom(r, x, y);
        DatavaluedPropertyAtom body2 = new DatavaluedPropertyAtom(p, x, z);
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, y, z);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        kb.addRule(rule);
        kb.realize();
        MiscRuleTests.assertTrue((boolean)kb.hasPropertyValue(j, p, d));
        MiscRuleTests.assertTrue((boolean)kb.hasPropertyValue(k, p, d));
    }

    public void testInferredProperties() throws Exception {
        ATermAppl d = MiscRuleTests.literal("foo");
        ATermAppl i = MiscRuleTests.term("i");
        ATermAppl j = MiscRuleTests.term("j");
        ATermAppl k = MiscRuleTests.term("k");
        ATermAppl p = MiscRuleTests.term("p");
        ATermAppl r = MiscRuleTests.term("r");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addIndividual(k);
        kb.addDatatypeProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addSubClass(ATermUtils.TOP, ATermUtils.makeMin((ATerm)r, 3, (ATerm)ATermUtils.TOP));
        kb.addSubClass(ATermUtils.TOP, MiscRuleTests.or(MiscRuleTests.value(i), MiscRuleTests.value(j), MiscRuleTests.value(k)));
        kb.addPropertyValue(p, i, d);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, x, z);
        DatavaluedPropertyAtom body1 = new DatavaluedPropertyAtom(p, y, z);
        IndividualPropertyAtom body2 = new IndividualPropertyAtom(r, x, y);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        kb.addRule(rule);
        MiscRuleTests.assertTrue((boolean)kb.hasPropertyValue(j, p, d));
        MiscRuleTests.assertTrue((boolean)kb.hasPropertyValue(k, p, d));
    }

    public void testRuleIndividuals() throws Exception {
        ATermAppl c = ATermUtils.makeTermAppl("C");
        ATermAppl d = ATermUtils.makeTermAppl("D");
        ATermAppl i = ATermUtils.makeTermAppl("i");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(c);
        kb.addClass(d);
        kb.addIndividual(i);
        kb.addType(i, c);
        kb.addRule(new Rule(Arrays.asList(new ClassAtom(d, new AtomIConstant(i))), Arrays.asList(new ClassAtom(c, new AtomIConstant(i)))));
        kb.realize();
        MiscRuleTests.assertTrue((boolean)kb.getTypes(i).contains(Collections.singleton(d)));
    }

    public void testLuigiFamilyJena() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ontModel.read(base + "basicFamilyReference.owl");
        ontModel.read(base + "basicFamilyRules.owl");
        Resource nella = ontModel.createResource(luigiFamily.resolve("#Nella").toString());
        Property hasUncle = ontModel.createProperty(luigiFamily.resolve("#hasUncle").toString());
        Resource dino = ontModel.createResource(luigiFamily.resolve("#Dino").toString());
        MiscRuleTests.assertFalse((boolean)ontModel.contains(nella, hasUncle, (RDFNode)dino));
    }

    public void testLuigiFamilyOWLApi() throws Exception {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology familyRef = manager.loadOntology(URI.create(base + "basicFamilyReference.owl"));
        OWLOntology familyRules = manager.loadOntology(URI.create(base + "basicFamilyRules.owl"));
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntology(familyRef);
        reasoner.loadOntology(familyRules);
        OWLIndividual nella = manager.getOWLDataFactory().getOWLIndividual(luigiFamily.resolve("#Nella"));
        OWLObjectProperty hasUncle = manager.getOWLDataFactory().getOWLObjectProperty(luigiFamily.resolve("#hasUncle"));
        OWLIndividual dino = manager.getOWLDataFactory().getOWLIndividual(luigiFamily.resolve("#Dino"));
        MiscRuleTests.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(nella, (OWLObjectPropertyExpression)hasUncle, dino));
    }

    public void testUncleRule() {
        ATermAppl hasParent = ATermUtils.makeTermAppl("hasParent");
        ATermAppl hasSibling = ATermUtils.makeTermAppl("hasSibling");
        ATermAppl hasUncle = ATermUtils.makeTermAppl("hasUncle");
        ATermAppl male = ATermUtils.makeTermAppl("Male");
        ATermAppl c11 = MiscRuleTests.term("c11");
        ATermAppl c12 = MiscRuleTests.term("c12");
        ATermAppl p1a = MiscRuleTests.term("p1a");
        ATermAppl p2a = MiscRuleTests.term("p2a");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(male);
        kb.addObjectProperty((ATerm)hasParent);
        kb.addObjectProperty((ATerm)hasSibling);
        kb.addObjectProperty((ATerm)hasUncle);
        kb.addIndividual(c11);
        kb.addIndividual(c12);
        kb.addIndividual(p1a);
        kb.addIndividual(p2a);
        kb.addPropertyValue(hasParent, c11, p1a);
        kb.addPropertyValue(hasSibling, c11, c12);
        kb.addPropertyValue(hasParent, c12, p1a);
        kb.addPropertyValue(hasSibling, c12, c11);
        kb.addPropertyValue(hasSibling, p1a, p2a);
        kb.addType(p2a, male);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomIVariable z = new AtomIVariable("z");
        kb.addRule(new Rule(Arrays.asList(new IndividualPropertyAtom(hasUncle, y, z)), Arrays.asList(new IndividualPropertyAtom(hasParent, y, x), new ClassAtom(male, z), new IndividualPropertyAtom(hasSibling, x, z))));
        MiscRuleTests.assertIteratorValues(kb.getObjectPropertyValues(hasUncle, c11).iterator(), new Object[]{p2a});
    }

    public void testVariableUtils1() {
        AtomIVariable var1 = new AtomIVariable("var1");
        AtomIVariable var2 = new AtomIVariable("var2");
        SameIndividualAtom atom = new SameIndividualAtom(var1, var2);
        MiscRuleTests.assertIteratorValues(VariableUtils.getVars(atom).iterator(), new Object[]{var1, var2});
    }

    public void testVariableUtils2() {
        ATermAppl p = ATermUtils.makeTermAppl("p");
        AtomIVariable var1 = new AtomIVariable("var1");
        AtomIVariable var2 = new AtomIVariable("var2");
        IndividualPropertyAtom atom = new IndividualPropertyAtom(p, var1, var2);
        MiscRuleTests.assertIteratorValues(VariableUtils.getVars(atom).iterator(), new Object[]{var1, var2});
    }
}

