/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATerm;
import aterm.ATermAppl;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeEstimate {
    protected static Log log = LogFactory.getLog(SizeEstimate.class);
    public static double UNKNOWN_PROB = 0.5;
    public static boolean CHECK_CONCEPT_SAT = false;
    private KnowledgeBase kb;
    private Map<ATermAppl, Integer> sizes;
    private Map<ATermAppl, Double> avgs;

    public SizeEstimate(KnowledgeBase kb) {
        this.kb = kb;
        this.init();
    }

    private void init() {
        this.sizes = new HashMap<ATermAppl, Integer>();
        this.avgs = new HashMap<ATermAppl, Double>();
        this.sizes.put(ATermUtils.TOP, this.kb.getIndividuals().size());
        this.sizes.put(ATermUtils.BOTTOM, 0);
    }

    public void clearAll() {
        this.init();
    }

    public void computeAll() {
        this.compute(new HashSet<ATermAppl>(this.kb.getClasses()), new HashSet<ATermAppl>(this.kb.getProperties()));
    }

    public boolean isComputed(ATermAppl term) {
        return this.sizes.containsKey(term);
    }

    public void compute(Collection<ATermAppl> concepts, Collection<ATermAppl> properties) {
        concepts.removeAll(this.sizes.keySet());
        properties.removeAll(this.sizes.keySet());
        if (concepts.isEmpty() && properties.isEmpty()) {
            return;
        }
        Timer timer = this.kb.timers.startTimer("sizeEstimate");
        if (log.isInfoEnabled()) {
            log.info((Object)"Size estimation started");
        }
        Random randomGen = new Random();
        HashMap<ATermAppl, Integer> pSubj = new HashMap<ATermAppl, Integer>();
        HashMap<ATermAppl, Integer> pObj = new HashMap<ATermAppl, Integer>();
        Iterator<ATermAppl> i = concepts.iterator();
        while (i.hasNext()) {
            ATermAppl c = i.next();
            if (this.kb.isRealized()) {
                this.sizes.put(c, this.kb.getInstances(c).size());
            } else {
                this.sizes.put(c, 0);
                if (CHECK_CONCEPT_SAT) {
                    if (!this.kb.isSatisfiable(c)) {
                        i.remove();
                    }
                    if (!this.kb.isSatisfiable(ATermUtils.makeNot((ATerm)c))) {
                        i.remove();
                        this.sizes.put(c, this.kb.getIndividuals().size());
                    }
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Initialize " + c + " = " + this.size(c)));
        }
        for (ATermAppl p : properties) {
            this.sizes.put(p, 0);
            pSubj.put(p, 0);
            pObj.put(p, 0);
        }
        Set<ATermAppl> individuals = this.kb.getIndividuals();
        int count = 0;
        for (ATermAppl ind : individuals) {
            float random = randomGen.nextFloat();
            if ((double)random > PelletOptions.SAMPLING_RATIO) continue;
            ++count;
            if (!this.kb.isRealized()) {
                for (ATermAppl c : concepts) {
                    Set<ATermAppl> subs = this.kb.isClassified() ? this.kb.getTaxonomy().getFlattenedSubs(c, false) : SetUtils.EMPTY_SET;
                    subs.remove(ATermUtils.BOTTOM);
                    Bool isKnownType = this.kb.getABox().isKnownType(ind, c, subs);
                    if (!isKnownType.isTrue() && (!CHECK_CONCEPT_SAT || !isKnownType.isUnknown() || !((double)randomGen.nextFloat() < UNKNOWN_PROB))) continue;
                    this.sizes.put(c, this.size(c) + 1);
                }
            }
            for (ATermAppl p : properties) {
                Role role = this.kb.getRBox().getRole((ATerm)p);
                Collection knowns = new HashSet();
                HashSet unknowns = new HashSet();
                if (role.isObjectRole()) {
                    this.kb.getABox().getObjectPropertyValues(ind, role, (Set)knowns, unknowns, true);
                } else {
                    knowns = this.kb.getABox().getObviousDataPropertyValues(ind, role, null);
                }
                if (!knowns.isEmpty()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Update " + p + " by " + knowns.size()));
                    }
                    this.sizes.put(p, this.size(p) + knowns.size());
                    pSubj.put(p, (Integer)pSubj.get(p) + 1);
                }
                if (!role.isObjectRole()) continue;
                role = role.getInverse();
                knowns = new HashSet();
                unknowns = new HashSet();
                this.kb.getABox().getObjectPropertyValues(ind, role, (Set)knowns, unknowns, true);
                if (knowns.isEmpty()) continue;
                pObj.put(p, (Integer)pObj.get(p) + 1);
            }
        }
        if (!this.kb.isRealized()) {
            for (ATermAppl c : concepts) {
                int size = this.size(c);
                if (size == 0) {
                    this.sizes.put(c, 1);
                    continue;
                }
                this.sizes.put(c, (int)((double)size / PelletOptions.SAMPLING_RATIO));
            }
        }
        for (ATermAppl p : properties) {
            int objCount;
            int size = this.size(p);
            if (size == 0) {
                this.sizes.put(p, 1);
            } else {
                this.sizes.put(p, (int)((double)size / PelletOptions.SAMPLING_RATIO));
            }
            Role role = this.kb.getRBox().getRole((ATerm)p);
            ATermAppl invP = role.getInverse() != null ? role.getInverse().getName() : null;
            int subjCount = (Integer)pSubj.get(p);
            if (subjCount == 0) {
                subjCount = 1;
            }
            if ((objCount = ((Integer)pObj.get(p)).intValue()) == 0) {
                objCount = 1;
            }
            this.avgs.put(p, (double)size / (double)subjCount);
            if (invP == null) continue;
            this.avgs.put(invP, (double)size / (double)objCount);
        }
        timer.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sizes:");
            log.debug(this.sizes);
            log.debug((Object)"Averages:");
            log.debug(this.avgs);
        }
        if (log.isInfoEnabled()) {
            DecimalFormat nf = new DecimalFormat("0.00");
            log.info((Object)("Size estimation finished in " + nf.format((double)timer.getLast() / 1000.0) + " sec"));
        }
    }

    public int size(ATermAppl c) {
        if (!this.sizes.containsKey(c)) {
            throw new InternalReasonerException("Size estimate for " + c + " is not found!");
        }
        return this.sizes.get(c);
    }

    public double avg(ATermAppl pred) {
        if (!this.avgs.containsKey(pred)) {
            throw new InternalReasonerException("Average estimate for " + pred + " is not found!");
        }
        return this.avgs.get(pred);
    }
}

