<?xml version="1.0"?>
<!-- version: June 21, 2006 -->

<!-- XSLT Stylesheet zum Splitten einer mondial.xml-Datei in                
  ein mondial-root.xml, ein Continents-File, ein Country-File, 
  mehrere City-Files, Province-Files und ein Organization-File     -->

<!-- You need a XSLT-Processor which implements XSLT 2.0 -->
<!-- use: ***********
     call 
     java -jar /homewap1/dbis/XML-Tools/saxon/saxon7.jar \
     -o bla.xml mondial.xml split-dbxlink-mondial.xsl

     note that output is written to the files that are specified in the stylesheet's
     <xsl:result-document> tags. Nothing is written to bla.xml.
 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xlink="http://www.w3.org/1999/xlink" 
                xmlns:dbxlink="http://dbis.informatik.uni-goettingen.de/linxis" 
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                version="1.0"> 

<!-- *************************************************************************************** -->
<!-- if variable "dbxlink_on" is set to value "0", the dbxlink:transparent                   -->
<!-- attributes are omitted. If set to "1", the xlink elements are equipped with the         -->
<!-- dbxlink attrs.                                                                          -->

<xsl:variable name="dbxlink_on" select="1"/><!-- Change the value here -->

<!-- *************************************************************************************** -->

<!-- *************************************************************************************** -->
<!-- if variable "schema_on" is set to value "1", all XML instances are associated with      -->
<!-- the "mondial-distributed.xsd" via xsi:noNamespaceSchemaLocation attribute.              -->
<!-- if set to value "0", the XML instances are associated with the specific DTD             -->
<!-- via "<!DOCTYPE SYSTEM '???.dtd'>" processing instruction                                -->

<xsl:variable name="schema_on" select="0"/> <!-- Change the value here -->

<!-- *************************************************************************************** -->

<!-- *************************************************************************************** -->
<!-- here, variables are defined for the absolute http-addresses                             -->
<!-- where the mondial XML instances are located.                                            -->
<!-- for testing purposes, the mondial-distributed instance files can be distributed         -->
<!-- among several host locations, or all set to the same location.                          -->
<!-- cities and provinces -->
<xsl:variable name="mondial-location-1">http://linxis01.ifi.informatik.uni-goettingen.de:8080/exist/servlet/db/LinXIS/</xsl:variable>

<!-- geo: rivers,lakes,seas,islands,mountains,deserts (all in one file) -->
<xsl:variable name="mondial-location-2">http://linxis02.ifi.informatik.uni-goettingen.de:8080/exist/servlet/db/LinXIS/</xsl:variable>

<!-- countries and continents -->
<xsl:variable name="mondial-location-3">http://ap34.ifi.informatik.uni-goettingen.de:8080/exist/servlet/db/LinXIS/</xsl:variable>
              
<!-- *************************************************************************************** -->


<xsl:output method="xml" indent="yes"/>
<xsl:variable name="apos">'</xsl:variable>

<!-- *******************************Mondial************************************** -->
<!-- base template selects the mondial element                                     -->
<!-- and traverses country, organization, continent and membership elements       -->
<!-- **************************************************************************** -->

<xsl:template match="mondial">
  <xsl:message> Stylesheet for splitting Mondial into a distributed version</xsl:message>
      <xsl:message> Splitting mondial.xml file </xsl:message>
  <xsl:message> Processing....Please wait! </xsl:message>

  <xsl:result-document href="mondial-root.xml">
  <xsl:if test="$schema_on=0">
    <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE mondial SYSTEM "mondial-root.dtd"&gt;&#10;</xsl:text>
  </xsl:if>
  <mondial> 
    <xsl:element name="countries">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of 
          select="concat($mondial-location-3,'countries.xml#xpointer(/countries/country)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="continents">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-3,'continents.xml#xpointer(/continents/continent)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="organizations">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-3,'organizations.xml#xpointer(/organizations/organization)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="rivers">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/geo/river)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="seas">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/geo/sea)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="lakes">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/lakes/lake)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="mountains">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/geo/mountain)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="islands">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/geo/island)')"/>
      </xsl:attribute>
    </xsl:element> 

    <xsl:element name="deserts">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/geo/desert)')"/>
      </xsl:attribute>
    </xsl:element> 
  </mondial>
  </xsl:result-document>  

  <xsl:result-document href="countries.xml">
  <xsl:if test="$schema_on=0">
    <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE countries SYSTEM "countries.dtd"&gt;&#10;</xsl:text>
  </xsl:if>
  <countries>
    <xsl:if test="$schema_on=1">
      <xsl:attribute name="xsi:noNamespaceSchemaLocation">mondial-distributed.xsd</xsl:attribute>
    </xsl:if>
    <xsl:apply-templates select="country"/>  
  </countries>
  </xsl:result-document>  

  <xsl:result-document href="organizations.xml">
    <xsl:if test="$schema_on=0">
      <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE organizations SYSTEM "organizations.dtd"&gt;&#10;</xsl:text>
    </xsl:if>
    <organizations>
      <xsl:if test="$schema_on=1">
        <xsl:attribute name="xsi:noNamespaceSchemaLocation">mondial-distributed.xsd</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="organization"/>
    </organizations>
  </xsl:result-document>

  <xsl:result-document href="continents.xml">
    <xsl:if test="$schema_on=0">
      <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE continents SYSTEM "continents.dtd"&gt;&#10;</xsl:text>
    </xsl:if>
    <continents>
      <xsl:if test="$schema_on=1">
        <xsl:attribute name="xsi:noNamespaceSchemaLocation">mondial-distributed.xsd</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="continent"/>
    </continents>
  </xsl:result-document>

  <xsl:result-document href="memberships.xml">
    <xsl:if test="$schema_on=0">
      <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE memberships SYSTEM "memberships.dtd"&gt;&#10;</xsl:text>
    </xsl:if>
    <xsl:element name="memberships">
      <xsl:if test="$schema_on=1">            
          <xsl:attribute name="xsi:noNamespaceSchemaLocation">mondial-distributed.xsd</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:type">extended</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">duplicate-element</xsl:attribute>
      </xsl:if>
      <xsl:call-template name="for_members"/>
    </xsl:element>
  </xsl:result-document>

  <xsl:result-document href="geo.xml">
    <xsl:if test="$schema_on=0">
      <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE geo SYSTEM "geo.dtd"&gt;&#10;</xsl:text>    
    </xsl:if>
    <geo>
      <xsl:apply-templates select="sea"/>
      <xsl:apply-templates select="lake"/>
      <xsl:apply-templates select="river"/>
      <xsl:apply-templates select="mountain"/>
      <xsl:apply-templates select="island"/>
      <xsl:apply-templates select="desert"/>
    </geo>
  </xsl:result-document>

  <xsl:message> Finished. </xsl:message>
    
</xsl:template>

<!-- ********************************************************************************** 
 Erzeuge Continent-Elemente die als Kinder den Name und die Flaeche des 
  Continents besitzen 
*************************************************************************************** -->

<xsl:template match="continent">
    <continent>
    <xsl:copy-of select="*"/>
    </continent>
</xsl:template>

<!-- *******************************Country************************************** -->
<!-- Erzeuge das Output-File mit Name wobei der Car_code des Landes genutzt wird, -->
<!-- z.B. cities-D.xml fuer Cities in Deutschland (fuer City und Province)      -->
<!-- **************************************************************************** -->

<xsl:template match="country">

  <!-- ************************************************************************************ -->
  <!-- Dieser Teil angewendet erzeugt ein xml-file ohne provinces,cities                    -->
  <!-- und ohne memberships und id-Attribute                                                -->
  <!-- Das Capital-Element ist neu eingefuegt und zeigt auf die Hauptstadt im cities-File   -->
  <!-- Es wird mittels eines Cities Elements auf die Staedte des Landes im entsprechenden   -->
  <!--       cities-File verwiesen. Das gleiche gilt fuer das Provinces-Element             -->
  <!-- ************************************************************************************ -->

 <country>
   <xsl:copy-of select="@*[not(name()='memberships') and not(name()='capital')]"/>
   <xsl:copy-of select="*[not(name()='province') and not(name()='city') and 
        not(name()='border') and not(name()='encompassed')]"/>
<!--
   <xsl:element name="density">
     <xsl:attribute name="xlink:type">simple</xsl:attribute>
     <xsl:if test="$dbxlink_on=1">
       <xsl:attribute name="dbxlink:transparent">group-in-element insert-bodies</xsl:attribute>
     </xsl:if>
     <xsl:attribute name="xlink:href">../population/text() div ../@area </xsl:attribute>
   </xsl:element>
   <xsl:element name="urban_pop">
     <xsl:attribute name="xlink:type">simple</xsl:attribute>
     <xsl:if test="$dbxlink_on=1">
       <xsl:attribute name="dbxlink:actuate">noaction</xsl:attribute> 
     </xsl:if>
     <xsl:attribute name="xlink:href">sum(..//city/population/text())</xsl:attribute>
   </xsl:element>
-->

   <xsl:variable name="citiesfile">
     <xsl:value-of select="concat($mondial-location-1,'cities-',@car_code,'.xml')"/>
   </xsl:variable>

   <xsl:if test="@capital">
     <xsl:element name="capital">
       <xsl:variable name="capitalname" select="id(@capital)/name"/>
       <xsl:attribute name="xlink:type">simple</xsl:attribute>
       <xsl:if test="$dbxlink_on=1">
          <xsl:attribute name="dbxlink:transparent">make-attribute insert-nodes</xsl:attribute>
       </xsl:if>
       <xsl:attribute name="xlink:href">
         <xsl:value-of select="concat($citiesfile,'#xpointer(/cities/city[name=',$apos,$capitalname,$apos,'])')"/>
       </xsl:attribute>
     </xsl:element> 
   </xsl:if>
   <xsl:if test=".//city">
     <xsl:element name="cities">
       <xsl:attribute name="xlink:type">simple</xsl:attribute>
       <xsl:if test="$dbxlink_on=1">
         <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
       </xsl:if>
       <xsl:attribute name="xlink:href">
          <xsl:value-of select="concat($citiesfile,'#xpointer(/cities/city)')"/>
       </xsl:attribute>
     </xsl:element> 
   </xsl:if>
   <xsl:if test=".//province">
     <xsl:element name="provinces">
       <xsl:attribute name="xlink:type">simple</xsl:attribute>
         <xsl:if test="$dbxlink_on=1">
           <xsl:attribute name="dbxlink:transparent">drop-element insert-nodes</xsl:attribute>
         </xsl:if>
       <xsl:attribute name="xlink:href">
         <xsl:value-of select="concat($mondial-location-1,'/provs-',@car_code,'.xml#xpointer(/provinces/province)')"/>
         </xsl:attribute>
     </xsl:element> 
   </xsl:if>
   <xsl:if test="encompassed">
       <xsl:apply-templates select="encompassed"/>
   </xsl:if>
   <xsl:apply-templates select="border"/>
 </country>                
    
    <!-- ******************************************************************************************** -->
    <!-- Dynamisches Generieren des City-Files abhaengig vom Namen des Landes                 -->
    <!-- Erzeugt das Outputfile mit Doctype auf die entsprechende DTD                  -->
    <!-- Filename fuer cities und provinces                                  -->
    <!-- ******************************************************************************************** -->    

  <xsl:if test=".//city">
    <xsl:variable name="output_city_file">
      <xsl:value-of select="concat('Cities/cities-',@car_code,'.xml')"/>
    </xsl:variable>
    <xsl:result-document href="{$output_city_file}">
      <xsl:if test="$schema_on=0">
        <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE cities SYSTEM "../cities.dtd"&gt;&#10;</xsl:text>    
      </xsl:if>
      <cities>
        <xsl:if test="$schema_on=1">            
          <xsl:attribute name="xsi:noNamespaceSchemaLocation">mondial-distributed.xsd</xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select=".//city"/>
      </cities>
    </xsl:result-document>
  </xsl:if>

  <xsl:if test="./province">
    <xsl:variable name="output_prov_file">
      <xsl:value-of select="concat('Provs/provs-',@car_code,'.xml')"/>
    </xsl:variable>
    <xsl:result-document href="{$output_prov_file}">
      <xsl:if test="$schema_on=0">
        <xsl:text disable-output-escaping="yes">&#10;&lt;!DOCTYPE provinces SYSTEM "../provinces.dtd"&gt;&#10;</xsl:text>    
      </xsl:if>
      <provinces>
        <xsl:if test="$schema_on=1">            
          <xsl:attribute name="xsi:noNamespaceSchemaLocation">mondial-distributed.xsd</xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="province"/>
      </provinces>
    </xsl:result-document>
  </xsl:if>  

</xsl:template>

<!-- ******************************************************************** -->
<!-- Fuegt die Kontinentzugehoerigkeiten zu den jeweiligen Laendern hinzu -->
<!-- ******************************************************************** -->

<xsl:template match="encompassed">
    <xsl:variable name="continent_name" select="id(@continent)/name"/>
    <xsl:element name="encompassed">
        <xsl:attribute name="xlink:type">simple</xsl:attribute>
        <xsl:if test="$dbxlink_on=1">
           <xsl:attribute name="dbxlink:transparent">group-in-element insert-nodes</xsl:attribute>
        </xsl:if>
        <xsl:attribute name="xlink:href">
            <xsl:value-of select="concat($mondial-location-3, 'continents.xml#xpointer(/continents/continent[name=',$apos,$continent_name,$apos,'])')"/>
        </xsl:attribute>
    
    <xsl:attribute name="percentage">
        <xsl:value-of select="@percentage"/>
    </xsl:attribute>
    </xsl:element>
</xsl:template>

<!-- ********************************Border*************************************** -->
<!-- Ersetze alle Border-Elemente durch neighbor-Elemente der Form                 -->
<!-- <neighbor xlink:type="simple" xlink:href="<linkfile>" borderlength="<length>" -->
<!-- ***************************************************************************** -->

<xsl:template match="border">
   <xsl:element name="neighbor">
    <xsl:variable name="neighbor_code" select="@country"/>
    <xsl:attribute name="xlink:type">simple</xsl:attribute>
    <xsl:if test="$dbxlink_on=1">
      <xsl:attribute name="dbxlink:transparent">duplicate-element insert-bodies</xsl:attribute>
    </xsl:if>
    <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-3,'countries.xml#xpointer(/countries/country[@car_code=',$apos,$neighbor_code,$apos,'])')"/>
    </xsl:attribute>
    <xsl:attribute name="borderlength">
                <xsl:value-of select="@length"/>  
    </xsl:attribute>
   </xsl:element>
</xsl:template>


<!-- *******************************Cities*************************************** -->
<!-- Outputs city elements, without country, province and id attributes           -->
<!-- insert country as xlink element referencing the country element              -->
<!-- if present, insert province element as xlink ref'ing the province element    -->
<!-- **************************************************************************** -->

<xsl:template match="city">
 <city>
   <xsl:copy-of select="@*[not(name()='country') and not(name()='province') and not(name()='id')]"/>
   <xsl:copy-of select="name"/>

   <xsl:variable name="country" select="@country"/>
   <xsl:element name="country">
     <xsl:attribute name="xlink:type">simple</xsl:attribute>
     <xsl:if test="$dbxlink_on=1">
       <xsl:attribute name="dbxlink:transparent">make-attribute insert-nodes</xsl:attribute>
     </xsl:if>
     <xsl:attribute name="xlink:href">
       <xsl:value-of select="concat($mondial-location-3, 'countries.xml#xpointer(/countries/country[@car_code=',$apos,$country,$apos,'])')"/>
     </xsl:attribute> 
   </xsl:element>

   <xsl:copy-of select="*[not(name()='name') and not(name()='located_at')]"/>

   <xsl:for-each select="located_at">
     <xsl:variable name="watertype" select="./@watertype"/>
     <xsl:variable name="thewater" select="id(../located_at/@*[name()=$watertype])"/>
     <xsl:variable name="watername" select="$thewater/name"/>
     <xsl:element name="located_at">
       <xsl:attribute name="xlink:type">simple</xsl:attribute>
       <xsl:if test="$watertype">
         <xsl:attribute name="watertype" select="$watertype"/>
       </xsl:if>
       <xsl:if test="$dbxlink_on=1">
         <xsl:attribute name="dbxlink:transparent">group-in-element insert-nodes</xsl:attribute>
       </xsl:if>
       <xsl:attribute name="xlink:href">
         <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/', $watertype, 's/',$watertype,'[name=',$apos,$watername,$apos,'])')"/>
       </xsl:attribute>
     </xsl:element>
   </xsl:for-each>
 </city>
</xsl:template>

 
<!-- *******************************Provinces************************************ -->
<!-- select all province elements inside a country element,                       -->
<!-- with the city elements as locator elements to the "real" city element        -->
<!-- and write them to the "provs-??.xml" output file                             -->
<!-- **************************************************************************** -->

<xsl:template match="province">
  <province>
    <xsl:copy-of select="name"/>

    <xsl:variable name="country" select="@country"/>
    <xsl:element name="country">
      <xsl:attribute name="xlink:type">simple</xsl:attribute>
      <xsl:if test="$dbxlink_on=1">
        <xsl:attribute name="dbxlink:transparent">make-attribute insert-nodes</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-3, 'countries.xml#xpointer(/countries/country[@car_code=',$apos,$country,$apos,'])')"/>
      </xsl:attribute> 
    </xsl:element>

    <xsl:if test="@capital">
    <xsl:element name="capital">
        <xsl:variable name="hauptstadt" select="@capital"/>
          <xsl:variable name="ausgewertet">
             <xsl:value-of select="$hauptstadt"/>
          </xsl:variable>
        <xsl:variable name="derefed" select="id($ausgewertet)"/>
        <xsl:variable name="land" select="@country"/>
        <xsl:variable name="diestadt" select="$derefed/name"/>
       <xsl:attribute name="xlink:type">simple</xsl:attribute>
         <xsl:if test="$dbxlink_on=1">
           <xsl:attribute name="dbxlink:transparent">group-in-element insert-bodies</xsl:attribute>
         </xsl:if>
       <xsl:attribute name="xlink:href">
        <xsl:value-of select="concat($mondial-location-1,'cities-',$land,'.xml#xpointer(/cities/city[name=',$apos,$diestadt,$apos,'])')"/>
       </xsl:attribute>
    </xsl:element>
    </xsl:if>        
      <xsl:copy-of select="*[not(name()='city') and not(name()='name')]"/>
  </province>
</xsl:template>



<!-- *****************************Organizations ***************************************** 
  Create an organization element with attribute abbrev (abbreviation)
  Copy each element except for members
  If the organization mondial.xml has a headq attribute, then create an headq
     XLink Element for it.
  ************************************************************************************* -->

<xsl:template match="organization">
  <xsl:element name="organization">
    <xsl:attribute name="abbrev">
      <xsl:value-of select="abbrev"/>
    </xsl:attribute>
    <xsl:copy-of select="*[not(name()='abbrev') and not(name()='members')]"/>
    <xsl:if test="@headq">
      <xsl:variable name="headqCity" select="id(@headq)"/>
      <xsl:variable name="headqCityCountry" select="$headqCity/@country"/>
      <xsl:variable name="headqCityName" select="$headqCity/name"/>
      <xsl:element name="headq">
        <xsl:attribute name="xlink:type">simple</xsl:attribute>
          <xsl:if test="$dbxlink_on=1">
            <xsl:attribute name="dbxlink:transparent">make-attribute insert-nodes</xsl:attribute>
          </xsl:if>
        <xsl:attribute name="xlink:href">
          <xsl:value-of select="concat($mondial-location-1,'/cities-',$headqCityCountry,'.xml#xpointer(/cities/city[name=',$apos,$headqCityName,$apos,'])')"/>
        </xsl:attribute>
      </xsl:element>
    </xsl:if>
    <xsl:if test="members">
      <xsl:for-each select="members">
        <xsl:variable name="countries" select="concat($apos,replace(@country,' ',concat($apos,',',$apos)),$apos)"/>
        <xsl:element name="member">
          <xsl:copy-of select="@type"/>
          <xsl:attribute name="xlink:type">simple</xsl:attribute>
          <xsl:if test="$dbxlink_on=1">
            <xsl:attribute name="dbxlink:transparent">duplicate-element insert-bodies</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="xlink:href">
            <xsl:value-of select="concat($mondial-location-3, 'countries.xml#xpointer(/countries/country[fn:index-of((',$countries,'), @car_code) ge 1])')"/>
          </xsl:attribute> 
        </xsl:element>
      </xsl:for-each>
    </xsl:if>
  </xsl:element>
</xsl:template>


<!-- ******************************* geo Things *********************************** -->
<!--                                                                                -->
<!-- ****************************************************************************** -->

<xsl:template match="sea">
  <sea>
    <xsl:copy-of select="*[not (name()='located') and not (name()='bordering')]"/>
    <xsl:apply-templates select="located"/>
  </sea>    
</xsl:template>

<xsl:template match="river">
  <river>
    <xsl:copy-of select="*[not (name()='located') and not (name()='to')]"/>
    <xsl:variable name="flowsintoname" select="id(to/@water)/name"/>
    <xsl:element name="flowsinto">
        <xsl:attribute name="xlink:type">simple</xsl:attribute>
        <xsl:if test="$dbxlink_on=1">
          <xsl:attribute name="dbxlink:transparent">group-in-element insert-nodes</xsl:attribute>
        </xsl:if>
        <xsl:attribute name="xlink:href">
          <xsl:value-of select="concat($mondial-location-2,'geo.xml#xpointer(/geo/',to/@watertype,'[name=',$apos,$flowsintoname,$apos,'])')"/>
        </xsl:attribute>
    </xsl:element>
    <xsl:apply-templates select="located"/>
  </river>
</xsl:template>

<xsl:template match="lake|mountain|island|desert">
  <xsl:copy>
    <xsl:copy-of select="*[not (name()='located')]"/>
    <xsl:apply-templates select="located"/>
  </xsl:copy>
</xsl:template>

<!--
<xsl:template match="mountain">
  <mountain>
    <xsl:copy-of select="*[not (name()='located') and not (name()='country')]"/>
    <xsl:apply-templates select="located"/>
  </mountain>    
</xsl:template>

<xsl:template match="island">
  <island>
    <xsl:copy-of select="*[not (name()='located') and not (name()='country')]"/>
    <xsl:apply-templates select="located"/>
  </island>    
</xsl:template>

<xsl:template match="desert">
  <desert>
    <xsl:copy-of select="*[not (name()='located') and not (name()='country')]"/>
    <xsl:apply-templates select="located"/>
  </desert>    
</xsl:template>
-->
<xsl:template match="located">
  <xsl:variable name="country" select="@country"/>
  <xsl:element name="country">
    <xsl:attribute name="xlink:type">simple</xsl:attribute>
    <xsl:if test="$dbxlink_on=1">
      <xsl:attribute name="dbxlink:transparent">make-attribute insert-nodes</xsl:attribute>
    </xsl:if>
    <xsl:attribute name="xlink:href">
      <xsl:value-of select="concat($mondial-location-3, 'countries.xml#xpointer(/countries/country[@car_code=',$apos,$country,$apos,'])')"/>
    </xsl:attribute> 
  </xsl:element>
</xsl:template>

<!-- *********************************************************************************************** -->
<!-- Erzeugtes Template um das memberships-File zu fuellen                                   -->
<!-- Dabei wird ein Country-Element erzeugt das folgende Form hat:                     -->
<!-- <country id="<car_code>" xlink:type="locator" xlink:href="<file>"/>                 -->
<!-- ............................................................................................... -->
<!-- Es wird ein Element organization erzeugt das als id die Abbreviation der Organisation hat       -->
<!-- und als zusaetzliches Attribute ein xlink:href auf das orgs-file mit xpath-Ausdruck         -->
<!-- hat.                                                 -->
<!-- ............................................................................................... -->
<!-- Laufe durch alles Organisationen, merke die Organisation, laufe ueber alle Members. Es wird das -->
<!-- country Attribut das ein IDREFS ist, dereferenziert(muss mit xsl:for-each gemacht werden)       -->
<!-- Der memebers-Type wird in einer Variable gespeichert und fuer jedes Ergebnis genutzt         -->
<!-- Folgendes Ergebnis:                                          -->
<!-- <organization xlink:type="arc" xlink:from="B" xlink:to="org-CERN" membership_type="member" />   -->
<!-- *********************************************************************************************** -->

<xsl:template name="for_members">
    <xsl:for-each select="country">
        <xsl:if test="@memberships">
            <xsl:element name="country">
              <xsl:attribute name="xlink:label">
                <xsl:value-of select="@car_code"/>
              </xsl:attribute>
              <xsl:attribute name="xlink:type">locator</xsl:attribute>
              <xsl:if test="$dbxlink_on=1">
                <xsl:attribute name="dbxlink:transparent">drop-element insert-nothing</xsl:attribute>
               </xsl:if>
              <xsl:attribute name="xlink:href">
                  <xsl:value-of select="concat('countries.xml#xpointer(//country[@car_code=',$apos,@car_code,$apos,'])')"/>    
              </xsl:attribute>
            </xsl:element>
        </xsl:if>
    </xsl:for-each>
    <xsl:for-each select="organization">
        <xsl:element name="organization">
          <xsl:attribute name="xlink:label">
            <xsl:value-of select="@id"/>
          </xsl:attribute>
          <xsl:attribute name="xlink:type">locator</xsl:attribute>
          <xsl:if test="$dbxlink_on=1">
             <xsl:attribute name="dbxlink:transparent">drop-element insert-nothing</xsl:attribute>
          </xsl:if>    
          <xsl:attribute name="xlink:href">
            <xsl:value-of select="concat('organizations.xml#xpointer(//organization[@abbrev=',$apos,abbrev,$apos,'])')"/>   
          </xsl:attribute>
        </xsl:element>
    </xsl:for-each>

    <xsl:for-each select="organization">
        <xsl:variable name="orga" select="@id"/>
        <xsl:for-each select="members">
            <xsl:variable name="type" select="@type"/>
               <xsl:for-each select="id(@country)">    
            <xsl:element name="membership">
              <xsl:attribute name="xlink:type">arc</xsl:attribute>
              <xsl:if test="$dbxlink_on=1">
                 <xsl:attribute name="dbxlink:transparent">group-arc-elem dup-from-elem ins-from-bodies dup-to-elem ins-to-bodies</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="xlink:from">
                <xsl:value-of select="@car_code"/>
              </xsl:attribute>
              <xsl:attribute name="xlink:to">
                <xsl:value-of select="$orga"/>
              </xsl:attribute>
              <xsl:attribute name="membership_type">
                <xsl:value-of select="$type"/>
              </xsl:attribute>
             </xsl:element>
               </xsl:for-each>
        </xsl:for-each>
    </xsl:for-each>    
</xsl:template>

</xsl:stylesheet>

        
